//********************************************************************
//* Programme			: Outils
//*	Auteur				: Emmanuel Chauvin.
//* Date de cration	: 19/06/2001 
//* 
//* Description			: Vie Artificielle.
//*
//********************************************************************

#include <windows.h>  
#include <stdio.h>
#include <sys\timeb.h> 
#include <math.h>
#include "Vie_Agent.h"
#include "outils.h"
#include "calcul.h"


BYTE Byte_masq[9] = { 0x00,0x01,0x02,0x04,0x08,0x10,0x020,0x40,0x80};

int Alea (int alea)
{
	if (alea > 0)
		return ((int) (rand () % alea)+1);
	else
		return 0;
}

unsigned int x_plus (unsigned int x,int b)
{
	int c = x + (int)b;
	if (c > (int)MAX_X)
		return((unsigned int)(c - MAX_X));
	else
	if (c < 1)
		return((unsigned int)(MAX_X + c));
	else
		return((unsigned int)c);
}
unsigned int y_plus (unsigned int  y,int b)
{
	int c = y + (int)b;
	if (c > (int)MAX_Y)
		return((unsigned int)(c - MAX_Y));
	else
	if (c < 1)
		return((unsigned int)(MAX_Y + c));
	else
		return((unsigned int)c);
}

unsigned int x_plus1 (unsigned int x)
{
	if (x >= MAX_X)
		x = 1;
	else
		x++;
	return (x);
}
unsigned int x_moins1 (unsigned int x)
{
	if (x <= 1)
		x = MAX_X;
	else
		x--;
	return (x);
}
unsigned int y_plus1 (unsigned int y)
{
	if (y >= MAX_Y)
		y = 1;
	else
		y++;
	return (y);
}
unsigned int y_moins1 (unsigned int y)
{
	if (y <= 1)
		y = MAX_Y;
	else
		y--;
	return (y);
}

void Nourriture_plus (int *a,int b)
{
	int c = (int)*a + (int)b;
	if (c > (int)MAX_NOURRI)
		*a = (int)MAX_NOURRI;
	else
		*a = (int)c;
}


void Nourriture_moins (int *a,int b)
{
	int c = (int)*a - (int)b;
	if (c < 0)
		*a = (int)0;
	else
		*a = (int)c;
}

void Init_Alea (void)
{
	struct timeb temps;

   // La fonction alatoire est dfinie avec l'horloge du micro. 
   ftime (&temps);
   srand (temps.millitm);
}

VOID Dessiner_cellule (HDC hdc,unsigned int x, unsigned int y)
{
	x*=DIM_CELLULE;
	y*=DIM_CELLULE;
	Rectangle (hdc,x,y,x+DIM_CELLULE,y+DIM_CELLULE);
}

VOID Dessiner_cellule_marque_ass (HDC hdc,unsigned int x, unsigned int y)
{
	RECT rect;

	x*=DIM_CELLULE;
	y*=DIM_CELLULE;

	SetRect (&rect,x,y,x+DIM_CELLULE,y+DIM_CELLULE);
	FillRect(hdc, &rect, (HBRUSH) (8)); 
}

VOID Dessiner_cellule_marque_dis (HDC hdc,unsigned int x, unsigned int y)
{
	RECT rect;

	x*=DIM_CELLULE;
	y*=DIM_CELLULE;

	SetRect (&rect,x,y,x+DIM_CELLULE,y+DIM_CELLULE);
	FillRect(hdc, &rect, (HBRUSH) (12)); 
}


VOID Dessiner_zone_associe (HDC hdc,int X_MOVE, int Y_MOVE)
{
	int x,y,x0,y0;

	if (X_MOVE == 0 && Y_MOVE == 0)
	{
		x=DIM_CELLULE*43;
		y=DIM_CELLULE*71;
		x0=DIM_CELLULE*57;
		y0=DIM_CELLULE*86;

		Rectangle (hdc,x,y,x0,y0);
	}
	else
	{
		x = x_plus(43,X_MOVE);
		y = x_plus(71,Y_MOVE);
		x0 = x_plus(x,13);
		y0 = y_plus(y,14);
		if (x0 != (x+13))
		{
			if (y0 != (y+14))
			{
				x*=DIM_CELLULE;
				y*=DIM_CELLULE;
				x0++;
				y0++;
				x0*=DIM_CELLULE;
				y0*=DIM_CELLULE;

				// 4 rectangles.
				Rectangle (hdc,x,y,(MAX_X+1)*DIM_CELLULE,(MAX_Y+1)*DIM_CELLULE);
				Rectangle (hdc,DIM_CELLULE,DIM_CELLULE,x0,y0);
				Rectangle (hdc,x,DIM_CELLULE,(MAX_X+1)*DIM_CELLULE,y0);
				Rectangle (hdc,DIM_CELLULE,y,x0,(MAX_Y+1)*DIM_CELLULE);
			}
			else
			{
				x*=DIM_CELLULE;
				y*=DIM_CELLULE;
				x0++;
				y0++;
				x0*=DIM_CELLULE;
				y0*=DIM_CELLULE;

				// 2 rectangles.
				Rectangle (hdc,x,y,(MAX_X+1)*DIM_CELLULE,y0);
				Rectangle (hdc,DIM_CELLULE,y,x0,y0);
			}
		}
		else
		if (y0 != (y+14))
		{
			x*=DIM_CELLULE;
			y*=DIM_CELLULE;
			x0++;
			y0++;
			x0*=DIM_CELLULE;
			y0*=DIM_CELLULE;

			// 2 rectangles.
			Rectangle (hdc,x,y,x0,(MAX_Y+1)*DIM_CELLULE);
			Rectangle (hdc,x,DIM_CELLULE,x0,y0);
		}
		else
		{
			x*=DIM_CELLULE;
			y*=DIM_CELLULE;
			x0++;
			y0++;
			x0*=DIM_CELLULE;
			y0*=DIM_CELLULE;

			// 1 rectangle.
			Rectangle (hdc,x,y,x0,y0);
		}

	}
}

VOID Remplir_Cellule_Sel (HDC hdc,unsigned int x, unsigned int y)
{
	RECT rect;
	x*=DIM_CELLULE;
	y*=DIM_CELLULE;
		
	SetRect (&rect,x,y,x+DIM_CELLULE,y+DIM_CELLULE);
	FillRect(hdc, &rect, (HBRUSH) (COLOR_ACTIVECAPTION+1)); 
}

VOID Dessiner_cellule_test (HDC hdc,unsigned int x, unsigned int y)
{
	x*=2;
	y*=2;
	SetPixelV(hdc,x,y,RGB(180,0,0));
	SetPixelV(hdc,x-1,y,RGB(180,0,0));
	SetPixelV(hdc,x,y-1,RGB(180,0,0));
	SetPixelV(hdc,x-1,y-1,RGB(180,0,0));
}

VOID Dessiner_nourriture (HDC hdc,unsigned int x, unsigned int y)
{
	x*=2;
	y*=2;
	SetPixelV(hdc,x,y,RGB(0,200,255));
	SetPixelV(hdc,x-1,y,RGB(0,200,255));
	SetPixelV(hdc,x,y-1,RGB(0,200,255));
	SetPixelV(hdc,x-1,y-1,RGB(0,200,255));
}
VOID Effacer_cellule (HDC hdc,unsigned int x, unsigned int y)
{
	x*=2;
	y*=2;
	SetPixelV(hdc,x,y,RGB(0,0,0));
	SetPixelV(hdc,x-1,y,RGB(0,0,0));
	SetPixelV(hdc,x,y-1,RGB(0,0,0));
	SetPixelV(hdc,x-1,y-1,RGB(0,0,0));
}

void Lib_direction (int Dir,char *Lib)
{
	switch (Dir)
	{
			case eHaut :
				strcpy (Lib,"haut");
				break;
			case eBas :
				strcpy (Lib,"bas");
				break;
			case eDroite :
				strcpy (Lib,"droite");
				break;
			case eGauche :
				strcpy (Lib,"gauche");
				break;
	}
}

void Lib_action (int action,char *Lib)
{
	switch (action)
	{
			case eDeplacer :
				strcpy (Lib,"Dplacer");
				break;
			case eAssocier :
				strcpy (Lib,"Associer");
				break;
			case eManger :
				strcpy (Lib,"Manger");
				break;
			case eDistribuer :
				strcpy (Lib,"Distribuer");
				break;
			case eCreer :
				strcpy (Lib,"Crer");
				break;
	}
}

// Supprime un caractre de la chaine.
void delete_char(char * str,char c, int len)
{
	if (len > 0)
	{
		char * temp = (char *)malloc (len);
		if (str != NULL)
		{
			int i;
			memcpy (temp,str,len);
			memset (str,0,len);
			int j = 0;
			for (i = 0;i< len;i++)
			{
				if (temp[i] != c)
				{
					str[j] = temp[i];
					j++;
				}
			}
		}
	}
}

// Conversion float en dfloat
dfloat conv_float_dfloat (float f)
{
	dfloat df;
	int a;
	char str[7];

	memset (str,0,7);
	sprintf(str,"%+.4f",f);

	a = atoi(&str[3]);

	if (a == 0)
	{
		if (f > 0.9999 || f < -0.9999)
			a = 9999;
	}
	//if (a == 5)
	//	OutputDebugString("cinq ! \n");

	memcpy (&df,&a,2);

	if (f > 0)
		df.signe = 1;

	return df;
}

// Conversion dfloat en float
float conv_dfloat_float (dfloat df)
{
	float f;
	int a = 0;
	int signe = 0;

	if (df.signe == 1)
	{
		signe = 1;
		df.signe = 0;
	}

	memcpy(&a,&df,2);

	f = (float)a/10000;

	if (signe == 0)
		f*=-1;

	return f;
}




