
// Dfintion constantes diverses. 
#define NB_DIR 4			// nombre de direction (haut,bas,droite,gauche). 
#define NB_ORDRE 5			// Nombre d'ordre possible. 
#define NB_CELLULE 150		// Nombre de cellule gre. 

// Dfinition des maximums. 
#define MAX_CELL 800
#define MAX_POIDS 4040 //650
#define MAX_X 85
#define MAX_Y 85
#define MAX_TAB_COMPRESSION ((MAX_X*MAX_Y)/8 + 2)
#define MAX_PDV 37000.0     // Maximum en poind de vie.

// Definition des structure du fichier des donnes. 
enum
{
	eDeplacer =1,
	eAssocier,
	eManger,
	eDistribuer,
	eCreer
};

enum
{
	eHaut =1,
	eDroite,
	eBas,
	eGauche
};

typedef struct
{
	unsigned int x_coord;
	unsigned int y_coord;
} sCoord;


// Cellule en mmoire.
typedef struct
{
	BOOL Mort;
	unsigned int PointDeVie;
	unsigned char Defense;
	int Nourriture;
	sCoord Coord;
	float Poids[MAX_POIDS+1];
} sCellule;

// Tableau de toutes les cellules en memoire.
typedef struct
{
	sCellule Cellule[MAX_CELL+1];
} sTab_Cellule;

// Cellule stocke sur disque
typedef struct
{
	BOOL Mort;
	unsigned int PointDeVie;
	unsigned char Defense;
	int Nourriture;
	sCoord Coord;
	dfloat Poids[MAX_POIDS+1];
} sCellule_disque;

// Tableau de toutes les cellules sur le disque.
typedef struct
{
	sCellule_disque Cellule[MAX_CELL+1];
} sTab_Cellule_disque;


typedef struct
{
	unsigned int Num_cellule;
	unsigned int Nb_Nourriture;
} sDon_Grille;

typedef struct
{
	sDon_Grille Don_Grille[MAX_X+1][MAX_Y+1];
} sGrille;

typedef struct
{
	BYTE Bcase [MAX_TAB_COMPRESSION];
} sTableCompression;

typedef struct
{
	sCoord Coord[5];
} sNourrideplacante;

VOID DisplayFileSize (HWND hWnd,HANDLE hFile);

void Allocation (HWND hWnd);
VOID Allocation_mem_cell (HWND hWnd);
VOID Allocation_mem_art (HWND hWnd);
VOID Allocation_mem_grille (HWND hWnd);

void Liberation_memoire (void);
void Libe_memoire_cellule(void);
void Libe_memoire_grille(void);

void Lancer_threads (HWND hWnd);
void detect_signal(int sig); // Detection d'un signal d'interruption.
DWORD WINAPI ThreadFilsProc (HWND hWnd);
DWORD WINAPI ThreadTCPProc (HWND hWnd);

VOID Cellule_alea (void);
VOID Cellule_alea_une (void);
VOID Cellule_alea_auto (void);

VOID Nourriture_alea_init (void);
VOID Nourriture_alea_alim (void);
VOID Nourriture_alea_max_alim (void);

VOID Sauvegarde (HANDLE hFile);
VOID Sauvegarde_sur_autre_fichier (void);
VOID Restitution (HANDLE hFile);
void Relance_automatique(HANDLE hFile,HWND hWnd);

VOID test_cellule (int i,HWND hWnd);

VOID Calcul_action();
void Deplacememt (unsigned int i, int code_direction);
void Manger (unsigned int i);
void Creer (unsigned int i);
void Creation_cellule(unsigned int x,unsigned int y, unsigned int n_cell);
void Associer (unsigned int i);
void Distribuer (unsigned int i);
void Distribuer_Nourriture (unsigned int i,unsigned int j);
void Calcul_mort (unsigned int i);

void Init_grille (void);
void Init_Nourriture (void);
BOOL Controle_grille (void);
void Controle_Nourriture(void);
BOOL Controle_Memoire (void);

// Prototypes fonction pour gestion des agents neuronaux.
bool calcul_agent(int num_cell);
int calcul_decision_agent (float * resultat);
int calcul_direction (float * resultat);
bool calcul_com (int num_cell_com, float * tab_neur);
bool calcul_entree(int num_cell, float * tab_neur);
bool calcul_point_de_vie(int num_cell, float * tab_neur);
bool calcul_proxi(int num_cell,int bool_proxi,float * tab_neur,int * num_cell_proxi);
bool calcul_nourr(int num_cell,float * tab_neur);
bool calcul_situ(int num_cell,float * tab_neur);
bool calcul_stock_nourr(int num_cell, float * tab_neur);
void duplication_agent(float * ptPoids,int num_cell);
void creation_tous_les_agents();
void creation_agent(int num_cell);
void init_agent(float * ptPoids,int num_cell);
void init_agent_alea(float * ptPoids,int num_cell);
void detruire_agent (int num_cell);
void sauvegarde_agent();
void change_poids(int num_cell);
void detruire_tous_les_agents ();
void definir_parametres ();
bool definir_parametres_agents ();
void memo_heure_lancement();
void calcul_frequence();

void copie_cellules_sur_memoire_disque(sTab_Cellule_disque * Tab_Cellule_disque,bool b);
void copie_cellules_disque_sur_memoire(sTab_Cellule_disque * Tab_Cellule_disque);