//********************************************************************
//* Programme			: calcul
//*	Auteur				: Emmanuel Chauvin.
//* Date de cration	: 19/06/2001 
//* 
//* Description			: Vie Artificielle.
//*
//********************************************************************
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <LIMITS.H>
#include <time.h>
#include <signal.h>

#include "resource.h"
#include "Agent.h"
#include "Vie_Agent.h"
#include "outils.h"
#include "calcul.h"
#include <FLOAT.H>


//*********************************
// Donnes globales.
//*********************************
HANDLE hThreadCalcul;					// Handle du thread de calcul.
//HANDLE hFileDebug;					// Handle du fichier de debuggage.
HANDLE hFileDonnee;						// Handle du fichier de stockage.
sTab_Cellule * Tab_Cellule;				// Pointeur sur tableau de cellules.
Agent *agent[MAX_CELL+1];				// Table des agents neuronaux.
sGrille * Grille;						// Table inverse de la table des cellule. 
sTableCompression TableCompression;		// Compression de la grille afin de l'envoyer  l'applet Java.
HGLOBAL hMemCell;						// handle mmoire pour allocation.

BOOL Flag_Very_Sleep =FALSE;			// Vitesse d'execution tres lente
BOOL Flag_Sleep =FALSE;					// Vitesse d'execution lente
BOOL Flag_Moy_Sleep =FALSE;				// Vitesse d'execution moyenne
BOOL Flag_Pause =FALSE;					// Flag pour touche Pause
BOOL FlagExitThread = FALSE;			// Pour sortir du Thread.

int nb_viv=0;

int nb_genplus=0;						// Pour test. 
int nb_genmoins=0;

sNourrideplacante nourdep;				// Coordonnees des nourritures dplaantes.

char tcSauv[255];						// Libelle derniere sauvegarde.

bool bVisu_associer = false;			// Visualisation des cellules associees.
bool bVisu_distribuer = false;			// Visualisation des cellules distribues.

int dernier_tick = 0;		

//****************************************
// Parametres generaux de l'application.
//****************************************
int DIM_CELLULE = 7;			   // Dimension d'une cellule  l'affichage.
int X_LIBELLE;
int DIM_RECTANGLE_X;
int DIM_RECTANGLE_Y;

int NOURRI_AUTO              =700; // quantit de nourriture distribue alatoirement  chaque pas de prog.
int NOURRI_CENTRE            =150;  // quantit de nourriture distribue alatoirement  chaque pas de prog et
								   // positionn au centre du cadre.
int NOURRI_DEPLACANTE		 =30;  // quantit de nourriture distribue alatoirement  chaque pas de prog et
								   // se deplaant.
									
int NB_CELLULE_MINIMUM       =30;

// Dfinition des maximums. 
unsigned int MAX_NOURRI_ALEA_INIT     =40000; // Quantit parsem au dmarrage de la simulation.
unsigned int MAX_NOURRI_ALEA_ALIM     =260;
unsigned int MAX_NOURRI_ALEA_MAX_ALIM =1000;
unsigned int MAX_NOURRI               =15000;

double RATIO_MANGER			= 0.80; // Quand une cellule mange une autre cellule, 
									// ce ratio est le pourcentage 
									// que la cellule mangeuse rcupre de la cellule mange.

int MUTATION_POIDS			=5; 
int MUTATION                =20;
int COUT_POUR_DEPLACER		=2;
int COUT_POUR_MANGER		=3;
int COUT_POUR_CREER			=6;
int COUT_POUR_ASSOCIER		=1;
int COUT_POUR_DISTRIBUER	=1;
int COUT_POUR_DEFAULT		=1;
int BONUS_POUR_PREDATION	=0;
int MALUS_POUR_PREDATION	=0;

int DISTRIB_DEFENSE			=2;
int ASSOCIE_DEFENSE			=1;

int BONUS_ASSOCIER			=0;   // Un Bonus en nourriture est ajout pour chaque action associer.
int BONUS_ASSOCIER_SPECIAL	=0;	  // Un Bonus special associer pour une region prcise.
int INC_BONUS_ASSOCIER		=0;	  // Increments pour les bonus respectifs.
int INC_BONUS_ASSOCIER_SPECIAL=250;

//
// Definition des constantes relatives au agents neuronaux.
// --------------------------------------------------------

int NB_COUCHES				=4;     // Nombre de couche pour un agent.

int NB_NEUR_COUCH			=40;    // Nombre de neurone pour une couche intermediaire.
									// Correspondant 7 neuronnes en sortie (reponse du reseau)
int NB_NEUR_SORTIE_DIR      =2;		// Nombre de neurones sortie pour indiquer la direction.
int NB_NEUR_SORTIE_COM		=5;     // Communicant avec une cellule voisine.
int NB_NEUR_SORTIE_ACTION	=5;     // Correspondant au nombre de neuronnes action (en reponse).
int NB_NEUR_SORTIE			=NB_NEUR_SORTIE_ACTION+
							 NB_NEUR_SORTIE_DIR+
							 NB_NEUR_SORTIE_COM;	// Nombre de neurones de sortie (5 code action + 2 direction + 5 de communication).


// Definition des entrees des agents neuronaux.
int NB_NEUR_PDV				=10;    // Neurones point de vie.
int NB_NEUR_STOCK_NOURR		=10;	// Neuronnes Stock de nourriture. 
int NB_NEUR_PROXI			=8;     // Proximite cellule et obstacle.
int NB_NEUR_NOURR			=2;     // Neurones quantifiant la nourriture sur la case.
int NB_NEUR_COM				=5;		// Neuronnes de communication. Correspond aux sortie des neur communicante
									// d'une cellule voisine.
int NB_NEUR_SITU			=6;		// Neuronnes de situtation dans le monde 6x6. (3 bits + 3bits). 

int NB_NEUR_ENTREE			=						// Correspondant au total de neuronnes en entree 
							 NB_NEUR_PDV+			// pour les pas de prog,
							 NB_NEUR_STOCK_NOURR+	// pour le stock de nourriture,
							 NB_NEUR_PROXI+			// pour la proximite d'une cellule,
							 NB_NEUR_PROXI+			// pour la proximite d'un obstacle et
							 NB_NEUR_NOURR+			// pour le nombre de nourriture.
							 NB_NEUR_COM+			// pour le nombre de neuronne de communication.
							 NB_NEUR_SITU;			// 6 neurs pour designer la rgion ou se trouve la cellule.

int NB_NEUR_ENTREE_PROXI	=
							 NB_NEUR_PDV+
							 NB_NEUR_STOCK_NOURR+
							 NB_NEUR_PROXI;

int NB_NEUR_ENTREE_NOURR	=
							 NB_NEUR_PDV+
							 NB_NEUR_STOCK_NOURR+
							 NB_NEUR_PROXI+
							 NB_NEUR_PROXI;


int NB_NEUR_ENTREE_COM	=
							 NB_NEUR_PDV+
							 NB_NEUR_STOCK_NOURR+
							 NB_NEUR_PROXI+
							 NB_NEUR_PROXI+
							 NB_NEUR_NOURR;

int NB_NEUR_ENTREE_SITU	=
							 NB_NEUR_PDV+
							 NB_NEUR_STOCK_NOURR+
							 NB_NEUR_PROXI+
							 NB_NEUR_PROXI+
							 NB_NEUR_NOURR+
							 NB_NEUR_COM;

 
int NB_NEURONNES			= 10;   // Nombre de neurones total.

int IND_NEUR_STOCK_NOURR    = 0;    // Nombre de neurone point de vie + stock nourr.

int IND_NEUR_SORTIE			= 0;	// Indice du neurone  partir duquel il y a la reponse.
									// Attention cette variable devra tre calcule
									// en dbut de programme.
int IND_NEUR_SORTIE_DIR		= 0;    // Indice neurone sortie pour le reponse direction.

int IND_NEUR_SORTIE_COM		= 0;    // Indice neurone sortie pour le reponse communication.

									
int NB_POIDS				= MAX_POIDS;// Correspondant 28 X 10 X 10 X 7 neuronnes.
									// Attention cette variable devra tre calcule
									// en dbut de programme.

int BOOL_CELL				=1;		// Utilis pour le calcul de proximit.
int BOOL_OBST				=2;		// Utilis pour le calcul de proximit.

float CONSTX_SITU = (float)6/(float)MAX_X;
float CONSTY_SITU = (float)6/(float)MAX_Y;

//*********************************
// Donnes Windows en externe.
//*********************************
// Handle de la fenetre.
extern HWND ghWnd;
extern HINSTANCE hInst;
extern HWND hDlgStat;
extern HWND hwndPB;					// handle of progress bar 
					
extern BYTE Byte_masq[9];

extern int X_MOVE;
extern int Y_MOVE;


//*********************************
// Fonctions Windows en externe.
//*********************************
extern VOID Dessin_obstacle (void);



//****************************************************************************
// FONCTIONS
//****************************************************************************

//*********************************
// Allocations mmoire. 
//*********************************
void Allocation (HWND hWnd)
{
		Allocation_mem_cell (hWnd);
		Allocation_mem_grille (hWnd);
}

//**************************************************
// Allocations mmoire de la table des cellules. 
//**************************************************
VOID Allocation_mem_cell (HWND hWnd)
{
	int a = sizeof (sTab_Cellule);
	char szMsg[300];

	// Allocation de la mmoire ncessaire aux cellules. 
	hMemCell = GlobalAlloc (GPTR,sizeof (sTab_Cellule));
	if (hMemCell && (Tab_Cellule = (sTab_Cellule *)GlobalLock(hMemCell))!=NULL)
	{
		// Rien  faire. 
		//wsprintf (szMsg,"Allocation Cell faite = %d",sizeof (sTab_Cellule));
		//MessageBox (hWnd,szMsg,"Mmoire",MB_OK);
	}
	else
	{
		wsprintf (szMsg,"Problme Allocation Cell");
		MessageBox (hWnd,szMsg,"Mmoire",MB_OK | MB_ICONINFORMATION);
	}
}

//************************************************************************
// Allocations mmoire de la table des cellules pour stockage sur disque. 
//************************************************************************
sTab_Cellule_disque * Allocation_mem_cell_pour_disque (HWND hWnd)
{
	HGLOBAL hMemCell_disque;
	sTab_Cellule_disque * Tab_Cellule_disque;
	int a = sizeof (sTab_Cellule_disque);
	char szMsg[300];

	// Allocation de la mmoire ncessaire aux cellules. 
	hMemCell_disque = GlobalAlloc (GPTR,sizeof (sTab_Cellule_disque));
	if (hMemCell_disque && (Tab_Cellule_disque = (sTab_Cellule_disque *)GlobalLock(hMemCell_disque))!=NULL)
	{
	}
	else
	{
		wsprintf (szMsg,"Problme Allocation Cell pour disque");
		MessageBox (hWnd,szMsg,"Mmoire",MB_OK | MB_ICONINFORMATION);
	}

	return (Tab_Cellule_disque);
}


//**************************************************
// Allocations mmoire de la table 'Grille'. 
//**************************************************
VOID Allocation_mem_grille (HWND hWnd)
{
	HGLOBAL hMem;			// Handle du block mmoire contenant toutes les cellules. 
	char szMsg[300];
	
	// Allocation de la mmoire ncessaire aux cellules. 
	hMem = GlobalAlloc (GPTR,sizeof (sGrille));
	if (hMem && (Grille = (sGrille *)GlobalLock(hMem))!=NULL)
	{
		//Rien  faire. La grille est initialise  zro.
		//wsprintf (szMsg,"Allocation Grille faite = %d",sizeof (sGrille));
		//MessageBox (hWnd,szMsg,"Mmoire",MB_OK);
	}
	else
	{
		wsprintf (szMsg,"Problme Allocation Grille");
		MessageBox (hWnd,szMsg,"Mmoire",MB_OK | MB_ICONINFORMATION);
	}
}

//************************************
// Libration de la mmoire.
//************************************
void Liberation_memoire (void)
{
	detruire_tous_les_agents();
	Libe_memoire_cellule();
	Libe_memoire_grille();
}

//****************************************
// Libration de la mmoire des cellules.
//****************************************
void Libe_memoire_cellule(void)
{
	DWORD dwError;
	HGLOBAL hMem,hFree;
	char szMsg[300];
			
	if (Tab_Cellule)
	{
			  hMem = GlobalHandle (Tab_Cellule);
			  hFree = GlobalFree (hMem);
			  if (hFree != 0)
			  {
				  // Erreur sur GlobalFree.
				  dwError = GetLastError();
				  wsprintf (szMsg,"Erreur sur GlobalFree Tab_Cellule : %d \n",dwError);
				  MessageBox (ghWnd,szMsg,"Incident Libration mmoire",MB_OK | MB_ICONINFORMATION);
			  }
	}
}


//****************************************
// Libration de la mmoire des cellules.
//****************************************
void Libe_memoire_cellule_disque(sTab_Cellule_disque  * Tab_Cellule_disque)
{
	DWORD dwError;
	HGLOBAL hMem,hFree;
	char szMsg[300];
			
	if (Tab_Cellule_disque)
	{
			  hMem = GlobalHandle (Tab_Cellule_disque);
			  hFree = GlobalFree (hMem);
			  if (hFree != 0)
			  {
				  // Erreur sur GlobalFree.
				  dwError = GetLastError();
				  wsprintf (szMsg,"Erreur sur GlobalFree Tab_Cellule_disque : %d \n",dwError);
				  MessageBox (ghWnd,szMsg,"Incident Libration mmoire",MB_OK | MB_ICONINFORMATION);
			  }
	}
}

//************************************
// Libration de la mmoire 'Grille'.
//************************************
void Libe_memoire_grille(void)
{
	DWORD dwError;
	HGLOBAL hMem,hFree;
	char szMsg[300];

	if (Grille)
	{
			 hMem = GlobalHandle (Grille);
			 hFree = GlobalFree (hMem);
			 if (hFree != 0)
			 {
				  // Erreur sur GlobalFree.
				  dwError = GetLastError();
				  wsprintf (szMsg,"Erreur sur GlobalFree Grille : %d \n",dwError);
				  MessageBox (ghWnd,szMsg,"Incident Libration mmoire",MB_OK | MB_ICONINFORMATION);
			 }
	}
}


//***********************************************
//* Lancement des threads avec
//* initialisation de toutes les variables.
//* Windows ne se chargeant que de l'affichage.
//***********************************************
void Lancer_threads (HWND hWnd)
{
			DWORD dwid;
			char szMsg[300];

			// Dtection de signaux.
			signal(SIGTERM,detect_signal);
			signal(SIGINT,detect_signal);
			signal(SIGABRT,detect_signal);
			signal(SIGFPE,detect_signal);
			signal(SIGSEGV,detect_signal);
			signal(SIGILL,detect_signal);

			// Allocation memoire des cellules, table inverse, article. 
			Allocation(hWnd);

			// Allocation de tous les agents neuronaux. 
			creation_tous_les_agents();

			// Pour debug. 
			/*hFileDebug = CreateFile ("debug.txt",GENERIC_READ | GENERIC_WRITE,
							   FILE_SHARE_READ,NULL,OPEN_ALWAYS,
							   FILE_ATTRIBUTE_NORMAL,NULL);*/

			// Lecture du fichier de stockage. 
			hFileDonnee = CreateFile ("Monde_01.don",GENERIC_READ | GENERIC_WRITE,
							   FILE_SHARE_READ,NULL,OPEN_ALWAYS,
							   FILE_ATTRIBUTE_NORMAL,NULL);
			if (hFileDonnee != INVALID_HANDLE_VALUE)
			{
     			// Le fichier est-il  crer. 
				DisplayFileSize (hWnd,hFileDonnee);
			}
			else
			{
				wsprintf (szMsg,"Impossible de lire le fichier Monde_01.don.");
				MessageBox (hWnd,szMsg,"Incident cration/lecture",MB_OK);
			}
	   
			// Initialisation Table de compression. (donnes qui seront
			//   envoyes aux applets JAVA. 
			memset (&TableCompression,0x00,sizeof(sTableCompression));

			// Memo de l'heure de lancement.
			memo_heure_lancement();

			//*******************************
			// Creation du thread de calcul. 
			//*******************************
			hThreadCalcul = CreateThread (NULL,1024,(LPTHREAD_START_ROUTINE)ThreadFilsProc,(LPVOID)hWnd,0,&dwid);

			//*****************************************
			// Creation du thread pour le serveur TCP. 
			//*****************************************
#ifdef SERVEUR		   	
			// Creation du thread pour Serveur TCP. 
			CreateThread (NULL,1024,(LPTHREAD_START_ROUTINE)ThreadTCPProc,(LPVOID)hWnd,0,&dwid);

			if (!envoi_du_fichier_adresIP (hWnd))
				MessageBox(hWnd,"L'envoi de l'adresse IP ne s'est pas correctement droul.\n Veuillez interrompre le programme !",
				"  Adresse IP du serveur !",MB_ICONSTOP);
#endif
}

//************************************************************
// On mmorise l'heure de lancement pour derniere sauvegarde.
//************************************************************
void memo_heure_lancement()
{
			// On valorise le message de derniere sauvegarde.
			char tbuffer[20];
			memset(tcSauv,0,255);
			memset(tbuffer,0,20);
			_strtime( tbuffer );
			wsprintf(tcSauv,"Sauvegarde effectue  %s ",tbuffer);
}

//*****************************************************
// Dtection d'un signal d'abort ou de d'arrt.
//*****************************************************
void detect_signal(int sig)
{
	if (hFileDonnee && Tab_Cellule)
		Sauvegarde (hFileDonnee);
	exit(0);
}

//*****************************************************
// Dtection de fichier et cration de celui-ci.
//*****************************************************
VOID DisplayFileSize (HWND hWnd,HANDLE hFile)
{
	DWORD dwSize;
	char szMsg [128];

	dwSize = GetFileSize (hFile,NULL);
	if (dwSize == 0)
	{
		wsprintf (szMsg,"Cration du fichier Monde_01");
		MessageBox (hWnd,szMsg,"Cration fichier",MB_OK);
		// Dispertion alatoire de nourritures. 
		Nourriture_alea_init ();
		// Cration alatoire de 100 cellules 
		// Dessin des obstacles. 
		Dessin_obstacle();
		Cellule_alea ();
		Sauvegarde (hFile);
	}
	else
	{
		// Dessin des obstacles. 
		Dessin_obstacle();
		Restitution(hFile);
    	// Initialisation de la table inverse (Grille). 
		Init_grille();
	}
}

//***********************************************
// Process de calcul du monde.
//***********************************************
DWORD WINAPI ThreadFilsProc (HWND hWnd)
{
	// Pour calculer la frequence.
	dernier_tick = GetTickCount();

	while (! FlagExitThread)
	{
		if (!Flag_Pause)
		{
			Calcul_action ();
			// Dispertion alatoire de nourritures. 
			Nourriture_alea_alim ();
			// Procdure d'arrt de l'appli en cas de prob mmoire. 
			/*if (!Controle_Memoire ())
			{
				DestroyWindow(hWnd);
			}*/

			calcul_frequence();
		}
		
		if (Flag_Moy_Sleep)
		  Sleep (5);

		if (Flag_Sleep)
		  Sleep (60);

		if (Flag_Very_Sleep)
		  Sleep (150);
	}

	CloseHandle(hFileDonnee);
	Liberation_memoire();

	ExitThread(0);

	return (TRUE);
}

//*****************************************************
// Process serveur pour visualisation par client TCP.
//*****************************************************
DWORD WINAPI ThreadTCPProc (HWND hWnd)
{
#ifdef SERVEUR
	serveur(hWnd);
#endif

	ExitThread(0);

	return (TRUE);
}

//*****************************************************
// Sauvegarde sur fichier du monde.
//*****************************************************
VOID Sauvegarde (HANDLE hFile)
{
	DWORD dwWritten;
	BOOL bResult;
	sTab_Cellule_disque * Tab_Cellule_disque;

	Flag_Pause = TRUE;

	sauvegarde_agent();

	SetFilePointer (hFile,NULL,NULL,FILE_BEGIN);

	Tab_Cellule_disque = Allocation_mem_cell_pour_disque(ghWnd);
	copie_cellules_sur_memoire_disque(Tab_Cellule_disque,true);

	bResult = WriteFile (hFile,Tab_Cellule_disque,sizeof (sTab_Cellule_disque),&dwWritten,NULL);
	if (!bResult)
	{
		OutputDebugString("Sauvegarde : Ecriture des cellules ne s'est pas faite ! \n");
	}

	Libe_memoire_cellule_disque(Tab_Cellule_disque);

	bResult = WriteFile (hFile,Grille,sizeof (sGrille),&dwWritten,NULL);
	if (!bResult)
	{
		OutputDebugString("Sauvegarde : Ecriture de la grille ne s'est pas faite ! \n");
	}

	Flag_Pause = FALSE;
}

//*******************************************************************************
// On recopie la memoire des cellules sur une autre memoire qui est compresse.
//*******************************************************************************
void copie_cellules_sur_memoire_disque(sTab_Cellule_disque * Tab_Cellule_disque,bool first)
{
	int i,j;
       
	HWND hDlg = CreateDialog( hInst,MAKEINTRESOURCE(IDD_SAUVEGARDE),ghWnd,(DLGPROC)Sauvproc );
	if (first)
		SetDlgItemText(hDlg,IDC_NOMMONDE,"Monde01.don");
	else
		SetDlgItemText(hDlg,IDC_NOMMONDE,"Monde02.don");

	for (i=0;i<MAX_CELL+1;i++)
	{
		//memcpy (&Tab_Cellule_disque->Cellule[i],&Tab_Cellule->Cellule[i],21);
		Tab_Cellule_disque->Cellule[i].Mort = Tab_Cellule->Cellule[i].Mort;
		Tab_Cellule_disque->Cellule[i].PointDeVie = Tab_Cellule->Cellule[i].PointDeVie;
		Tab_Cellule_disque->Cellule[i].Defense = Tab_Cellule->Cellule[i].Defense;
		Tab_Cellule_disque->Cellule[i].Nourriture = Tab_Cellule->Cellule[i].Nourriture;
		Tab_Cellule_disque->Cellule[i].Coord = Tab_Cellule->Cellule[i].Coord;

		for (j=0;j<MAX_POIDS+1;j++)
		{
			// On convertit du float en dfloat (demi_float) qui prend 2 octets au lieu de 4.
			Tab_Cellule_disque->Cellule[i].Poids[j]= conv_float_dfloat(Tab_Cellule->Cellule[i].Poids[j]);
		}

		SendMessage(hwndPB, PBM_STEPIT, 0, 0); 
	}

	DestroyWindow(hDlg);
}


//*******************************************************************************
// On copie la memoire des cellules disque compresse sur la memoire cellule.
//*******************************************************************************
void copie_cellules_disque_sur_memoire(sTab_Cellule_disque * Tab_Cellule_disque)
{
	int i,j;

	for (i=0;i<MAX_CELL+1;i++)
	{
		Tab_Cellule->Cellule[i].Mort = Tab_Cellule_disque->Cellule[i].Mort;
		Tab_Cellule->Cellule[i].PointDeVie = Tab_Cellule_disque->Cellule[i].PointDeVie;
		Tab_Cellule->Cellule[i].Defense = Tab_Cellule_disque->Cellule[i].Defense;
		Tab_Cellule->Cellule[i].Nourriture = Tab_Cellule_disque->Cellule[i].Nourriture;
		Tab_Cellule->Cellule[i].Coord = Tab_Cellule_disque->Cellule[i].Coord;
		for (j=0;j<MAX_POIDS+1;j++)
		{
			// On convertit du dfloat en float. Le demi_float prend 2 octets au lieu de 4.
			Tab_Cellule->Cellule[i].Poids[j]= conv_dfloat_float(Tab_Cellule_disque->Cellule[i].Poids[j]);
		}
	}
}


//*****************************************************
// Sauvegarde sur fichier supplementaire du monde.
//*****************************************************
VOID Sauvegarde_sur_autre_fichier (void)
{
	DWORD dwWritten;
	sTab_Cellule_disque * Tab_Cellule_disque;
	HANDLE hFile = CreateFile ("Monde_02.don",GENERIC_READ | GENERIC_WRITE,
			   FILE_SHARE_READ,NULL,OPEN_ALWAYS,
			   FILE_ATTRIBUTE_NORMAL,NULL);

	Flag_Pause = TRUE;

	sauvegarde_agent();
	SetFilePointer (hFile,NULL,NULL,FILE_BEGIN);

	Tab_Cellule_disque = Allocation_mem_cell_pour_disque(ghWnd);
	copie_cellules_sur_memoire_disque(Tab_Cellule_disque,false);

	WriteFile (hFile,Tab_Cellule_disque,sizeof (sTab_Cellule_disque),&dwWritten,NULL);

	Libe_memoire_cellule_disque(Tab_Cellule_disque);

	WriteFile (hFile,Grille,sizeof (sGrille),&dwWritten,NULL);
	CloseHandle(hFile);

	Flag_Pause = FALSE;
}

//*****************************************************
// On test l'volution d'une cellule.
//*****************************************************
VOID test_cellule (int i,HWND hWnd)
{
	sCellule cel;

	cel = Tab_Cellule->Cellule[i];
	Libe_memoire_cellule();
	Allocation_mem_cell (hWnd);
	Nourriture_alea_init ();
	Dessin_obstacle();
	Tab_Cellule->Cellule[1] = cel;
	Grille->Don_Grille[cel.Coord.x_coord][cel.Coord.y_coord].Num_cellule = 1;
	init_agent(Tab_Cellule->Cellule[i].Poids,i);
	
}

//*****************************************************
// Restitution du fichier en mmoire.
//*****************************************************
VOID Restitution (HANDLE hFile)
{
	DWORD dwRead;
	BOOL bResult;
	sTab_Cellule_disque * Tab_Cellule_disque;

	SetFilePointer (hFile,NULL,NULL,FILE_BEGIN);

	Tab_Cellule_disque = Allocation_mem_cell_pour_disque(ghWnd);

	bResult = ReadFile (hFile,Tab_Cellule_disque,sizeof (sTab_Cellule_disque),&dwRead,NULL);
	if (!bResult)
	{
		OutputDebugString("Restitution : Lecture des cellules ne s'est pas faite ! \n");
	}

	copie_cellules_disque_sur_memoire(Tab_Cellule_disque);
	Libe_memoire_cellule_disque(Tab_Cellule_disque);

	bResult = ReadFile (hFile,Grille,sizeof (sGrille),&dwRead,NULL);
	if (!bResult)
	{
		OutputDebugString("Restitution : Lecture de la grille ne s'est pas faite ! \n");
	}
}

//*****************************************
// Module de calcul principal.
//*****************************************
VOID Calcul_action ()
{
	int i;
	int code_action;
	int code_direction;
	//char tcMess [35];
	//DWORD dwWritten;

	// Donnes pour stats.
	long int nb_dep = 0;
	long int nb_man = 0;
	long int nb_ass = 0;
	long int nb_dis = 0;
	long int nb_cre = 0;

	// Bonus en nourriture pour chaque action associer.
	BONUS_ASSOCIER = 0;
	BONUS_ASSOCIER_SPECIAL = 0;

	for (i=1;i<MAX_CELL+1;i++)
	{
		//memset(tcMess,0,35);
		//wsprintf(tcMess,"calcul action : indice = %d.\n",i);
		//WriteFile (hFileDebug,tcMess,sizeof(tcMess),&dwWritten,NULL);

		/*if (!Controle_grille())
		{
			wsprintf(tcMess,"Problme sur Grille Num Cell = %d   \n",i);
			OutputDebugString(tcMess);
		}*/

		// Si la cellule n'a plus de point de vie, elle meurt.
		Calcul_mort (i);

		if ( !Tab_Cellule->Cellule[i].Mort)
		{
			// Diminution de la defense.
			int ipdv = Tab_Cellule->Cellule[i].PointDeVie;
			if (Tab_Cellule->Cellule[i].Defense > 0)
			{
				// Elle diminue plus vite quand la cellule est age.
				int dim_def = (int) (ipdv*((float)(ipdv/MAX_PDV))) + 1;
				if (dim_def <= Tab_Cellule->Cellule[i].Defense)
					Tab_Cellule->Cellule[i].Defense -= dim_def;
				else
					Tab_Cellule->Cellule[i].Defense = 0;
			}

			// Augmentation de l'age.
			if (ipdv <MAX_PDV)
				Tab_Cellule->Cellule[i].PointDeVie++;

			// Calcul les entrees pour l'agent + propagation.
			calcul_agent(i);

			// Calcul du code action.
			code_action = calcul_decision_agent(&agent[i]->tab_neuronnes[IND_NEUR_SORTIE]);

			switch (code_action)
			{
			case eDeplacer :
				if (Tab_Cellule->Cellule[i].Nourriture >= COUT_POUR_DEPLACER)
				{
					code_direction = calcul_direction(&agent[i]->tab_neuronnes[IND_NEUR_SORTIE_DIR]);
					Deplacememt (i,code_direction);
				}
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,COUT_POUR_DEPLACER);
				nb_dep++;
				break;
			case eManger:
				if (Tab_Cellule->Cellule[i].Nourriture >= COUT_POUR_MANGER)
				{
					Manger(i);
				}
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,COUT_POUR_MANGER);
				nb_man++;
				break;
			case eCreer :
				if (Tab_Cellule->Cellule[i].Nourriture >= COUT_POUR_CREER)
					Creer(i);
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,COUT_POUR_CREER);
				nb_cre++;
				break;
			case eAssocier:
				{
					if (Tab_Cellule->Cellule[i].Nourriture >= COUT_POUR_ASSOCIER)
						Associer(i);
					Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,COUT_POUR_ASSOCIER);
					
					nb_ass++;

					// Dessiner cellule marque associe.
					if (bVisu_associer)
					{
						HDC hdc = GetDC( ghWnd );
						Dessiner_cellule_marque_ass (hdc,
							x_plus(Tab_Cellule->Cellule[i].Coord.x_coord,X_MOVE),
							y_plus(Tab_Cellule->Cellule[i].Coord.y_coord,Y_MOVE));
						ReleaseDC( ghWnd, hdc );
					}
				}
				break;
			case eDistribuer:
				if (Tab_Cellule->Cellule[i].Nourriture >= COUT_POUR_DISTRIBUER)
					Distribuer (i);
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,COUT_POUR_DISTRIBUER);
				nb_dis++;

				// Dessiner cellule marque associe.
				if (bVisu_distribuer)
				{
					HDC hdc = GetDC( ghWnd );
					Dessiner_cellule_marque_dis (hdc,
						x_plus(Tab_Cellule->Cellule[i].Coord.x_coord,X_MOVE),
						y_plus(Tab_Cellule->Cellule[i].Coord.y_coord,Y_MOVE));
					ReleaseDC( ghWnd, hdc );
				}
				break;
			default :
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,COUT_POUR_DEFAULT);
				break;
			}
			Mutation(i);
		}
	}

	if (hDlgStat)
	{
		SetDlgItemInt(hDlgStat,IDC_ACTDEPL,nb_dep,FALSE);
		SetDlgItemInt(hDlgStat,IDC_ACTASSO,nb_ass,FALSE);
		SetDlgItemInt(hDlgStat,IDC_ACTMANG,nb_man,FALSE);
		SetDlgItemInt(hDlgStat,IDC_ACTDIST,nb_dis,FALSE);
		SetDlgItemInt(hDlgStat,IDC_ACTCREE,nb_cre,FALSE);
	}
}

//*****************************************************
// Calcul l'action que rpond un agent neuronal.
//*****************************************************
bool calcul_agent(int num_cell)
{
	agent[num_cell]->init_neuronnes();
	calcul_entree(num_cell,agent[num_cell]->tab_neuronnes);
	agent[num_cell]->propagation();
	return true;
}

//*****************************************************
// Initialise les neurones en entree.
//*****************************************************
bool calcul_entree(int num_cell, float * tab_neur)
{
	int num_cell_proxi = 0;
	// Initialisation des neurones en entree  zro.
	//memset (tab_neur,0,sizeof(float)*NB_NEUR_ENTREE);

	// Calcul des 10 neurones  en entree du reseau pour les points de vie.
	calcul_point_de_vie(num_cell,tab_neur);
	// Calcul des 10 neurones  en entree du reseau pour le stock de nourriture.
	calcul_stock_nourr(num_cell,tab_neur);
	// Calcul les 8 neurones de proximit cellule.
	calcul_proxi(num_cell,BOOL_CELL,&tab_neur[NB_NEUR_PDV-1],&num_cell_proxi);

	if (num_cell_proxi != 0)
	{
		// Une cellule se trouve  proximite. On peut communiquer.
		// On prend la partie communication de cette cellule et elle vient en entre de com
		// dans notre cellule en cours.
		calcul_com(num_cell_proxi,&tab_neur[NB_NEUR_ENTREE_COM-1]);
	}
	// Calcul les 8 neurones de proximit obstacle.
	calcul_proxi(num_cell,BOOL_OBST,&tab_neur[NB_NEUR_ENTREE_PROXI-1],&num_cell_proxi);
	// Calcul 2 neurones pour la nourriture sur la grille.
	calcul_nourr(num_cell,&tab_neur[NB_NEUR_ENTREE_NOURR-1]);
	// Calcul 6 neurones pour situer la cellule dans le monde.
	calcul_situ(num_cell,&tab_neur[NB_NEUR_ENTREE_SITU-1]);

	return true;
}

//**************************************************************************
// Determine l'entree de communication en la prenant sur une autre cellule.
//**************************************************************************
bool calcul_com (int num_cell_com, float * tab_neur)
{
	int i;
	for (i=0;i<5;i++)
	{
		if (agent[num_cell_com]->tab_neuronnes[IND_NEUR_SORTIE_COM+i] > 0)
			tab_neur[i] = 1;
		else
			tab_neur[i] = 0;
	}

	return true;
}

//*************************************************************
// Calcul des points de vie de la cellule.
//*************************************************************
bool calcul_point_de_vie(int num_cell, float * tab_neur)
{
	int i;
	int pdv;

	pdv = Tab_Cellule->Cellule[num_cell].PointDeVie;

	// Calcul des 10 neurones en entree concernant les points de vie (ou pas de programme).
	for (i=0;i<NB_NEUR_PDV && pdv > 0;i++)
	{
			tab_neur[i] = (float)((int)pdv%2);
			pdv >>= 1; 
	}
	return true;
}

//*************************************************************
// Calcul du stock de nourriture de la cellule.
//*************************************************************
bool calcul_stock_nourr(int num_cell, float * tab_neur)
{
	int i;
	int stock_nourr;

	stock_nourr = Tab_Cellule->Cellule[num_cell].Nourriture;

	// Calcul des 10 neurones en entree concernant le stock de nourriture.
	for (i=NB_NEUR_PDV;i<IND_NEUR_STOCK_NOURR && stock_nourr > 0;i++)
	{
			tab_neur[i] = (float)((int)stock_nourr%2);
			stock_nourr >>= 1; 
	}
	return true;
}

//*************************************************************
// Calcul les cellules  proximit.
//*************************************************************
bool calcul_proxi(int num_cell,int bool_proxi,float * tab_neur, int *num_cell_proxi)
{
	unsigned int x,y,coord_calcule_x,coord_calcule_y;
	int num_cellule;

	x = Tab_Cellule->Cellule[num_cell].Coord.x_coord;
	y = Tab_Cellule->Cellule[num_cell].Coord.y_coord;

	// On regarde si il y prsence en haut.
	coord_calcule_y = y_moins1 (y);
	num_cellule = Grille->Don_Grille[x][coord_calcule_y].Num_cellule;

	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[1] = 1;
		*num_cell_proxi = num_cellule; 
	}

	// On regarde si il y prsence en haut  droite.
	coord_calcule_x = x_plus1 (x);
	coord_calcule_y = y_moins1 (y);
	num_cellule = Grille->Don_Grille[coord_calcule_x][coord_calcule_y].Num_cellule;

	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[2] = 1;
		*num_cell_proxi = num_cellule;
	}

	// On regarde si il y prsence  droite.
	coord_calcule_x = x_plus1 (x);
	num_cellule = Grille->Don_Grille[coord_calcule_x][y].Num_cellule;

	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[3] = 1;
		*num_cell_proxi = num_cellule;
	}

	// On regarde si il y prsence en bas  droite.
	coord_calcule_x = x_plus1 (x);
	coord_calcule_y = y_plus1 (y);
	num_cellule = Grille->Don_Grille[coord_calcule_x][coord_calcule_y].Num_cellule;

	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[4] = 1;
		*num_cell_proxi = num_cellule;
	}

	// On regarde si il y prsence en bas.
	coord_calcule_y = y_plus1 (y);
	num_cellule = Grille->Don_Grille[x][coord_calcule_y].Num_cellule;

	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[5] = 1;
		*num_cell_proxi = num_cellule;
	}

	// On regarde si il y prsence en bas  gauche.
	coord_calcule_x = x_moins1 (x);
	coord_calcule_y = y_plus1 (y);
	num_cellule = Grille->Don_Grille[coord_calcule_x][coord_calcule_y].Num_cellule;

	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[6] = 1;
		*num_cell_proxi = num_cellule;
	}

	// On regarde si il y prsence  gauche.
	coord_calcule_x = x_moins1 (x);
	num_cellule = Grille->Don_Grille[coord_calcule_x][y].Num_cellule;
	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[7] = 1;
		*num_cell_proxi = num_cellule;
	}

	// On regarde si il y prsence en haut  gauche.
	coord_calcule_x = x_moins1 (x);
	coord_calcule_y = y_moins1 (y);
	num_cellule = Grille->Don_Grille[coord_calcule_x][coord_calcule_y].Num_cellule;
	if ( (num_cellule == OBSTACLE && bool_proxi == BOOL_OBST) ||
		 (num_cellule != OBSTACLE && num_cellule != 0 && bool_proxi == BOOL_CELL))
	{
		tab_neur[8] = 1;
		*num_cell_proxi = num_cellule;
	}

	return true;
}

//*************************************************************
// Calcul de la nourriture.
//*************************************************************
bool calcul_nourr(int num_cell,float * tab_neur)
{
	int nb_nourr;
	unsigned int x,y;

	x = Tab_Cellule->Cellule[num_cell].Coord.x_coord;
	y = Tab_Cellule->Cellule[num_cell].Coord.y_coord;
	nb_nourr = Grille->Don_Grille[x][y].Nb_Nourriture;

	if (nb_nourr > 7)
	{
		tab_neur[1] = 1;
		tab_neur[2] = 1;
	}
	else
	if (nb_nourr > 3)
	{
		tab_neur[1] = 1;
		tab_neur[2] = 0;
	}
	else
	if (nb_nourr > 0)
	{
		tab_neur[1] = 0;
		tab_neur[2] = 1;
	}
	else
	{
		tab_neur[1] = 0;
		tab_neur[2] = 0;
	}

	return true;
}

//*************************************************************
// Calcul de la situation.
//*************************************************************
bool calcul_situ(int num_cell,float * tab_neur)
{
	unsigned int x,y,x6,y6;
	int i;

	x = Tab_Cellule->Cellule[num_cell].Coord.x_coord;
	y = Tab_Cellule->Cellule[num_cell].Coord.y_coord;

	x6 = (int) ((float)x*(float)CONSTX_SITU)+1;
	y6 = (int) ((float)y*(float)CONSTY_SITU)+1;

	for (i=0;i<3 && x6 > 0;i++)
	{
		tab_neur[i] = (float)((int)x6%2);
		x6 >>= 1; 
	}

	for (i=3;i<6 && y6 > 0;i++)
	{
		tab_neur[i] = (float)((int)y6%2);
		y6 >>= 1; 
	}

	return true;
}

//*************************************************************
// Renvoie l'indice de la neurone avec la plus forte reponse.
//*************************************************************
int calcul_decision_agent (float * resultat)
{
	int i;
	float max_reponse = -FLT_MAX;

	int ind_max = 0;

	for (i=0;i<NB_NEUR_SORTIE_ACTION;i++)
	{
		if (resultat[i] > max_reponse)
		{
			max_reponse = resultat[i];
			ind_max = i+1;
		}
	}

	if (ind_max == 0)
	{
		return (Alea(NB_ORDRE));
	}
	else
		return (ind_max);
}

//*************************************************************
// Renvoie la direction.
//*************************************************************
int calcul_direction (float * resultat)
{
	if (resultat[0] > 0 && resultat[1] > 0)
		return eHaut;
	else
	if (resultat[0] > 0 && resultat[1] <= 0)
		return eBas;
	else
	if (resultat[0] <= 0 && resultat[1] > 0)
		return eGauche;
	else
		return eDroite;
}

//*****************************************************
// On regarde si la cellule est morte.
//*****************************************************
void Calcul_mort (unsigned int i)
{
	//char mess[300];

	//wsprintf(mess,"calcul mort : indice = %d.\n",i);
	//OutputDebugString(mess);

	if (!Tab_Cellule->Cellule[i].Mort)
	{

		if (Tab_Cellule->Cellule[i].Nourriture == 0)
		{

			Tab_Cellule->Cellule[i].Mort = TRUE;

			Grille->Don_Grille[Tab_Cellule->Cellule[i].Coord.x_coord][Tab_Cellule->Cellule[i].Coord.y_coord].Num_cellule=0;
		}
	}
}

//*****************************************************
// Execute le dplacement d'une cellule.
//*****************************************************
void Deplacememt (unsigned int i,int Code_direction)
{
	unsigned int x,y,coord_calcule;
	x = Tab_Cellule->Cellule[i].Coord.x_coord;
	y = Tab_Cellule->Cellule[i].Coord.y_coord;

	switch (Code_direction)
	{
			case eHaut :
					coord_calcule = y_moins1 (y);
					if (Grille->Don_Grille[x][coord_calcule].Num_cellule == 0)
					{
						Tab_Cellule->Cellule[i].Coord.y_coord = coord_calcule;
						
						Grille->Don_Grille[x][y].Num_cellule = 0;
						Grille->Don_Grille[x][coord_calcule].Num_cellule = i;
					}
					break;
			case eBas :
					coord_calcule = y_plus1 (y);
					if (Grille->Don_Grille[x][coord_calcule].Num_cellule == 0)
					{
						Tab_Cellule->Cellule[i].Coord.y_coord = coord_calcule;
						
						Grille->Don_Grille[x][y].Num_cellule = 0;
						Grille->Don_Grille[x][coord_calcule].Num_cellule = i;
					}
					break;
			case eGauche :
					coord_calcule = x_moins1 (x);
					if (Grille->Don_Grille[coord_calcule][y].Num_cellule == 0)
					{
						Tab_Cellule->Cellule[i].Coord.x_coord = coord_calcule;
						
						Grille->Don_Grille[x][y].Num_cellule = 0;
						Grille->Don_Grille[coord_calcule][y].Num_cellule = i;
					}	
					break;
			case eDroite :
					coord_calcule = x_plus1 (x);
					if (Grille->Don_Grille[coord_calcule][y].Num_cellule == 0)
					{
						Tab_Cellule->Cellule[i].Coord.x_coord = coord_calcule;
						
						Grille->Don_Grille[x][y].Num_cellule = 0;
						Grille->Don_Grille[coord_calcule][y].Num_cellule = i;
					}
					break;
	}
}

//*****************************************************
// Execute l'acte de manger d'une cellule.
//*****************************************************
void Manger (unsigned int i)
{
	unsigned int x = Tab_Cellule->Cellule[i].Coord.x_coord;
	unsigned int y = Tab_Cellule->Cellule[i].Coord.y_coord;
	unsigned int coord_calcule;
	
	// Sur la case. 
	Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,Grille->Don_Grille[x][y].Nb_Nourriture);
	Grille->Don_Grille[x][y].Nb_Nourriture = 0;

	// A droite. 
	coord_calcule = x_plus1 (x);
	if (Grille->Don_Grille[coord_calcule][y].Num_cellule != OBSTACLE) // Obstacle
	{
		if (Grille->Don_Grille[coord_calcule][y].Num_cellule != 0 && Tab_Cellule->Cellule[Grille->Don_Grille[coord_calcule][y].Num_cellule].Defense == 0)
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,(int)(Tab_Cellule->Cellule[Grille->Don_Grille[coord_calcule][y].Num_cellule].Nourriture * RATIO_MANGER));
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,BONUS_POUR_PREDATION); 
			Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,MALUS_POUR_PREDATION); 
			Tab_Cellule->Cellule[Grille->Don_Grille[coord_calcule][y].Num_cellule].Mort = TRUE;
			Grille->Don_Grille[coord_calcule][y].Num_cellule = 0;
		}
		else
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,Grille->Don_Grille[coord_calcule][y].Nb_Nourriture);
			Grille->Don_Grille[coord_calcule][y].Nb_Nourriture = 0;
		}
	}

	// A gauche. 
	coord_calcule = x_moins1(x);
	if (Grille->Don_Grille[coord_calcule][y].Num_cellule != OBSTACLE) // Obstacle
	{
		if (Grille->Don_Grille[coord_calcule][y].Num_cellule != 0 && Tab_Cellule->Cellule[Grille->Don_Grille[coord_calcule][y].Num_cellule].Defense == 0)
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,(int)(Tab_Cellule->Cellule[Grille->Don_Grille[coord_calcule][y].Num_cellule].Nourriture * RATIO_MANGER));
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,BONUS_POUR_PREDATION); 
			Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,MALUS_POUR_PREDATION);
			Tab_Cellule->Cellule[Grille->Don_Grille[coord_calcule][y].Num_cellule].Mort = TRUE;
			Grille->Don_Grille[coord_calcule][y].Num_cellule = 0;
		}
		else
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,Grille->Don_Grille[coord_calcule][y].Nb_Nourriture);
			Grille->Don_Grille[coord_calcule][y].Nb_Nourriture = 0;
		}
	}

	// En haut. 
	coord_calcule = y_plus1(y);
	if (Grille->Don_Grille[x][coord_calcule].Num_cellule != OBSTACLE) // Obstacle
	{
		if (Grille->Don_Grille[x][coord_calcule].Num_cellule != 0 && Tab_Cellule->Cellule[Grille->Don_Grille[x][coord_calcule].Num_cellule].Defense == 0)
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,(int)(Tab_Cellule->Cellule[Grille->Don_Grille[x][coord_calcule].Num_cellule].Nourriture * RATIO_MANGER));
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,BONUS_POUR_PREDATION); 
			Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,MALUS_POUR_PREDATION);
			Tab_Cellule->Cellule[Grille->Don_Grille[x][coord_calcule].Num_cellule].Mort = TRUE;
			Grille->Don_Grille[x][coord_calcule].Num_cellule = 0;
		}
		else
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,Grille->Don_Grille[x][coord_calcule].Nb_Nourriture);
			Grille->Don_Grille[x][coord_calcule].Nb_Nourriture = 0;
		}
	}

	// En bas. 
	coord_calcule = y_moins1(y);
	if (Grille->Don_Grille[x][coord_calcule].Num_cellule != OBSTACLE) // Obstacle
	{
		if (Grille->Don_Grille[x][coord_calcule].Num_cellule != 0 && Tab_Cellule->Cellule[Grille->Don_Grille[x][coord_calcule].Num_cellule].Defense == 0)
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,(int)(Tab_Cellule->Cellule[Grille->Don_Grille[x][coord_calcule].Num_cellule].Nourriture * RATIO_MANGER));
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,BONUS_POUR_PREDATION);
			Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,MALUS_POUR_PREDATION);
			Tab_Cellule->Cellule[Grille->Don_Grille[x][coord_calcule].Num_cellule].Mort = TRUE;
			Grille->Don_Grille[x][coord_calcule].Num_cellule = 0;
		}
		else
		{
			Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,Grille->Don_Grille[x][coord_calcule].Nb_Nourriture);
			Grille->Don_Grille[x][coord_calcule].Nb_Nourriture = 0;
		}
	}
}

//*****************************************************
// Cration alatoire d'une nouvelle cellule.
//*****************************************************
void Creation_aleatoire_de_cellule (void)
{
	if (nb_viv <NB_CELLULE_MINIMUM && Alea (4) == 1)
	{
		Cellule_alea_une();
	}
}

//*****************************************************
// Execute l'acte de cration d'une cellule.
//*****************************************************
void Creer (unsigned int i)
{
	int k,idirection;
	BOOL flag_creation = FALSE;
	unsigned int x = Tab_Cellule->Cellule[i].Coord.x_coord;
	unsigned int y = Tab_Cellule->Cellule[i].Coord.y_coord;
	unsigned int coord_calcule;

	// Choix d'une direction alatoire. 
	idirection = Alea (NB_DIR);

	for (k=1;k<5;k++)
	{
		switch (idirection)
		{
		case eHaut:
			coord_calcule = y_moins1(y);
			if (Grille->Don_Grille[x][coord_calcule].Num_cellule == 0)
			{
				Creation_cellule(x,coord_calcule,i);
				flag_creation = TRUE;
			}
			break;
		case eBas:
			coord_calcule = y_plus1(y);
			if (Grille->Don_Grille[x][coord_calcule].Num_cellule == 0)
			{
				Creation_cellule(x,coord_calcule,i);
				flag_creation = TRUE;
			}
			break;
		case eGauche:
			coord_calcule = x_moins1(x);
			if (Grille->Don_Grille[coord_calcule][y].Num_cellule == 0)
			{
				Creation_cellule(coord_calcule,y,i);
				flag_creation = TRUE;
			}
			break;
		case eDroite:
			coord_calcule = x_plus1(x);
			if (Grille->Don_Grille[coord_calcule][y].Num_cellule == 0)
			{
				Creation_cellule(coord_calcule,y,i);
				flag_creation = TRUE;
			}
			break;
		}
		if (!flag_creation)
		{
			if (idirection==4)
				idirection = 1;
			else
				idirection++;
		}
		else
		{
			break;
		}
	}
}

//*****************************************************
// Cration d'une cellule.
//*****************************************************
void Creation_cellule(unsigned int x,unsigned int y, unsigned int n_cell)
{
	int i;
	int Div_par2;
	
	for (i=1;i<MAX_CELL+1;i++)
	{
		if (Tab_Cellule->Cellule[i].Mort)
		{
			Tab_Cellule->Cellule[i].Mort = FALSE;
			Tab_Cellule->Cellule[i].PointDeVie = 0;
			Tab_Cellule->Cellule[i].Defense = 0;
			Div_par2 = Tab_Cellule->Cellule[n_cell].Nourriture/2;
			Tab_Cellule->Cellule[i].Nourriture = Div_par2;
			Tab_Cellule->Cellule[n_cell].Nourriture=Div_par2;
			Tab_Cellule->Cellule[i].Coord.x_coord = x;
			Tab_Cellule->Cellule[i].Coord.y_coord = y;
			
			Grille->Don_Grille[x][y].Num_cellule = i;

			// Duplication de l'agent.
			duplication_agent(agent[n_cell]->tab_poids,i);

			// Mutation d'un poids. 
			if (Alea(MUTATION_POIDS) == 1)
			{
				change_poids(i);
			}

			break;
		}
	}
}

//*****************************************************
// Execute la mutation d'une cellule.
//*****************************************************
void Mutation (int num_cell)
{
		int x,y;

		x = Tab_Cellule->Cellule[num_cell].Coord.x_coord ;
		y = Tab_Cellule->Cellule[num_cell].Coord.y_coord ;

		// Mutation d'un poids. 
		if (Alea(MUTATION) == 1)
		{
			change_poids(num_cell);
		}
}

//*****************************************************
// Execute l'acte de distribution d'une cellule.
//*****************************************************
void Distribuer (unsigned int i)
{
	int k,idirection,iFract_nour,num_cell;
	unsigned int x = Tab_Cellule->Cellule[i].Coord.x_coord;
	unsigned int y = Tab_Cellule->Cellule[i].Coord.y_coord;
	unsigned int coord_calcule;

	int max_defense = 256-DISTRIB_DEFENSE;

	// Choix d'une direction alatoire. 
	idirection = Alea (NB_DIR);

	// Pendant la distribution la cellule se defend.
	// Tab_Cellule->Cellule[i].Defense=0;

	for (k=1;k<5;k++)
	{
		switch (idirection)
		{
		case eHaut:
			coord_calcule = y_moins1(y);
			num_cell = Grille->Don_Grille[x][coord_calcule].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
				iFract_nour = (int)(Tab_Cellule->Cellule[i].Nourriture/6);
				Distribuer_Nourriture(num_cell,iFract_nour);
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,iFract_nour);
				
				// Ajout defense lors d'une distribution.
				if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=DISTRIB_DEFENSE;
			}
			break;

		case eBas:
			coord_calcule = y_plus1(y);
			num_cell = Grille->Don_Grille[x][coord_calcule].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
				iFract_nour = (int)(Tab_Cellule->Cellule[i].Nourriture/6);
				Distribuer_Nourriture(num_cell,iFract_nour);
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,iFract_nour);

				// Ajout defense lors d'une distribution.
				if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=DISTRIB_DEFENSE;
			}
			break;

		case eGauche:
			coord_calcule = x_moins1(x);
			num_cell = Grille->Don_Grille[coord_calcule][y].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
				iFract_nour = (int)(Tab_Cellule->Cellule[i].Nourriture/6);
				Distribuer_Nourriture(num_cell,iFract_nour);
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,iFract_nour);

				// Ajout defense lors d'une distribution.
				if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=DISTRIB_DEFENSE;
			}
			break;

		case eDroite:
			coord_calcule = x_plus1(x);
			num_cell = Grille->Don_Grille[coord_calcule][y].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
				iFract_nour = (int)(Tab_Cellule->Cellule[i].Nourriture/6);
				Distribuer_Nourriture(num_cell,iFract_nour);
				Nourriture_moins (&Tab_Cellule->Cellule[i].Nourriture,iFract_nour);

				// Ajout defense lors d'une distribution.
				if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=DISTRIB_DEFENSE;
			}
			break;
		}
		if (idirection==4)
			idirection = 1;
		else
			idirection++;
	}
}

//*****************************************************
// Execute la distribution de nourriture.
//*****************************************************
void Distribuer_Nourriture (unsigned int i,unsigned int j)
{
	Nourriture_plus (&Tab_Cellule->Cellule[i].Nourriture,j);
}

//*****************************************************
// Execute l'association d'une cellule.
//*****************************************************
void Associer (unsigned int i)
{
	int num_cell,j;
	unsigned int x = Tab_Cellule->Cellule[i].Coord.x_coord;
	unsigned int y = Tab_Cellule->Cellule[i].Coord.y_coord;
	unsigned int coord_calcule;

	int max_defense = 256-ASSOCIE_DEFENSE;

	Tab_Cellule->Cellule[i].Defense += 1;

	// Bonus en nourriture (au centre) pour chaque action associer.
	BONUS_ASSOCIER+=INC_BONUS_ASSOCIER;

	// Idem bonus associer mais propre  une zone de l'cran.
	if (x > 42 && x < 57)
	{
		if (y > 70 && y < 86)
			BONUS_ASSOCIER_SPECIAL+=INC_BONUS_ASSOCIER_SPECIAL;
	}

	for (j=1;j<5;j++)
	{
		switch (j)
		{
		case eHaut:
			coord_calcule = y_moins1(y);
			num_cell = Grille->Don_Grille[x][coord_calcule].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
					if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=ASSOCIE_DEFENSE;
			}
			break;

		case eBas:
			coord_calcule = y_plus1(y);
			num_cell = Grille->Don_Grille[x][coord_calcule].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
					if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=ASSOCIE_DEFENSE;
			}
			break;

		case eGauche:
			coord_calcule = x_moins1(x);
			num_cell = Grille->Don_Grille[coord_calcule][y].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
					if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=ASSOCIE_DEFENSE;
			}
			break;

		case eDroite:
			coord_calcule = x_plus1(x);
			num_cell = Grille->Don_Grille[coord_calcule][y].Num_cellule;
			if (num_cell != OBSTACLE && num_cell != 0)
			{
					if (Tab_Cellule->Cellule[i].Defense < max_defense)
						Tab_Cellule->Cellule[i].Defense+=ASSOCIE_DEFENSE;
			}
			break;
		}
	}
}

//*********************************************************
// Dcomposition dela table ces cellules pour compression.
//*********************************************************
void Valoriser_bit (int i)
{
	int num_case;
	int num_octet;
	int num_bit;
	// La cellule se trouve sur la grille. On dertermine le numero 
	// de la case dans la grille. 
	num_case = (Tab_Cellule->Cellule[i].Coord.x_coord - 1) * MAX_X + 
				Tab_Cellule->Cellule[i].Coord.y_coord;
	// Il faut determiner  quel octet appartient la case. 
	num_octet = (num_case-1)/8 + 1;
	// Pour avoir la position du bit dans l'octet, il faut prendre
	//   le reste de la division (modulo).
	num_bit = num_case%8;
	if (num_bit == 0)
		num_bit = 8;

	TableCompression.Bcase[num_octet] |= Byte_masq[num_bit];
}

//*****************************************************
// Valorisation des parametres de dimension.
//*****************************************************
void definir_parametres ()
{
	// Dimensions.
	X_LIBELLE        =(MAX_X*DIM_CELLULE)+(DIM_CELLULE*2)+4;
	DIM_RECTANGLE_X  =(MAX_X*DIM_CELLULE)+DIM_CELLULE;
	DIM_RECTANGLE_Y  =(MAX_Y*DIM_CELLULE)+DIM_CELLULE;
}

//*******************************************************
// Valorisation des parametres pour les agents neurnaux.
//*******************************************************
bool definir_parametres_agents ()
{	
	// Paramtres des agents neuronnaux.

	NB_NEURONNES = NB_NEUR_ENTREE + NB_NEUR_SORTIE + ((NB_COUCHES-2) * NB_NEUR_COUCH);

	IND_NEUR_STOCK_NOURR = NB_NEUR_PDV + NB_NEUR_STOCK_NOURR;
	IND_NEUR_SORTIE = NB_NEUR_ENTREE + ((NB_COUCHES-2) * NB_NEUR_COUCH);
	IND_NEUR_SORTIE_DIR = IND_NEUR_SORTIE + NB_NEUR_SORTIE_ACTION;
	IND_NEUR_SORTIE_COM = IND_NEUR_SORTIE_DIR + NB_NEUR_SORTIE_DIR;

	NB_POIDS = (NB_NEUR_ENTREE * NB_NEUR_COUCH) + (NB_NEUR_SORTIE * NB_NEUR_COUCH) + ((NB_COUCHES-3) * NB_NEUR_COUCH * NB_NEUR_COUCH);

	if (NB_POIDS <= MAX_POIDS  && NB_COUCHES > 2)
		return true;
	else
		return false;
}

//*****************************************************
// Initialisation de la grille.s
//*****************************************************
void Init_grille (void)
{
	int i;
	// Initialisation table inverse (Grille). 
	for (i=1;i<MAX_CELL+1;i++)
	{
		// Valorisation de l'indice dans la table inverse. 
		// Si la cellule est morte, il ne faut pas lui attribuer de case. 
		if (!Tab_Cellule->Cellule[i].Mort)
		{
			// Cration d'un agent neuronal.
			init_agent(Tab_Cellule->Cellule[i].Poids,i); 
			if (Grille->Don_Grille[Tab_Cellule->Cellule[i].Coord.x_coord][Tab_Cellule->Cellule[i].Coord.y_coord].Num_cellule == 0)
			{
				Grille->Don_Grille[Tab_Cellule->Cellule[i].Coord.x_coord][Tab_Cellule->Cellule[i].Coord.y_coord].Num_cellule=i;
			}
		}
	}

	// On quatre coin du tableau nous creeons des points nourritures se dplacant.
	memset (&nourdep,0x00,sizeof(sNourrideplacante));
	nourdep.Coord[1].x_coord = 1;
	nourdep.Coord[1].y_coord = 1;
	nourdep.Coord[2].x_coord = 1;
	nourdep.Coord[2].y_coord = MAX_Y;
	nourdep.Coord[3].x_coord = MAX_X;
	nourdep.Coord[3].y_coord = 1;
	nourdep.Coord[4].x_coord = MAX_X;
	nourdep.Coord[4].y_coord = MAX_Y;
}

//*****************************************************
// Initialisation de la nourriture  zro.
//*****************************************************
void Init_Nourriture (void)
{
	int x,y;
	
	for (x=1;x<=MAX_X;x++)
	{
		for (y=1;y<=MAX_Y;y++)
		{
			Grille->Don_Grille[x][y].Nb_Nourriture = 0;
		}
	}
}

//*****************************************************
// Controle de la nourriture.
//*****************************************************
void Controle_Nourriture (void)
{
	int x,y;
	unsigned int a_nour;
	long nb_nour = 0;
	HDC hDC;

	hDC = GetDC(ghWnd);

	for (x=1;x<=MAX_X;x++)
	{
		for (y=1;y<=MAX_Y;y++)
		{
			a_nour = Grille->Don_Grille[x][y].Nb_Nourriture;

			if (a_nour < MAX_NOURRI)
			{
				if (nb_nour < LONG_MAX-100000)
					nb_nour += a_nour;
					
				// brush de la nourriture. 
				if (a_nour > 300)
				{
					SetPixelV(hDC,x*DIM_CELLULE,y*DIM_CELLULE,RGB(255,5,5));
				}
			}
		}
	}
	if (nb_nour > LONG_MAX-100000)
		nb_nour = LONG_MAX -1;

	HWND hedit = GetDlgItem(hDlgStat,IDC_NBNOUR);
	SetDlgItemInt(hDlgStat,IDC_NBNOUR,nb_nour,FALSE);

	ReleaseDC(ghWnd,hDC);
}

//*****************************************************
// Controle de la grille.
//*****************************************************
BOOL Controle_grille (void)
{
	int i;
	// Initialisation table inverse (Grille). 
	for (i=1;i<MAX_CELL+1;i++)
	{
		// Valorisation de l'indice dans la table inverse. 
		// Si la cellule est morte, il ne faut pas lui attribuer de case. 
		if (!Tab_Cellule->Cellule[i].Mort)
		{
			if (Grille->Don_Grille[Tab_Cellule->Cellule[i].Coord.x_coord][Tab_Cellule->Cellule[i].Coord.y_coord].Num_cellule !=(unsigned int) i)
				return (FALSE);
		}
	}
	return (TRUE);
}

//*****************************************************
// Controle de validit de la mmoire.
//*****************************************************
BOOL Controle_Memoire (void)
{
	char tcTrace [255];

	if (Tab_Cellule == NULL)
	{
		wsprintf(tcTrace,"Problme sur Tab_Cellule.\n");
		OutputDebugString(tcTrace);
		return (FALSE);
	}
	if (Grille == NULL)
	{
		wsprintf(tcTrace,"Problme sur Grille.\n");
		OutputDebugString(tcTrace);
		return (FALSE);
	}

	if (GlobalFlags( hMemCell) == GMEM_DISCARDED)
	{
		wsprintf(tcTrace,"Problme sur Tab_Cellule DISCARDED.\n");
		OutputDebugString(tcTrace);
		return (FALSE);
	}

	return (TRUE);
}

//*****************************************************
// Cration de cellules alatoirement.
//*****************************************************
VOID Cellule_alea (void)
{
	int i;
	unsigned int x,y;
	
	for (i=1;i<NB_CELLULE+1;i++)
	{ 
			Tab_Cellule->Cellule[i].PointDeVie = 0;
			Tab_Cellule->Cellule[i].Mort = FALSE;
			Tab_Cellule->Cellule[i].Defense = 0;
			Tab_Cellule->Cellule[i].Nourriture = 200;

			init_agent_alea(Tab_Cellule->Cellule[i].Poids,i); // Cration d'un agent neuronal.

			do
			{
				// Position sur l'axe des x. 
				x = Alea (MAX_X);
				// Position sur l'axe des y. 
				y = Alea (MAX_Y);
			}
			while (Grille->Don_Grille[x][y].Num_cellule !=0);	
		
			Tab_Cellule->Cellule[i].Coord.x_coord = x;
			Tab_Cellule->Cellule[i].Coord.y_coord = y;
			
			Grille->Don_Grille[x][y].Num_cellule = i;
	}

	for (i=NB_CELLULE+1;i<MAX_CELL+1;i++)
	{
			Tab_Cellule->Cellule[i].Mort = TRUE;
			Tab_Cellule->Cellule[i].Coord.x_coord = 0;
			Tab_Cellule->Cellule[i].Coord.y_coord = 0;
	}
}

//***********************************************************
// Cration de cellules alatoirement. (fait en automatique)
//***********************************************************
VOID Cellule_alea_auto (void)
{
	int i;
	unsigned int x,y;
	
	for (i=1;i<NB_CELLULE+1;i++)
	{ 
		if (Tab_Cellule->Cellule[i].Mort)
		{
			Tab_Cellule->Cellule[i].PointDeVie = 0;
			Tab_Cellule->Cellule[i].Mort = FALSE;
			Tab_Cellule->Cellule[i].Defense = 0;
			Tab_Cellule->Cellule[i].Nourriture = 200;

			init_agent_alea(Tab_Cellule->Cellule[i].Poids,i); // Cration d'un agent neuronal.

			do
			{
				// Position sur l'axe des x. 
				x = Alea (MAX_X);
				// Position sur l'axe des y. 
				y = Alea (MAX_Y);
			}
			while (Grille->Don_Grille[x][y].Num_cellule !=0);	
		
			Tab_Cellule->Cellule[i].Coord.x_coord = x;
			Tab_Cellule->Cellule[i].Coord.y_coord = y;
			
			Grille->Don_Grille[x][y].Num_cellule = i;
		}
	}

	for (i=NB_CELLULE+1;i<MAX_CELL+1;i++)
	{
			Tab_Cellule->Cellule[i].Mort = TRUE;
			Tab_Cellule->Cellule[i].Coord.x_coord = 0;
			Tab_Cellule->Cellule[i].Coord.y_coord = 0;
	}
}

//*****************************************************
// Ajout d'un cellule alatoirement.
//*****************************************************
VOID Cellule_alea_une (void)
{
	int i;
	unsigned int x,y;
	
	for (i=1;i<NB_CELLULE+1;i++)
	{ 
		if (Tab_Cellule->Cellule[i].Mort)
		{
			Tab_Cellule->Cellule[i].PointDeVie = 0;
			Tab_Cellule->Cellule[i].Mort = FALSE;
			Tab_Cellule->Cellule[i].Defense = 0;
			Tab_Cellule->Cellule[i].Nourriture = 200;

			init_agent_alea(Tab_Cellule->Cellule[i].Poids,i); // Cration d'un agent neuronal.

			do
			{
				// Position sur l'axe des x. 
				x = Alea (MAX_X);
				// Position sur l'axe des y. 
				y = Alea (MAX_Y);
			}
			while (Grille->Don_Grille[x][y].Num_cellule !=0);	
		
			Tab_Cellule->Cellule[i].Coord.x_coord = x;
			Tab_Cellule->Cellule[i].Coord.y_coord = y;
			
			Grille->Don_Grille[x][y].Num_cellule = i;

			return;
		}
	}
}

//*****************************************************
// Ajout alatoire de nourriture au dmarrage.
//*****************************************************
VOID Nourriture_alea_init (void)
{
	unsigned int i;
	unsigned int x,y;
	
	for (i=1;i<MAX_NOURRI_ALEA_INIT+1;i++)
	{
		// Position sur l'axe des x. 
		x = Alea (MAX_X);
		// Position sur l'axe des y. 
		y = Alea (MAX_Y);
			
		if (Grille->Don_Grille[x][y].Nb_Nourriture < MAX_NOURRI)
			Grille->Don_Grille[x][y].Nb_Nourriture++;
	}
}

//*****************************************************
// Ajout alatoire de nourriture.
//*****************************************************
VOID Nourriture_alea_alim (void)
{
	int i;
	//int j,alea,x1,y1;
	unsigned int x,y;
	
	for (i=1;i<NOURRI_AUTO+1;i++)
	{
		// Position sur l'axe des x. 
		x = Alea (MAX_X);
		// Position sur l'axe des y. 
		y = Alea (MAX_Y);
			
		if (Grille->Don_Grille[x][y].Nb_Nourriture < MAX_NOURRI)
			Grille->Don_Grille[x][y].Nb_Nourriture++;
	}
	
	// Nourriture au centre. Un Bonus en nourriture est ajout pour chaque action associer.
	for (i=1;i<NOURRI_CENTRE+BONUS_ASSOCIER+1;i++)
	{
		x = (MAX_X/2) + (Alea (20)-10);
		y = (MAX_Y/2) + (Alea (20)-10);
		if (Grille->Don_Grille[x][y].Nb_Nourriture < MAX_NOURRI)
			Grille->Don_Grille[x][y].Nb_Nourriture++;
	}

	// Nourriture au quatre points en se deplacant.
	/*for (j=1;j<=1;j++)
	{
		x1 = nourdep.Coord[j].x_coord;
		y1 = nourdep.Coord[j].y_coord;
		for (i=1;i<NOURRI_DEPLACANTE+1;i++)
		{
			alea = Alea (10)-5;
			x = x_plus(x1,alea);
			alea = Alea (10)-5;
			y = y_plus(y1,alea);

			if (Grille->Don_Grille[x][y].Nb_Nourriture < MAX_NOURRI)
				Grille->Don_Grille[x][y].Nb_Nourriture++;
			// Deplacement alatoire.
			switch (Alea(4))
			{
				case eHaut :
						nourdep.Coord[j].y_coord = y_moins1 (y1);
						break;
				case eBas :
						nourdep.Coord[j].y_coord = y_plus1 (y1);
						break;
				case eGauche :
						nourdep.Coord[j].x_coord = x_moins1 (x1);
						break;
				case eDroite :
						nourdep.Coord[j].x_coord = x_plus1 (x1);
						break;
			}
		}

	}*/
}

//*****************************************************
// Ajout alatoire de nourriture jusqu' un maximun.
//*****************************************************
VOID Nourriture_alea_max_alim (void)
{
	unsigned int i;
	unsigned int x,y;
	
	for (i=1;i<MAX_NOURRI_ALEA_MAX_ALIM+1;i++)
	{
		// Position sur l'axe des x. 
		x = Alea (MAX_X);
		// Position sur l'axe des y. 
		y = Alea (MAX_Y);
			
		if (Grille->Don_Grille[x][y].Nb_Nourriture < MAX_NOURRI)
			Grille->Don_Grille[x][y].Nb_Nourriture++;
	}
}

//*****************************************************
// Possibilit de rcrer un monde automatiquement.
//*****************************************************
void Relance_automatique (HANDLE hFile,HWND hWnd)
{
	Init_Nourriture();
	Nourriture_alea_init ();	// Dispertion alatoire de nourritures. 
	Dessin_obstacle();
	Cellule_alea_auto ();		// Cration alatoire de 100 cellules 
	Sauvegarde (hFile);
}

//*****************************************************
// Initialisation de tous les agents neuronaux.
//*****************************************************
void creation_tous_les_agents()
{
	int i;
	for (i=1;i<MAX_CELL+1;i++)
	{
		creation_agent(i);
	}
}

//*****************************************************
// Creation d'un agent neuronal.
//*****************************************************
void creation_agent(int num_cell)
{
   agent[num_cell] = new Agent(NB_COUCHES,
							   NB_NEUR_ENTREE,
							   NB_NEUR_COUCH,
							   NB_NEUR_COUCH,
							   NB_NEUR_SORTIE);

   agent[num_cell]->init_neuronnes();
}

//*****************************************************
// Initialisation des poids aleatoirement d'un agent.
//*****************************************************
void init_agent_alea(float * ptPoids,int num_cell)
{
   agent[num_cell]->init_poids();
   agent[num_cell]->lect_poids(ptPoids);
}

//*****************************************************
// Initialisation d'un agent  partir de poids existant.
//*****************************************************
void init_agent(float * ptPoids,int num_cell)
{
   agent[num_cell]->init_poids(ptPoids);
}

//*****************************************************
// Duplication d'un agent neuronal.
//*****************************************************
void duplication_agent(float * ptPoids,int num_cell)
{
   agent[num_cell]->init_poids(ptPoids);
}

//*****************************************************
// Destruction d'un agent neuronal.
//*****************************************************
void detruire_agent (int num_cell)
{
	//agent[num_cell]->libe_memoire();
	delete (agent[num_cell]);
}

//*****************************************************
// Detruire tous les agents neuronal.
//*****************************************************
void detruire_tous_les_agents ()
{
	int i;
	for (i=1;i<MAX_CELL+1;i++)
	{
			detruire_agent(i);
	}
}

//*****************************************************
// saugegarde de tous les agents neuronal en memoire.
//*****************************************************
void sauvegarde_agent()
{
	int i;
	for (i=1;i<MAX_CELL+1;i++)
	{
			agent[i]->lect_poids(Tab_Cellule->Cellule[i].Poids);
	}
}

//*****************************************************
// Changement alatoire d'un poids.
//*****************************************************
void change_poids(int num_cell)
{
	agent[num_cell]->init_poids(agent[num_cell]->Alea_poids(),Alea(NB_POIDS));
}

//****************************************************************
// Calcul frequence de calcul. (pas de programme par seconde).
//****************************************************************
void calcul_frequence()
{
	int tick,diff_tick,freq;

	tick = GetTickCount();

	if (hDlgStat)
	{
		diff_tick = tick - dernier_tick;
		freq = (int)(1000.0/diff_tick);
		SetDlgItemInt(hDlgStat,IDC_PASSEC,freq,FALSE);
	}

	dernier_tick = tick;
}