//********************************************************************
//* Programme			: Vie_Agent
//*	Auteur				: Emmanuel Chauvin.
//* Date de cration	: 19/06/2001 
//* 
//* Description			: Vie Artificielle.
//*
//********************************************************************
#include <windows.h>
#include <commctrl.h>
#include <wingdi.h>
#include <stdio.h>
#include <time.h>
#include <signal.h>

#include "Vie_Agent.h"
#include <ZMouse.h>
#include "resource.h"
#include "Agent.h"
#include "outils.h"
#include "calcul.h"

#if defined (WIN32)
	#define IS_WIN32 TRUE
#else
	#define IS_WIN32 FALSE
#endif

#define IS_NT      IS_WIN32 && (BOOL)(GetVersion() < 0x80000000)
#define IS_WIN32S  IS_WIN32 && (BOOL)(!(IS_NT) && (LOBYTE(LOWORD(GetVersion()))<4))
#define IS_WIN95   (BOOL)(!(IS_NT) && !(IS_WIN32S)) && IS_WIN32

//********************************************
// Parametres pour affichage de l'application.
//*********************************************
#define X_BORD_VIE 4					// Dimension du bord gauche de la fentre.
#define Y_BORD_VIE 42				    // Dimension du bord en bas de la fentre.
#define Y_BORD_DIAL 0					// Position horizontale  partir de laquelle on affiche
										// les boites de dialogue.

#define TAIL_VUECELL 640			// Dimension de la fenetre Vue_cell

//****************************************
// Parametres generaux de l'application.
//****************************************
extern int DIM_CELLULE;				// Dimension d'une cellule  l'affichage.
extern int X_LIBELLE;
extern int DIM_RECTANGLE_X;
extern int DIM_RECTANGLE_Y;

extern int NOURRI_AUTO;				// quantit de nourriture distribue alatoirement  chaque pas de prog.
extern int NOURRI_CENTRE;			// nourriture paraseme au milieu.

extern unsigned int MAX_NOURRI;		// Dfinition des maximums. 

extern int MUTATION;
extern int MUTATION_POIDS;
extern int COUT_POUR_DEPLACER;
extern int COUT_POUR_MANGER;
extern int COUT_POUR_CREER;
extern int COUT_POUR_ASSOCIER;
extern int COUT_POUR_DISTRIBUER;
extern int COUT_POUR_DEFAULT;

extern int DISTRIB_DEFENSE;
extern int ASSOCIE_DEFENSE;
extern int INC_BONUS_ASSOCIER;				// Incrment du Bonus en nourriture est ajout pour chaque action associer.
extern int INC_BONUS_ASSOCIER_SPECIAL;		// Incrment du Bonus special associer pour une region prcise.

//****************************************
// Variables du serveur pour affichage. 
//****************************************
extern int port_client;						// port du client qui vient de se connecter.

//****************************
// Donnes du module calcul.
//**************************** 
extern HANDLE hThreadCalcul;				// Handle du thread de calcul.
extern HANDLE hFileDonnee;
extern sTab_Cellule * Tab_Cellule;			// Pointeur sur tableau de cellules. 
extern sGrille * Grille;					// Table inverse de la table des cellule. 
extern sTableCompression TableCompression;	// Compression de la grille afin de l'envoyer  l'applet Java.
extern Agent *agent[MAX_CELL+1];			// Table des agents neuronaux.
									 
extern HGLOBAL hMemCell;

extern BOOL Flag_Very_Sleep;				// Vitesse d'execution tres lente
extern BOOL Flag_Sleep;						// Vitesse d'execution lente
extern BOOL Flag_Moy_Sleep;					// Vitesse d'execution moyenne
extern BOOL Flag_Pause;						// Flag pour touche Pause
extern BOOL FlagExitThread;					// Pour sortir du Thread.

extern int nb_viv;

extern int NB_COUCHES;						// Nombre de couches pour les agents neuronaux.
extern int NB_NEUR_SORTIE;					// Nombre de neurones de sortie 
											// (5 code action + 2 direction + 5 de communication).
extern int NB_NEUR_ENTREE;					// Correspondant au total de neuronnes en entree 
extern int NB_NEUR_COUCH;					// Nombre de neurone pour une couche intermediaire.
extern int NB_POIDS;						// Correspondant 28 X 10 X 10 X 7 neuronnes.

extern int IND_NEUR_SORTIE;					// Indice du neurone  partir duquel il y a la reponse.
extern int IND_NEUR_SORTIE_DIR;				// Indice neurone sortie pour le reponse direction.

extern char tcSauv[255];					// Message de sauvergarde pour stats.

extern bool bVisu_associer;					// Visualisation des cellules associees.
extern bool bVisu_distribuer;				// Visualisation des cellules distribues.

//***********************************
// Fonctions externes. 
//***********************************
extern BOOL envoi_du_fichier_adresIP (HWND hWnd);

//***********************************
// Donnes pour grer Windows.
//***********************************
HINSTANCE hInst;							// current instance
HWND ghWnd;									// Handle global de la fentre.
HWND hDlgVueCell = NULL;					// Handle boite de dialogue 'VUE_CELL'
HWND hDlgStat = NULL;						// Handle boite de dialogune Statistiques.
HWND hwndPB;								// handle of progress bar 

LPCTSTR lpszAppName  = "Vie_artificielle";
LPCTSTR lpszTitle    = "Vie artificielle";

// Bouton plus ou moins nourriture.
HWND hboutonnour;							// Texte static
HWND hCtrlnour;	

// Controle de la boite de dialogue Vue_cell.
HWND hspinCtrl;							    // +/- nourriture

BOOL Flag_Mouse =FALSE;						// Flag pour Capture d'une cellule par souris.
PAINTSTRUCT ps;								// Structure pour WM_PAINT. 
BOOL RegisterWin95( CONST WNDCLASS* lpwc ); // Fonction registre windows.


HBRUSH obs_brush;							// Brush pour dessin.
RECT obs_rect[50];							// Tableau des obstacles. (coordonnes des rectangles GDI)
RECT obs_rect_virtuel[50];					// Obstacles avec coordonnes logiques.

HMENU hMenuVie;								// Menu principal de l'application.

//***********************************
// Variables globales diverses. 
//***********************************
int nb_obstable = 0;
int nb_rel_auto=0;
int Capt_cell = 1;							// Numro de la cellue capture.
int nTimer;
int Timer_sauvegarde;
char szMsg [128];

int X_MOVE = 0;
int Y_MOVE = 0;

//********************************************************************
// Dmarrage Windows.
//********************************************************************
int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,LPTSTR lpCmdLine, int nCmdShow)
{
   MSG      msg;
   HWND     hWnd; 
   WNDCLASS wc;

   // Tests
   /*float f = -0.99988;
   float rf;
   dfloat df;

   df = conv_float_dfloat(f);
   rf = conv_dfloat_float(df);*/

   definir_parametres();

   if (!definir_parametres_agents())
		return( FALSE );

   Init_Alea ();

   // Register the main application window class.
   //............................................
   wc.style         = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = (WNDPROC)WndProc;       
   wc.cbClsExtra    = 0;                      
   wc.cbWndExtra    = 0;                      
   wc.hInstance     = hInstance;              
   wc.hIcon         = LoadIcon( hInstance, lpszAppName ); 
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW);
   wc.lpszMenuName  = lpszAppName;              
   wc.lpszClassName = lpszAppName;              

   if ( IS_WIN95 )
   {
      if ( !RegisterWin95( &wc ) )
         return( FALSE );
   }
   else if ( !RegisterClass( &wc ) )
      return( FALSE );

   hInst = hInstance; 

   // Menu de la fenetre.
   hMenuVie = LoadMenu(hInst,MAKEINTRESOURCE(IDR_MENUVIE));

   //*************************************
   // Create the main application window.
   //*************************************
   hWnd = CreateWindow( lpszAppName, 
                        lpszTitle,    
                        WS_OVERLAPPEDWINDOW, 
                        0, 0, 
                        X_LIBELLE + X_BORD_VIE, X_LIBELLE + Y_BORD_VIE,  
                        NULL,              
                        hMenuVie,              
                        hInstance,         
                        NULL               
                      );

   if ( !hWnd ) 
      return( FALSE );

   // Ici on lance tous les threads 
   // et les initialisations qui peuvent tourner sans windows.
   Lancer_threads(hWnd);

   // Lancer en mode systray.
   add_systray(hWnd,wc.hIcon);

   // Montrer la fentre.
   //ShowWindow( hWnd, nCmdShow ); 
   //UpdateWindow( hWnd );         

   while( GetMessage( &msg, NULL, 0, 0) )   
   {
		TranslateMessage( &msg ); 
		DispatchMessage( &msg );
   }
   return( msg.wParam ); 
}

//**********************************
// Registre Windows
//**********************************
BOOL RegisterWin95( CONST WNDCLASS* lpwc )
{
   WNDCLASSEX wcex;

   wcex.style         = lpwc->style;
   wcex.lpfnWndProc   = lpwc->lpfnWndProc;
   wcex.cbClsExtra    = lpwc->cbClsExtra;
   wcex.cbWndExtra    = lpwc->cbWndExtra;
   wcex.hInstance     = lpwc->hInstance;
   wcex.hIcon         = lpwc->hIcon;
   wcex.hCursor       = lpwc->hCursor;
   wcex.hbrBackground = lpwc->hbrBackground;
   wcex.hbrBackground = lpwc->hbrBackground;
   wcex.lpszMenuName  = lpwc->lpszMenuName;
   wcex.lpszClassName = lpwc->lpszClassName;

   // Added elements for Windows 95.
   //...............................
   wcex.cbSize = sizeof(WNDCLASSEX);
   wcex.hIconSm = (HICON)LoadImage(wcex.hInstance, lpwc->lpszClassName, 
                            IMAGE_ICON, 16, 16,
                            LR_DEFAULTCOLOR );
			
   return RegisterClassEx( &wcex );
}

//************************************************
// Boucle des messages Windows principale.
//************************************************
LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
   static MSG msg;
   static HWND hStatic = NULL;

   // Utilis pour le systray
   POINT pt;
   HMENU hmenu, hpopup;

   switch( uMsg )
   {
	   case WM_CREATE :
		   {
			// On stocke le handle dans une variable globale. 
			ghWnd = hWnd;

			// brush des obstables. 
			obs_brush = CreateSolidBrush(RGB(91,99,255));

			// Mise en place du timer cellule. Se declenche toutes les 0.1 secondes.
			nTimer = SetTimer (hWnd,MY_TIMER,10,NULL);

			// Mise en place du timer de sauvegarde. Se declenche toutes les 3000 secondes. 
			Timer_sauvegarde = SetTimer (hWnd,TIMER_SAUV,3000000,NULL);

			// On check la vitesse de simultation dans le menu.
			CheckMenuRadioItem (hMenuVie,
			   IDM_VERY_SLEEP,
			   IDM_NOSLEEP,
			   IDM_NOSLEEP,
			   MF_CHECKED);
		   }
		   break;

	  case UWM_SYSTRAY: // We are being notified of mouse activity over the icon
		  switch (lParam)
		  {
			case WM_RBUTTONUP: // Let's track a popup menu
			  GetCursorPos(&pt);
			  hmenu = LoadMenu(hInst, MAKEINTRESOURCE(IDR_SYSTRAY));
			  hpopup = GetSubMenu(hmenu, 0);

			  /* SetForegroundWindow and the ensuing null PostMessage is a
				 workaround for a Windows 95 bug (see MSKB article Q135788,
				 http://www.microsoft.com/kb/articles/q135/7/88.htm, I think).
				 In typical Microsoft style this bug is listed as "by design".
				 SetForegroundWindow also causes our MessageBox to pop up in front
				 of any other application's windows. */
			  SetForegroundWindow(hWnd);
			  /* We specifiy TPM_RETURNCMD, so TrackPopupMenu returns the menu
				 selection instead of returning immediately and our getting a
				 WM_COMMAND with the selection. You don't have to do it this way.
			  */
			  switch (TrackPopupMenu(hpopup,            // Popup menu to track
									 TPM_RETURNCMD |    // Return menu code
									   TPM_RIGHTBUTTON, // Track right mouse button?
									 pt.x, pt.y,        // screen coordinates
									 0,                 // reserved
									 hWnd,              // owner
									 NULL))             // LPRECT user can click in
														// without dismissing menu
			  {
				case ID_QUITTER: 
				  Sauvegarde (hFileDonnee);
				  DestroyWindow(hWnd); 
				  break;

				case ID_FENETRE:
				  // Cration de la bote de dialogue Stat. (contient des variables voluant en temps rels)
				  if (!hDlgStat)
				  {
					hDlgStat = CreateDialog(hInst,MAKEINTRESOURCE(IDD_VUESTAT),hWnd,(DLGPROC)Stat);
					SetActiveWindow(hWnd);
				  }
				  
				  // Montrer la fentre.
				  ShowWindow( hWnd, SW_SHOWNORMAL);
				  UpdateWindow( hWnd );  
				  break;
			  }
			  PostMessage(hWnd, 0, 0, 0); // see above
			  DestroyMenu(hmenu); // Delete loaded menu and reclaim its resources
			  break;

			case WM_LBUTTONDBLCLK:
			  SetForegroundWindow(hWnd); // Our MessageBox pops up in front
			  ShowWindow( hWnd, SW_SHOWNORMAL); 
			  UpdateWindow( hWnd );
			  if (!hDlgStat)
			  {
				 hDlgStat = CreateDialog(hInst,MAKEINTRESOURCE(IDD_VUESTAT),hWnd,(DLGPROC)Stat);
				 SetActiveWindow(hWnd);
			  }

			  break;
			// Other mouse messages: WM_MOUSEMOVE, WM_MBUTTONDOWN, etc.
		  }
		  break;

	   case WM_MOUSEWHEEL :
			{
				int XCELL = 0;
				int YCELL = 0;
				int xPos = LOWORD(lParam);  // horizontal position of cursor 
				int yPos = HIWORD(lParam);  // vertical position of cursor
				int zDelta = (int) wParam;  // wheel rotation

				XCELL = xPos/DIM_CELLULE;
			    YCELL = yPos/DIM_CELLULE;
				
				int dim_cel = DIM_CELLULE;
				if (zDelta < 0 && DIM_CELLULE > 3)
					dim_cel = DIM_CELLULE-1;
				else
				if (zDelta > 0 && DIM_CELLULE < 80)
					dim_cel = DIM_CELLULE+1;

				if (DIM_CELLULE != dim_cel)
				{
					RECT rect;
					HDC     hDC;
					hDC =GetDC (ghWnd);
					// On efface l'espace de jeu.
					rect.left = 0;
					rect.top = 0;
					rect.right = X_LIBELLE + X_BORD_VIE;  
					rect.bottom = X_LIBELLE + Y_BORD_VIE;
					RedrawWindow (ghWnd,&rect,NULL,RDW_INVALIDATE);
					
					// On redefinie les parametres
					DIM_CELLULE = dim_cel;
					definir_parametres();

					// On redessine l'application aux nouvelles dimensions.
					SetWindowPos(hboutonnour,HWND_BOTTOM,X_LIBELLE+220,103,50,17,SWP_NOSIZE);
					SetWindowPos(hCtrlnour,HWND_BOTTOM,X_LIBELLE+270,103,50,17,SWP_NOSIZE);

					rect.left = 0;
					rect.top = 0;

					rect.right = X_LIBELLE + X_BORD_VIE;  
					rect.bottom = X_LIBELLE + Y_BORD_VIE;
					SetWindowPos(ghWnd,HWND_TOP,rect.left,rect.top,rect.right,rect.bottom,NULL); //SWP_NOMOVE

					rect.left = DIM_CELLULE;
					rect.top = DIM_CELLULE;
					rect.right = DIM_RECTANGLE_X;
					rect.bottom = DIM_RECTANGLE_Y;
					
					Rectangle (hDC,rect.left,rect.top,rect.right,rect.bottom);
					Dessin_obstacle();
					ReleaseDC( ghWnd, hDC );
				}
			}
			break;

	   case WM_COMMAND :
              switch( LOWORD( wParam ) )
              {

				 case IDM_SYSTRAY:
					 {
						ShowWindow( hWnd, SW_HIDE); 
						UpdateWindow( hWnd );
						DestroyWindow(hDlgStat);
					 }
					 break;
					 				 
				 case IDM_WORLD1:
						 {
							Sauvegarde (hFileDonnee);
						 }
					 break;

				 case IDM_WORLD2:
						 {
							Sauvegarde (hFileDonnee);
							Sauvegarde_sur_autre_fichier();
						 }
					 break;
					 
				 case IDM_VERY_SLEEP:
						{
						   CheckMenuRadioItem (hMenuVie,
						   IDM_VERY_SLEEP,
						   IDM_NOSLEEP,
						   IDM_VERY_SLEEP,
						   MF_CHECKED);
                           Flag_Sleep = FALSE;
						   Flag_Very_Sleep = TRUE;
						   Flag_Pause = FALSE;
						   Flag_Moy_Sleep = FALSE;
						   Flag_Mouse = FALSE;
					    }
                        break;
                 case IDM_SLEEP:
						{
						   CheckMenuRadioItem (hMenuVie,
						   IDM_VERY_SLEEP,
						   IDM_NOSLEEP,
						   IDM_SLEEP,
						   MF_CHECKED);
                           Flag_Sleep = TRUE;
						   Flag_Very_Sleep = FALSE;
						   Flag_Moy_Sleep = FALSE;
						   Flag_Pause = FALSE;
						   Flag_Mouse = FALSE;
					    }
                        break;
				 case IDM_SLEEPMOY:
						{
						   CheckMenuRadioItem (hMenuVie,
						   IDM_VERY_SLEEP,
						   IDM_NOSLEEP,
						   IDM_SLEEPMOY,
						   MF_CHECKED);
                           Flag_Sleep = FALSE;
						   Flag_Very_Sleep = FALSE;
						   Flag_Moy_Sleep = TRUE;
						   Flag_Pause = FALSE;
						   Flag_Mouse = FALSE;
					    }
                        break;
				 case IDM_NOSLEEP:
						{
						   CheckMenuRadioItem (hMenuVie,
						   IDM_VERY_SLEEP,
						   IDM_NOSLEEP,
						   IDM_NOSLEEP,
						   MF_CHECKED);
                           Flag_Sleep = FALSE;
						   Flag_Very_Sleep = FALSE;
						   Flag_Moy_Sleep = FALSE;
						   Flag_Pause = FALSE;
						   Flag_Mouse = FALSE;
					    }
                        break;

				 case IDM_TEST:
						{
							Flag_Pause = TRUE;
							if (!hDlgVueCell)
							{
								hDlgVueCell = CreateDialog( hInst,"VUE_CELL", hWnd, (DLGPROC)Vue_Cell );
							}
						}
						break;

				 case IDM_MARQASS:
						{
						   if (bVisu_associer)
						   {
							   	CheckMenuItem (hMenuVie,IDM_MARQASS,MF_UNCHECKED);
								bVisu_associer = false;
						   }
						   else
						   {
								bVisu_associer = true;
								CheckMenuItem (hMenuVie,IDM_MARQASS,MF_CHECKED);
						   }
						}
					    break;

				case IDM_MARQDIS:
						{
						   if (bVisu_distribuer)
						   {
							   	CheckMenuItem (hMenuVie,IDM_MARQDIS,MF_UNCHECKED);
								bVisu_distribuer = false;
						   }
						   else
						   {
								bVisu_distribuer = true;
								CheckMenuItem (hMenuVie,IDM_MARQDIS,MF_CHECKED);
						   }
						}
					    break;
						
				 case IDM_PARAMETRE:
						{
							Flag_Pause = TRUE;
							DialogBox( hInst,"PARAMETRE", hWnd, (DLGPROC)Parametre );
							Flag_Pause = FALSE;
						}
						break;

				 case IDM_RELANCE :
						{
							Flag_Pause = TRUE;
							Relance_automatique(hFileDonnee,hWnd);
							nb_rel_auto++;

							HWND hedit = GetDlgItem(hDlgStat,IDC_NBRELA);
							SetDlgItemInt(hDlgStat,IDC_NBRELA,nb_rel_auto,FALSE);

							Flag_Pause = FALSE;
							Flag_Mouse = FALSE;
						}
						break;

                 case IDM_ABOUT :
						DialogBox( hInst, "ABOUTBOX", hWnd, (DLGPROC)About );
                        break;

				 case IDM_STAT :
						if (!hDlgStat)
						{
							hDlgStat = CreateDialog(hInst,MAKEINTRESOURCE(IDD_VUESTAT),hWnd,(DLGPROC)Stat);
							SetActiveWindow(hWnd);
						}
                        break;

                 case IDM_EXIT :
					    Sauvegarde (hFileDonnee);
                        DestroyWindow( hWnd );
                        break;
              }
              break;
	  case WM_LBUTTONDOWN :
			  if (Flag_Mouse)
			  {
			  	Flag_Mouse =FALSE;
				ReleaseCapture();
				HWND hbutcapt = GetDlgItem(hDlgVueCell,IDCAPTURE);
				SendMessage(hbutcapt,BM_SETSTATE,FALSE,NULL);
				SetDlgItemInt(hDlgVueCell,IDC_NUM_CELL,Capt_cell,FALSE);
				SendMessage (hDlgVueCell,WM_VSCROLL,NULL,(LPARAM)hspinCtrl);

				HWND hedit = GetDlgItem(hDlgVueCell,IDC_CAPTNUM);
				EnableWindow(hedit,false);
				hedit = GetDlgItem(hDlgVueCell,IDC_CAPTPAS);
				EnableWindow(hedit,false);
				hedit = GetDlgItem(hDlgVueCell,IDC_CAPTNOUR);
				EnableWindow(hedit,false);
			  }
			  break;

	  case WM_MOUSEMOVE:
		  {
		  int XCELL,YCELL;
		  HDC     hDC;
		  hDC = GetDC (hWnd);
		  //char tcMess[256];
		  DWORD fwKeys = wParam;      // key flags 
		  int xPos = LOWORD(lParam);  // horizontal position of cursor 
		  int yPos = HIWORD(lParam);  // vertical position of cursor
		  unsigned int uiTemp;
		  HWND hedit;
		  
		  if (Flag_Mouse)
		  {

			  XCELL = xPos/DIM_CELLULE;
			  YCELL = yPos/DIM_CELLULE;
			  if (XCELL <= MAX_X && YCELL <= MAX_Y)
			  {
				hedit = GetDlgItem(hDlgVueCell,IDC_CAPTX);
				SetDlgItemInt(hDlgVueCell,IDC_CAPTX,XCELL,FALSE);
				hedit = GetDlgItem(hDlgVueCell,IDC_CAPTY);
				SetDlgItemInt(hDlgVueCell,IDC_CAPTY,YCELL,FALSE);

				uiTemp = Grille->Don_Grille[XCELL][YCELL].Num_cellule;
				if (uiTemp != 0 && uiTemp != OBSTACLE)
				{
					Capt_cell = uiTemp;
					hedit = GetDlgItem(hDlgVueCell,IDC_CAPTNUM);
					SetDlgItemInt(hDlgVueCell,IDC_CAPTNUM,Capt_cell,FALSE);
					EnableWindow(hedit,true);
					hedit = GetDlgItem(hDlgVueCell,IDC_CAPTPAS);
					SetDlgItemInt(hDlgVueCell,IDC_CAPTPAS,Tab_Cellule->Cellule[Capt_cell].PointDeVie,FALSE);
					EnableWindow(hedit,true);
					hedit = GetDlgItem(hDlgVueCell,IDC_CAPTNOUR);
					SetDlgItemInt(hDlgVueCell,IDC_CAPTNOUR,Tab_Cellule->Cellule[Capt_cell].Nourriture,FALSE);
					EnableWindow(hedit,true);

				}
				else
				{
					hedit = GetDlgItem(hDlgVueCell,IDC_CAPTNUM);
					EnableWindow(hedit,false);
					hedit = GetDlgItem(hDlgVueCell,IDC_CAPTPAS);
					EnableWindow(hedit,false);
					hedit = GetDlgItem(hDlgVueCell,IDC_CAPTNOUR);
					EnableWindow(hedit,false);
				}

				hedit = GetDlgItem(hDlgVueCell,IDC_CAPTCASE);
				SetDlgItemInt(hDlgVueCell,IDC_CAPTCASE,Grille->Don_Grille[XCELL][YCELL].Nb_Nourriture,FALSE);
			  }
		  }
		  ReleaseDC(hWnd,hDC);
		  }
		  break;

	  case WM_TIMER :
		  switch (wParam)
		  {
		  case TIMER_SAUV :
			  Sauvegarde(hFileDonnee);
			  break;
		  case MY_TIMER :
				{
			  		HDC     hDC;
					int i,cumulage = 0;

					hDC =GetDC (hWnd);

					// On efface l'espace de jeu. 
					Rectangle (hDC,DIM_CELLULE,DIM_CELLULE,DIM_RECTANGLE_X,DIM_RECTANGLE_Y);
					nb_viv = 0;

					Dessiner_obstacles(hDC);

					memset (&TableCompression,0x00,sizeof(sTableCompression));

					if (bVisu_associer)
					{
						Dessiner_zone_associe (hDC,X_MOVE,Y_MOVE);
					}

					for (i=1;i<MAX_CELL+1;i++)
					{
						if (!Tab_Cellule->Cellule[i].Mort)
						{
							
							Dessiner_cellule (hDC,x_plus(Tab_Cellule->Cellule[i].Coord.x_coord,X_MOVE),
												  y_plus(Tab_Cellule->Cellule[i].Coord.y_coord,Y_MOVE));

							// Calcul nombre de cellule vivante.
							nb_viv++;

							// Cumul des ages pour calcul age moyen des cellules.
							cumulage += Tab_Cellule->Cellule[i].PointDeVie;

							//Valoriser_bit(i);
						}
					}

					Remplir_Cellule_Sel (hDC,x_plus(Tab_Cellule->Cellule[Capt_cell].Coord.x_coord,X_MOVE),
											 y_plus(Tab_Cellule->Cellule[Capt_cell].Coord.y_coord,Y_MOVE));

					Controle_Nourriture();

					// Envoi des Stats.
					if (hDlgStat)
					{
						SetDlgItemInt(hDlgStat,IDC_NBVIV,nb_viv,FALSE);
						if (nb_viv > 0)
							SetDlgItemInt(hDlgStat,IDC_AGEMOY,(int)(cumulage/nb_viv),FALSE);
					}
					
					ReleaseDC( hWnd, hDC );
				}
			  break;
			
		  }
		  break;
	  
/*      case WM_PAINT :
		  {
			HDC hdc;
			int i;
			BeginPaint( hWnd, &ps );
			hdc = GetDC( hWnd );
			for (i=1;i<MAX_CELL+1;i++)
			{
				if (!Tab_Cellule->Cellule[i].Mort)
					Dessiner_cellule (hdc,
					Tab_Cellule->Cellule[i].Coord.x_coord,
					Tab_Cellule->Cellule[i].Coord.y_coord);
			}
			ReleaseDC( hWnd, hdc );
			EndPaint( hWnd, &ps );
		  }
          break;*/

		case WM_KEYDOWN:
			switch( wParam )
			{
				case VK_DOWN:
					{
						if (Y_MOVE < MAX_Y)
							Y_MOVE++;
						else
							Y_MOVE=0;
					}
					break;

				case VK_LEFT:
					{
						if (X_MOVE > 0)
							X_MOVE--;
						else
							X_MOVE=MAX_X;
					}
					break;

				case VK_RIGHT:
					{
						if (X_MOVE < MAX_X)
							X_MOVE++;
						else
							X_MOVE=0;
					}
					break;

				case VK_UP:
					{
						if (Y_MOVE > 0)
							Y_MOVE--;
						else
							Y_MOVE = MAX_Y;
					}
					break;

				case VK_CONTROL:
					{
						Y_MOVE=0;
						X_MOVE=0;
					}
					break;
			}
			break;

      case WM_DESTROY :
			{
				FlagExitThread = TRUE;
				delete_systray(hWnd);
				DWORD Result = STILL_ACTIVE;
				GetExitCodeThread(hThreadCalcul,&Result);
				while (Result == STILL_ACTIVE)
				{
					GetExitCodeThread(hThreadCalcul,&Result);
				}
				PostQuitMessage(0);
			}
			break;

      default :
		  return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
   }

   return( 0L );
}

//************************************************
// Boucle des messages Fenetre About.
//************************************************
LRESULT CALLBACK About( HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   switch (message) 
   {
       case WM_INITDIALOG: 
               return (TRUE);

       case WM_COMMAND:                              
               if (   LOWORD(wParam) == IDOK         
                   || LOWORD(wParam) == IDCANCEL)    
               {
                       EndDialog(hDlg, TRUE);        
                       return (TRUE);
               }
               break;
   }

   return (FALSE); 
}

//************************************************
// Boucle des messages Fenetre Statistiques.
//************************************************
LRESULT CALLBACK Stat(  HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   switch (message) 
   {
       case WM_INITDIALOG:
		   {
			SetDlgItemText(hDlg,IDC_DERSAUV,tcSauv);
			HWND hspin =  GetDlgItem(hDlg,IDC_SPINNOUR);
			SendMessage (hspin,UDM_SETRANGE,0,(LPARAM) MAKELONG((short) MAX_NOURRI, (short) 1));
			SendMessage (hspin,UDM_SETPOS,0,(LPARAM) MAKELONG((short) NOURRI_AUTO, 0));
		    SetWindowPos(hDlg,HWND_TOP,X_LIBELLE + X_BORD_VIE,Y_BORD_DIAL,NULL,NULL,SWP_NOSIZE);
		   }
			break;

	   case WM_VSCROLL:
			   {
					   BOOL bTran;
					   NOURRI_AUTO = GetDlgItemInt(hDlg,IDC_NOURDIS,&bTran,FALSE);
					   break;
			   }
			   break;

	   case WM_KEYDOWN:
			switch( wParam )
			{
				case VK_RETURN:
					{
						   BOOL bTran;
						   int a = GetDlgItemInt(hDlg,IDC_NOURDIS,&bTran,FALSE);
						   if (a != 0)
								NOURRI_AUTO = a;
					}
 					break;
			}
			break;


       case WM_COMMAND:
		       switch(   LOWORD(wParam))
			   {
				   case IDCANCEL:
				   case IDOK:
					   DestroyWindow(hDlg);        
					   break;
				   
				   case IDC_SAIOK:
					   {
						   BOOL bTran;
						   int a = GetDlgItemInt(hDlg,IDC_NOURDIS,&bTran,FALSE);
						   if (a != 0)
								NOURRI_AUTO = a;
					   }
					   break;
			   }
			   break;

	   case WM_DESTROY:
			hDlgStat = NULL;
			break;

	   default :
			return FALSE;
   }

   return (TRUE); 
}


//************************************************
// Boucle des messages Fenetre Statistiques.
//************************************************
LRESULT CALLBACK Sauvproc ( HWND hDlg,           
							UINT message,        
							WPARAM wParam,       
							LPARAM lParam)
{
   static char tbuffer[20];

   switch (message) 
   {
		 case WM_INITDIALOG: 
		   {

			   DWORD cb;       // size of file and count of bytes read 

			   _strtime( tbuffer );
			   wsprintf(tcSauv,"Sauvegarde effectue  %s ",tbuffer);
			   SetDlgItemText(hDlg,IDC_TIME,tcSauv);

			   hwndPB = GetDlgItem(hDlg,IDC_BARSAUV);

			   cb = sizeof (sTab_Cellule_disque); 
			   // Set the range and increment of the progress bar. 
			   SendMessage(hwndPB, PBM_SETRANGE, 0, MAKELPARAM(0, cb / sizeof(sCellule_disque))); 
			   SendMessage(hwndPB, PBM_SETSTEP, (WPARAM) 1, 0); 

		   	   SetWindowPos(hDlg,HWND_TOP,X_LIBELLE + X_BORD_VIE,Y_BORD_DIAL,NULL,NULL,SWP_NOSIZE); 
		   }
		   break;

		case WM_DESTROY:
		 {
		   _strtime( tbuffer );
		   wsprintf(tcSauv,"Dernire sauvegarde effectue  %s ",tbuffer);
		   SetDlgItemText(hDlgStat,IDC_DERSAUV,tcSauv);
		   hDlg = NULL;
		 }
		 break;

		default :
		 return FALSE;
   }
   return TRUE; 
}

//************************************************
// Boucle des messages Fenetre Vue_Cell.
//************************************************
LRESULT CALLBACK Vue_Cell( HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   static int Num_cell = 1;
   static bool bSauv = false;
   static bool bdetail = false;
   static HWND hbutcapt;

   switch (message) 
   {
       case WM_INITDIALOG:
		   {
			   bSauv = false;
			   Num_cell = Capt_cell;
			   HWND hEdit = GetDlgItem(hDlg,IDC_NUM_CELL);
			   hspinCtrl = CreateUpDownControl(WS_CHILD | WS_VISIBLE | SS_RIGHT
				,170,11,179,23,hDlg,IDC_SPIN3,hInst,hEdit, 
				MAX_CELL,1,Num_cell);
			   SetDlgItemInt(hDlg,IDC_STOCK_NOUR,Tab_Cellule->Cellule[Num_cell].Nourriture,FALSE);
               SendMessage (hDlg,WM_VSCROLL,NULL,(LPARAM)hspinCtrl);

  			   SetWindowPos(hDlg,HWND_TOP,X_LIBELLE + X_BORD_VIE,Y_BORD_DIAL,200,TAIL_VUECELL,SWP_SHOWWINDOW);

			   break;
		   }

       case WM_COMMAND:                              
               switch(   LOWORD(wParam))
			   {
			   case IDCANCEL:
			   case IDOK:
				   if (bSauv)
				   {
						Dessin_obstacle();
						Restitution(hFileDonnee);
						Init_grille();
				   }
				   Flag_Mouse =FALSE;
                   DestroyWindow(hDlg);        
                   break;
			   case IDC_PASAPAS:
				   Calcul_action ();
		           Nourriture_alea_alim ();
				   SendMessage(hDlg,WM_VSCROLL,NULL,1);
				   break;
			   case IDSAUV:
				   if (!bSauv)
				   {
					   bSauv = true;
					   Sauvegarde(hFileDonnee);
					   Flag_Pause = TRUE;
					   test_cellule(Num_cell,ghWnd);
				   }
				   break;
			   case IDC_NUM_CELL:
				   SendMessage(hDlg,WM_VSCROLL,NULL,1);
				   break;
			   case IDCAPTURE:
				   Flag_Mouse = true;
				   hbutcapt = GetDlgItem(hDlg,IDCAPTURE);
				   SendMessage(hbutcapt,BM_SETSTATE,TRUE,NULL);
				   SetCapture(ghWnd);
				   break;
			   case IDCAPTVIEI:
				   {
				   	int i;
					unsigned int max_vie = 0;
					int ind_best = 0;
					for (i=1;i<MAX_CELL+1;i++)
					{
						if (!Tab_Cellule->Cellule[i].Mort)
						{
							if (Tab_Cellule->Cellule[i].PointDeVie > max_vie)
							{
								max_vie = Tab_Cellule->Cellule[i].PointDeVie;
								ind_best = i;
							}
						}
					}
					SetDlgItemInt(hDlg,IDC_NUM_CELL,ind_best,FALSE);
				   }
				   break;

			   case IDCAPTRICH:
				   {
					int i;
					int max_nour = 0;
					int ind_best = 0;
					for (i=1;i<MAX_CELL+1;i++)
					{
						if (!Tab_Cellule->Cellule[i].Mort)
						{
							if (Tab_Cellule->Cellule[i].Nourriture > max_nour)
							{
								max_nour = Tab_Cellule->Cellule[i].Nourriture;
								ind_best = i;
							}
						}
					}
					SetDlgItemInt(hDlg,IDC_NUM_CELL,ind_best,FALSE);
				   }
				   break;

			   case IDCAPTDEFE:
				   {
				   	int i;
					int max_def = 0;
					int ind_best = 0;
					for (i=1;i<MAX_CELL+1;i++)
					{
						if (!Tab_Cellule->Cellule[i].Mort)
						{
							if (Tab_Cellule->Cellule[i].Defense > max_def)
							{
								max_def = Tab_Cellule->Cellule[i].Defense;
								ind_best = i;
							}
						}
					}
					SetDlgItemInt(hDlg,IDC_NUM_CELL,ind_best,FALSE);
				   }
				   break;

			   case IDDETAIL:
				   if (!bdetail)
				   {
					   HWND hListBox = GetDlgItem(hDlg,IDC_ENTREE);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_SORTIE);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_STATICIN);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_STATICOUT);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_STATICINTER);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_INTER);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_STATICPOIDS);
					   ShowWindow( hListBox, SW_SHOWNORMAL);
					   hListBox = GetDlgItem(hDlg,IDC_VPOIDS);
					   ShowWindow( hListBox, SW_SHOWNORMAL);

					   SendMessage (hDlg,WM_VSCROLL,NULL,(LPARAM)hspinCtrl);
						
					   RECT rect;
					   GetWindowRect(hDlg,&rect);
					   SetWindowPos(hDlg,HWND_TOP,rect.left,rect.top,900,TAIL_VUECELL,NULL);

					   SetDlgItemText(hDlg,IDDETAIL,"Pas de dtails <<");

					   bdetail = true;

					   SendMessage(hDlg,WM_VSCROLL,NULL,1);
				   }
				   else
				   {
					   HWND hListBox = GetDlgItem(hDlg,IDC_ENTREE);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_SORTIE);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_STATICIN);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_STATICOUT);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_STATICINTER);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_INTER);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_STATICPOIDS);
					   ShowWindow( hListBox, SW_HIDE);
					   hListBox = GetDlgItem(hDlg,IDC_VPOIDS);
					   ShowWindow( hListBox, SW_HIDE);

					   RECT rect;
					   GetWindowRect(hDlg,&rect);
					   SetWindowPos(hDlg,HWND_TOP,rect.left,rect.top,200,TAIL_VUECELL,SWP_NOMOVE);

					   SetDlgItemText(hDlg,IDDETAIL,"Dtails >>");

					   bdetail = false;
				   }
				   break;
				   
			   }
               break;
		case WM_VSCROLL:
			   {
				    int i,j,deb;
					HWND hwndScrollBar;
					hwndScrollBar = (HWND) lParam; 
				    if (lParam == 1 || GetDlgCtrlID(hwndScrollBar)==IDC_SPIN3)
					{
						BOOL bTran;
						Num_cell = GetDlgItemInt(hDlg,IDC_NUM_CELL,&bTran,FALSE);
						// Stock nourriture. 
						SetDlgItemInt(hDlg,IDC_STOCK_NOUR,Tab_Cellule->Cellule[Num_cell].Nourriture,FALSE);
						// Etat. 
						if (Tab_Cellule->Cellule[Num_cell].Mort)
							strcpy (szMsg,"Mort");
						else
							strcpy (szMsg,"Vivant");
						SetDlgItemText(hDlg,IDC_ETAT,szMsg);
						// Nombre de points de defenses. 
						SetDlgItemInt(hDlg,IDC_DEFENSE,Tab_Cellule->Cellule[Num_cell].Defense,FALSE);
						// Coordonnes x de la cellule.
						SetDlgItemInt(hDlg,IDC_COORD_X,Tab_Cellule->Cellule[Num_cell].Coord.x_coord,FALSE);
						// Coordonnes y de la cellule.
						SetDlgItemInt(hDlg,IDC_COORD_Y,Tab_Cellule->Cellule[Num_cell].Coord.y_coord,FALSE);
						// Nombre de points de vie de la cellule.
						SetDlgItemInt(hDlg,IDC_PAS,Tab_Cellule->Cellule[Num_cell].PointDeVie,FALSE);

						HWND hListBox_entree = GetDlgItem(hDlg,IDC_ENTREE);
						SendMessage(hListBox_entree,LB_RESETCONTENT,0,0);
						HWND hListBox_sortie = GetDlgItem(hDlg,IDC_SORTIE);
						SendMessage(hListBox_sortie,LB_RESETCONTENT,0,0);
						HWND hListBox_inter = GetDlgItem(hDlg,IDC_INTER);
						SendMessage(hListBox_inter,LB_RESETCONTENT,0,0);
						HWND hListBox_poids = GetDlgItem(hDlg,IDC_VPOIDS);
						SendMessage(hListBox_poids,LB_RESETCONTENT,0,0);


						if (bdetail)
						{

							for (i=1;i<NB_NEUR_ENTREE+1;i++)
							{
								sprintf (szMsg,"Neurone %.2d : %+.2f",i,agent[Num_cell]->tab_neuronnes[i-1]);
								SendMessage(hListBox_entree,LB_ADDSTRING,0,(LONG)szMsg);
							}

							for (i=1;i<NB_NEUR_SORTIE+1;i++)
							{
								sprintf (szMsg,"Neurone %.2d : %+.10f",i,agent[Num_cell]->tab_neuronnes[IND_NEUR_SORTIE+i-1]);
								SendMessage(hListBox_sortie,LB_ADDSTRING,0,(LONG)szMsg);
							}

							SendMessage(hListBox_sortie,LB_ADDSTRING,0,(LONG)"");
							int code_action = calcul_decision_agent(&agent[Num_cell]->tab_neuronnes[IND_NEUR_SORTIE]);
							char strlib[20];
							memset (szMsg,0,sizeof(strlib));
							Lib_action(code_action,strlib);
							sprintf (szMsg,"Code action = %s",strlib);
							SendMessage(hListBox_sortie,LB_ADDSTRING,0,(LONG)szMsg);
							if (code_action == eDeplacer)
							{
								int code_direction = calcul_direction(&agent[Num_cell]->tab_neuronnes[IND_NEUR_SORTIE_DIR]);
								memset (szMsg,0,sizeof(strlib));
								Lib_direction(code_direction,strlib);
								sprintf (szMsg,"Code direction = %s",strlib);
								SendMessage(hListBox_sortie,LB_ADDSTRING,0,(LONG)szMsg);
							}

							for (j=1;j<NB_COUCHES-1;j++)
							{
								sprintf (szMsg,"Couche %.2d ",j);
								SendMessage(hListBox_inter,LB_ADDSTRING,0,(LONG)szMsg);

								deb = NB_NEUR_COUCH*(j-1);
								for (i=deb+1;i<NB_NEUR_COUCH+deb+1;i++)
								{
									sprintf (szMsg,"Neurone %.2d : %+.2f",i-deb,agent[Num_cell]->tab_neuronnes[NB_NEUR_ENTREE+i-1]);
									SendMessage(hListBox_inter,LB_ADDSTRING,0,(LONG)szMsg);
								}
								SendMessage(hListBox_inter,LB_ADDSTRING,0,(LONG)"");
							}

							for (i=1;i<NB_POIDS+1;i++)
							{
								sprintf (szMsg,"Poids %.2d : %+.10f",i,agent[Num_cell]->tab_poids[i-1]);
								SendMessage(hListBox_poids,LB_ADDSTRING,0,(LONG)szMsg);
							}
						}

						if (!Tab_Cellule->Cellule[Num_cell].Mort)
							Capt_cell = Num_cell;
					}


					break;
			   }
			   break;

		 case WM_DESTROY:
			 {
				hDlgVueCell = NULL;
				Flag_Pause = FALSE;
			 }
			 break;

		 default :
			 return FALSE;
   }
   return TRUE; 
}

//************************************************
// Boucle des messages Fenetre Parametre.
//************************************************
LRESULT CALLBACK Parametre( HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   static int dim_cel;
   switch (message) 
   {
       case WM_INITDIALOG:
		   SetDlgItemInt(hDlg,IDC_PARAM1,DIM_CELLULE,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM2,COUT_POUR_DEPLACER,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM3,COUT_POUR_MANGER,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM4,COUT_POUR_CREER,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM5,COUT_POUR_ASSOCIER,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM7,COUT_POUR_DISTRIBUER,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM9,MUTATION,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAM10,MUTATION_POIDS,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAMDEFDIS,DISTRIB_DEFENSE,FALSE);
		   SetDlgItemInt(hDlg,IDC_PARAMDEFASS,ASSOCIE_DEFENSE,FALSE);
		   SetDlgItemInt(hDlg,IDC_BONUSASS,INC_BONUS_ASSOCIER,FALSE);
		   SetDlgItemInt(hDlg,IDC_BONUSASS2,INC_BONUS_ASSOCIER_SPECIAL,FALSE);
		   SetDlgItemInt(hDlg,IDC_NOURMILI,NOURRI_CENTRE,FALSE);
           return (TRUE);

       case WM_COMMAND:                              
		   switch(   LOWORD(wParam))
		   {
		   case IDOK:
			   	BOOL bTran;
				int param;

				// On recupere la nouvelle dimension d'un cellule
				dim_cel = GetDlgItemInt(hDlg,IDC_PARAM1,&bTran,FALSE);

				if (DIM_CELLULE != dim_cel && dim_cel > 0 && dim_cel < 80)
				{
					RECT rect;
					HDC     hDC;
					hDC =GetDC (ghWnd);
					// On efface l'espace de jeu. 
					rect.left = 0;
					rect.top = 0;
					rect.right = X_LIBELLE + X_BORD_VIE;  
					rect.bottom = X_LIBELLE + Y_BORD_VIE;
					RedrawWindow (ghWnd,&rect,NULL,RDW_INVALIDATE);

					// On redefinie les parametres
					DIM_CELLULE = dim_cel;
					definir_parametres();

					// On redessine l'application aux nouvelles dimensions.
					SetWindowPos(hboutonnour,HWND_BOTTOM,X_LIBELLE+220,103,50,17,SWP_NOSIZE);
					SetWindowPos(hCtrlnour,HWND_BOTTOM,X_LIBELLE+270,103,50,17,SWP_NOSIZE);
					rect.left = 0;
					rect.top = 0;
					rect.right = X_LIBELLE + X_BORD_VIE;  
					rect.bottom = X_LIBELLE + Y_BORD_VIE;
					SetWindowPos(ghWnd,HWND_BOTTOM,rect.left,rect.top,rect.right,rect.bottom,SWP_NOMOVE);

					rect.left = DIM_CELLULE;
					rect.top = DIM_CELLULE;
					rect.right = DIM_RECTANGLE_X;
					rect.bottom = DIM_RECTANGLE_Y;
					
					Rectangle (hDC,rect.left,rect.top,rect.right,rect.bottom);
					Dessin_obstacle();
					ReleaseDC( ghWnd, hDC );
				}

				param = GetDlgItemInt(hDlg,IDC_PARAM2,&bTran,FALSE);
				if (param != COUT_POUR_DEPLACER && param < 100)
				{
					COUT_POUR_DEPLACER = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAM3,&bTran,FALSE);
				if (param != COUT_POUR_MANGER && param < 100)
				{
					COUT_POUR_MANGER = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAM4,&bTran,FALSE);
				if (param != COUT_POUR_CREER && param < 100)
				{
					COUT_POUR_CREER = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAM5,&bTran,FALSE);
				if (param != COUT_POUR_ASSOCIER && param < 100)
				{
					COUT_POUR_ASSOCIER = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAM7,&bTran,FALSE);
				if (param != COUT_POUR_DISTRIBUER && param < 100)
				{
					COUT_POUR_DISTRIBUER = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAMDEFDIS,&bTran,FALSE);
				if (param != DISTRIB_DEFENSE && param >= 0)
				{
					DISTRIB_DEFENSE = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAMDEFASS,&bTran,FALSE);
				if (param != ASSOCIE_DEFENSE && param >= 0)
				{
					ASSOCIE_DEFENSE = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAM9,&bTran,FALSE);
				if (param != MUTATION && param > 0)
				{
					MUTATION = param;
				}
				param = GetDlgItemInt(hDlg,IDC_PARAM10,&bTran,FALSE);
				if (param != MUTATION_POIDS && param > 0)
				{
					MUTATION_POIDS = param;
				}
				param = GetDlgItemInt(hDlg,IDC_BONUSASS,&bTran,FALSE);
				if (param != INC_BONUS_ASSOCIER && param >= 0)
				{
					INC_BONUS_ASSOCIER = param;
				}
				param = GetDlgItemInt(hDlg,IDC_BONUSASS2,&bTran,FALSE);
				if (param != INC_BONUS_ASSOCIER_SPECIAL && param >= 0)
				{
					INC_BONUS_ASSOCIER_SPECIAL = param;
				}
				param = GetDlgItemInt(hDlg,IDC_NOURMILI,&bTran,FALSE);
				if (param != NOURRI_CENTRE && param >= 0)
				{
					NOURRI_CENTRE = param;
				}

				EndDialog(hDlg, TRUE);        
				return (TRUE);
				break;
		   case IDCANCEL:
			   EndDialog(hDlg, TRUE);        
			   return (TRUE);
		   }
		   break;
	}

   return (FALSE); 
}

//************************************************
// Dessin en mmoire des obstacles.
//************************************************
VOID Dessin_obstacle (void)
{
	nb_obstable = 0;

	Dessiner_colonne (nb_obstable+1,1,22,34);

	Dessiner_ligne (nb_obstable+1,34,1,20);

	Dessiner_ligne (nb_obstable+1,34,24,53);

	Dessiner_colonne (nb_obstable+1,49,12,33);

	Dessiner_ligne (nb_obstable+1,8,1,13);

	Dessiner_colonne (nb_obstable+1,16,1,6);

	Dessiner_colonne (nb_obstable+1,41,1,13);

	Dessiner_colonne (nb_obstable+1,8,52,63);

	Dessiner_ligne (nb_obstable+1,50,52,74);

	Dessiner_colonne (nb_obstable+1,38,44,66);

	Dessiner_ligne (nb_obstable+1,71,10,30);

	Dessiner_ligne (nb_obstable+1,73,70,76);

	Dessiner_colonne (nb_obstable+1,78,10,83);
}

//************************************************
// Dessin des colonnes.
//************************************************
VOID Dessiner_colonne (int num,int col,int lig1,int lig2)
{
	int i;

	SetRect (&obs_rect_virtuel[num],col,lig1,col+1,lig2+1);
	SetRect (&obs_rect[num],DIM_CELLULE*col,DIM_CELLULE*lig1,DIM_CELLULE*(col+1),DIM_CELLULE*(lig2+1));
	for (i=lig1;i<=lig2;i++)
	{
		Grille->Don_Grille[col][i].Num_cellule = OBSTACLE;
		Grille->Don_Grille[col][i].Nb_Nourriture = MAX_NOURRI;
	}
	nb_obstable++;
}

//************************************************
// Dessin des lignes.
//************************************************
VOID Dessiner_ligne (int num,int lig,int col1,int col2)
{
	int i;

	SetRect (&obs_rect_virtuel[num],col1,lig,col2+1,lig+1);
	SetRect (&obs_rect[num],DIM_CELLULE*col1,DIM_CELLULE*lig,DIM_CELLULE*(col2+1),DIM_CELLULE*(lig+1));
	for (i=col1;i<=col2;i++)
	{
		Grille->Don_Grille[i][lig].Num_cellule = OBSTACLE;
		Grille->Don_Grille[i][lig].Nb_Nourriture = MAX_NOURRI;
	}
	
	nb_obstable++;
}

//************************************************
// Dessin des obstacles.
//************************************************
VOID Dessiner_obstacles(HDC hdc)
{
	int i,x,y,x0,y0;

	if (X_MOVE ==0 && Y_MOVE == 0)
	{
		for (i=1;i<=nb_obstable;i++)
		{
			FillRect (hdc,&obs_rect[i],(HBRUSH)obs_brush);
		}
	}
	else
	{
		RECT lrect;

		for (x=1;x<=MAX_X;x++)
		{
			for (y=1;y<=MAX_Y;y++)
			{
				if (Grille->Don_Grille[x][y].Num_cellule == OBSTACLE)
				{
					x0 = x_plus(x,X_MOVE);
					y0 = y_plus(y,Y_MOVE);
					lrect.bottom = y0*DIM_CELLULE;
					lrect.left = x0*DIM_CELLULE;
					lrect.right = lrect.left+DIM_CELLULE;
					lrect.top = lrect.bottom+DIM_CELLULE;
					FillRect (hdc,&lrect,(HBRUSH)obs_brush);
				}
			}
		}
	}
}

//************************************************
// Ajouter l'icone dans la barre 'status area'.
//************************************************
void add_systray (HWND hWnd, HICON hIcon)
{   
   NOTIFYICONDATA nid;
   nid.cbSize = sizeof(NOTIFYICONDATA);
   nid.hWnd = hWnd;
   nid.hIcon = hIcon;
   strcpy(nid.szTip,"Vie Artificielle");
   nid.uCallbackMessage = UWM_SYSTRAY;	// message sent to nid.hWnd
   nid.uID = 1;							// application-defined ID for icon (can be any UINT value)
   nid.uFlags = NIF_MESSAGE |			// nid.uCallbackMessage is valid, use it
                NIF_ICON |				// nid.hIcon is valid, use it
                NIF_TIP;				// nid.szTip is valid, use it
   Shell_NotifyIcon(NIM_ADD,&nid);
}

//************************************************
// Supprimer l'icone dans la barre 'status area'.
//************************************************
void delete_systray(HWND hWnd)
{
	NOTIFYICONDATA nid;

	nid.cbSize = sizeof(NOTIFYICONDATA);
	nid.hWnd = hWnd;
	nid.uID = 1;
	nid.uFlags = NIF_TIP; // not really sure what to put here, but it works
	Shell_NotifyIcon(NIM_DELETE, &nid); // This removes the icon
}
