//*****************************************************************************
//* Serveur TCP pour envoyer  une applet JAVA la position des cellules.
//* L'applet sera charge d'afficher ce que le serveur lui envoie.
//******************************************************************************

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>
#include "Vie_Agent.h"
#include "outils.h"
#include "calcul.h"

extern BOOL FlagExitThread;					// Pour sortir du Thread.
extern sTableCompression TableCompression;	// Compression de la grille afin
											//de l'envoyer  l'applet Java. 

// Variables globales communes au serveur et  ThreadApplet. 
SOCKET msgsock;
char Buffer[14];
char stderr [128];
int port_client; // port du client qui vient de se connecter.

BOOL serveur(HWND hWnd)
{
	DWORD dwid; // Identifiant Thread.
	char *interface= NULL;
	unsigned short port=DEFAULT_PORT;
	int fromlen;
	int socket_type = DEFAULT_PROTO;
	struct sockaddr_in local, from;
	WSADATA wsaData;
	SOCKET listen_socket;
	HDC     hDC;
	
	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR)
	{
		wsprintf(stderr,"Erreur WSAStartup. Erreur = %d\n",WSAGetLastError());
		MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK | MB_ICONINFORMATION);
		WSACleanup();
		return FALSE;
	}
	
	local.sin_family = AF_INET;
	local.sin_addr.s_addr = (!interface)?INADDR_ANY:inet_addr(interface); 

	/* 
	 * Port MUST be in Network Byte Order
	 */
	local.sin_port = htons(port);

	listen_socket = socket(AF_INET, socket_type,0); // TCP socket
	
	if (listen_socket == INVALID_SOCKET)
	{
		wsprintf(stderr,"Erreur lors de la cration de la socket(). Erreur = %d\n",WSAGetLastError());
		MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK | MB_ICONINFORMATION);
		WSACleanup();
		return FALSE;
	}
	
	// bind() relie une adresse locale, un port avec la socket juste cree.
	
	if (bind(listen_socket,(struct sockaddr*)&local,sizeof(local) ) 
		== SOCKET_ERROR)
	{
		wsprintf(stderr,"Erreur sur bind(). Erreur = %d\n",WSAGetLastError());
		MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK | MB_ICONINFORMATION);
		WSACleanup();
		return FALSE;
	}

	// La fonction Listen de Windows Sockets place une socket
	//  l'tat d'coute d'une ventuelle connexion.
	// SOMAXCONN est le nombre de connexion que le serveur peut accepter. 
	// En l'occurence dans ce prog, nous avons choisi le maximum.

	if (listen(listen_socket,SOMAXCONN) == SOCKET_ERROR)
	{
		wsprintf(stderr,"Erreur sur listen() Erreur = %d\n",WSAGetLastError());
		MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK | MB_ICONINFORMATION);
		WSACleanup();
		return FALSE;
	}

	hDC = GetDC( hWnd );
	wsprintf(stderr,"On coute le port %d, avec le protocole TCP. ",DEFAULT_PORT);
	TextOut(hDC,410,300,stderr,strlen(stderr));
	ReleaseDC( hWnd, hDC );
	//MessageBox (hWnd,stderr,"Info Serveur TCP",MB_OK);

	while(!FlagExitThread)
	{
		fromlen =sizeof(from);
		//
		// accept() s'excute aprs un listen(). Uniquement en connexion TCP.
		//
		msgsock = accept(listen_socket,(struct sockaddr*)&from, &fromlen);
		if (msgsock == INVALID_SOCKET)
		{
			wsprintf(stderr,"Erreur sur accept() = %d\n",WSAGetLastError());
			MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK | MB_ICONINFORMATION);
			WSACleanup();
			return FALSE;
		}

		hDC = GetDC( hWnd );
		port_client = from.sin_port;
		wsprintf(stderr,"Un client s'est connect sur le port %d. ",from.sin_port);
		TextOut(hDC,410,320,stderr,strlen(stderr));
		ReleaseDC( hWnd, hDC );

		// Creation du thread d'envoi d'info  l'applet. 
		CreateThread (NULL,1024,(LPTHREAD_START_ROUTINE)ThreadApplet,(LPVOID)hWnd,0,&dwid);
		
	}
	return (TRUE);
}

DWORD WINAPI ThreadApplet (HWND hWnd)
{
	int retval;
	SOCKET sockthread;
	HDC     hDC;

	sockthread = msgsock;

	while (1)
	{
		retval = recv(sockthread,Buffer,13,0 );

		if (retval == SOCKET_ERROR)
		{
			retval = WSAGetLastError();
			if (retval == WSAECONNRESET || retval == WSAENOTSOCK || retval == WSAESHUTDOWN)
			{
				hDC = GetDC( hWnd );
				wsprintf(stderr,"Le client a ferm la connexion.      \n");
				TextOut(hDC,410,340,stderr,strlen(stderr));
				ReleaseDC( hWnd, hDC );
				closesocket(sockthread);
				break;
			}
			else
			{
				wsprintf(stderr,"Erreur recv() : erreur = %d\n",retval);
				MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK);
				closesocket(sockthread);
				break;
			}
		}
		
		if (retval == 0)
		{
			hDC = GetDC( hWnd );
			wsprintf(stderr,"Le client a ferm la connexion.      \n");
			TextOut(hDC,410,340,stderr,strlen(stderr));
			ReleaseDC( hWnd, hDC );
			closesocket(sockthread);
			break;
		}

		if (strncmp(Buffer,"Applet manu01",13) != 0)
		{
			hDC = GetDC( hWnd );
			wsprintf(stderr,"Le client n'est pas une Applet Manu01.\n");
			TextOut(hDC,410,340,stderr,strlen(stderr));
			ReleaseDC( hWnd, hDC );
			closesocket(sockthread);
			continue;
		}

		wsprintf (stderr,"Ligne reue : %13s.\n",Buffer);
		OutputDebugString(stderr);

		retval = send(sockthread,(const char *)&TableCompression,sizeof(sTableCompression),0);
		
		if (retval == SOCKET_ERROR)
		{
			wsprintf(stderr,"Erreur sur send(): Erreur = %d\n",WSAGetLastError());
			MessageBox (hWnd,stderr,"Erreur sur Serveur TCP",MB_OK);
			closesocket(sockthread);
			break;
		}
	}
	
	closesocket(sockthread);

	ExitThread(0);

	return (TRUE);
}