//*********************************
// Class  : Agent
// Author : Emmnauel Chauvin
// Date   : 11/06/2001
//*********************************

class Agent  
{
public :
	// Methodes
	// Constructeur.
	// Initialisation du rseau + allocation mmoire.
	Agent(int first, ... );

	// Destructeur + libration mmoire. 
	~Agent();

	// Libebation mmoire.
	bool libe_memoire();

	// Initialisation des poids.
	bool init_poids();											// init avec valeurs alatoires.
	bool init_poids(float * tab_poids_ref);						// en fournissant le tableau des valeurs.
	bool init_poids(float poids,int ind);						// une valeur du tableau des poids.

	// Rcupration et lecture des poids.
	bool lect_poids(float * tab_poids_ref);						// Lecture de la table des poids. 
	bool lect_poids(float * ptpoids,int ind);					// Lecture d'un poids particulier.

	// Initialisation et lecture des neuronnes.
	bool init_neuronnes();										// init des neuronnes en entre.
	bool lect_neuronnes(float * );								// lect des neuronnes sur la couche de sortie.
	bool lect_neuronnes(float * , int);							// lect des neuronnes sur la couche dsire.

	// Propagation du signal  travers le rseau.
	bool propagation();

	float Alea_poids();		// Gnration de poids alatoirement.


public:
	// Attributs
	float RAND_MAX_DEMI;
	int   nb_couches;		// nombre de couches de neuronnes.
	int   nb_poids;			// nombre de poids total.
	int   nb_neuronnes;		// nombre de neuronne total.

	int   * tab_nbneurs;	// nombre de neuronnes par couche.
	int   * tab_nbneurscum; // nombre de neuronnes cumuls par couche.
	int   * tab_nbpoids;	// nombre de poids par couche.	
	int   * tab_nbpoidscum;	// nombre de poids cumuls par couche.

	float * tab_poids;		// table des poids.
	float * tab_neuronnes;	// table des neuronnes.
};