//*********************************
// Class  : Agent
// Author : Emmnauel Chauvin
// Date   : 11/06/2001
//*********************************

#include <stdarg.h>
#include <stdlib.h> 
#include <stdio.h>
#include <memory.h>
#include <windows.h>
#include "Agent.h"

//**************************************************
// Constructeur.
// Initialisation du rseau et allocation mmoire.
//**************************************************
Agent::Agent(int nb_couches_ref, ... )
{
   int i= nb_couches_ref,j = 0;
   nb_poids = 0;
   nb_neuronnes = 0;
   nb_couches = nb_couches_ref;

   RAND_MAX_DEMI = RAND_MAX/2.0;

   // Initialisation et allocation des tables de comptage.
   tab_nbneurs = (int *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,nb_couches * sizeof(int));
   tab_nbneurscum = (int *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,(nb_couches+1) * sizeof(int));
   tab_nbpoids = (int *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,nb_couches * sizeof(int));
   tab_nbpoidscum = (int *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,nb_couches * sizeof(int));

   va_list marker;

   // On initialise le premier cumul.
   tab_nbneurscum[j] = 0;

   va_start( marker, nb_couches_ref );      
   i = va_arg( marker, int);
   while( j < nb_couches && i!= 0 )
   {
     tab_nbneurs[j]=i;
	 nb_neuronnes += i;
	 j++;

	 tab_nbneurscum[j] = nb_neuronnes;

	 i = va_arg( marker, int);
	 if (j< nb_couches && i != 0)
	 {
		 tab_nbpoids[j]=i*tab_nbneurs[j-1];
		 nb_poids += tab_nbpoids[j];
		 tab_nbpoidscum[j] = nb_poids;
	 }
   }

   // Allocation mmoire pour la table des poids.
   // Cette table dtermine la valeur de tous les poids du rseau.
   tab_poids = (float *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,nb_poids * sizeof(float));

   // Allocation mmoire pour la table des neuronnes.
   // Cette table dtermine la valeur de tous les neuronnes du rseau.
   tab_neuronnes = (float *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,nb_neuronnes * sizeof(float));

   va_end( marker );					  
}

//**************
// Destructeur.
//**************
Agent::~Agent()
{
}

bool Agent::libe_memoire()
{
	HeapFree(GetProcessHeap(),HEAP_NO_SERIALIZE,tab_nbneurs);
	HeapFree(GetProcessHeap(),HEAP_NO_SERIALIZE,tab_nbneurscum);
	HeapFree(GetProcessHeap(),HEAP_NO_SERIALIZE,tab_nbpoids);
	HeapFree(GetProcessHeap(),HEAP_NO_SERIALIZE,tab_nbpoidscum);
	HeapFree(GetProcessHeap(),HEAP_NO_SERIALIZE,tab_poids);
	HeapFree(GetProcessHeap(),HEAP_NO_SERIALIZE,tab_neuronnes);

	return true;
}

//******************************
// Initialisation des poids.
//******************************
bool Agent::init_poids()
{
	int i;
	for (i=0;i< nb_poids;i++)
	{
		tab_poids[i]=Alea_poids();
	}
	return true;
}

bool Agent::init_poids(float * tab_poids_ref)
{
    memcpy (tab_poids,tab_poids_ref,sizeof(float)*nb_poids);
	return true;
}

bool Agent::init_poids(float fpoids, int ind_poids)
{
    tab_poids[ind_poids]= fpoids;
	return true;
}

float Agent::Alea_poids ()
{
	return ((float) ((rand () / RAND_MAX_DEMI)-1.0));
}
// RAND_MAX_DEMI = 16383.5

//******************************
// Lecture des poids.
//******************************
bool Agent::lect_poids(float * tab_poids_ref)
{
    // duplication mmoire pour la table des poids.
    memcpy (tab_poids_ref,tab_poids,sizeof(float)*nb_poids);

	return true;
}

bool Agent::lect_poids(float * ptpoids, int ind_poids)
{
    *ptpoids = tab_poids[ind_poids];
	return true;
}

//******************************
// Initialisation des neuronnes.
//******************************
// Initialisation de la couche entree du reseau de neuronnes.
bool Agent::init_neuronnes()
{
	memset(tab_neuronnes,0,sizeof(float)*nb_neuronnes);
	return true;
}

//******************************
// Lecture des neuronnes.
//******************************
// Lecture du rsultat aprs propagation du signal.
bool Agent::lect_neuronnes(float * tab_neuronnes_sortie )
{
   memcpy (tab_neuronnes_sortie,&tab_neuronnes[nb_neuronnes - tab_nbneurs[nb_couches - 1]],tab_nbneurs[nb_couches - 1] * sizeof(float));
   return true;
}

// Lecture d'une couche de neuronne.
bool Agent::lect_neuronnes(float * tab_neuronnes_sortie, int ind_couche)
{
   memcpy (tab_neuronnes_sortie,&tab_neuronnes[tab_nbneurscum[ind_couche - 1]],tab_nbneurs[ind_couche - 1] * sizeof(float));
   return true;
}

//**********************************************
// Propagation du signal  travers le rseau.
//**********************************************
bool Agent::propagation()
{
	int icouche;
	int ineur;
	int ineur_s;
	int ind_poids;
	int nbneurp1;
	int nbneurscum;
	int nbneurscump1;
	int nbneurscump2;
	int constante;

	for (icouche=0;icouche < nb_couches-1;icouche++)
	{
		nbneurscum = tab_nbneurscum[icouche];
		nbneurscump1 = tab_nbneurscum[icouche+1];
		nbneurscump2 = tab_nbneurscum[icouche+2];
		nbneurp1 = tab_nbneurs[icouche + 1];
		constante = tab_nbpoidscum[icouche] - (nbneurscum * nbneurp1);

		for (ineur=nbneurscum;ineur<nbneurscump1;ineur++)
		{
			// On ne calcule le signal que si le neuronne en emet un. 
			if (tab_neuronnes[ineur]==1)
			{
				//ind_poids = tab_nbpoidscum[icouche]+((ineur-tab_nbneurscum[icouche]) * tab_nbneurs[icouche + 1]);
				ind_poids = constante + (ineur * nbneurp1);
				for (ineur_s=nbneurscump1;ineur_s<nbneurscump2;ineur_s++)
				{
					tab_neuronnes[ineur_s] += tab_poids[ind_poids];
					ind_poids++;
				}
			}
		}

		// Seuillage.
		// On ne seuille pas la dernire couche.
		if (icouche < nb_couches-2)
		{
			for (ineur_s=nbneurscump1;ineur_s<nbneurscump2;ineur_s++)
			{
				if (tab_neuronnes[ineur_s] > 0)
					tab_neuronnes[ineur_s] = 1;
				else
					tab_neuronnes[ineur_s] = 0;
			}
		}
	}

	// Contrle valeur des neurones. ( effacer).
	/*char szMsg [128]; 

	for (int i = 0;i<75;i++)
	{
		sprintf (szMsg,"Neurone %.2d = %+.10f \n",i,tab_neuronnes[i]);
		OutputDebugString(szMsg);
	}*/

	return true;
}
