#include <windows.h> 
#include "testgrille.h"
#include "jeu.h"   


#if defined (WIN32)
	#define IS_WIN32 TRUE
#else
	#define IS_WIN32 FALSE
#endif

#define IS_NT      IS_WIN32 && (BOOL)(GetVersion() < 0x80000000)
#define IS_WIN32S  IS_WIN32 && (BOOL)(!(IS_NT) && (LOBYTE(LOWORD(GetVersion()))<4))
#define IS_WIN95   (BOOL)(!(IS_NT) && !(IS_WIN32S)) && IS_WIN32

HINSTANCE hInst;   // current instance
BOOL RegisterWin95( CONST WNDCLASS* lpwc );

LPCTSTR lpszAppName  = "MyApp";
LPCTSTR lpszTitle    = "Jeu d'Othello avec rseaux de neurones";

//-----------------------------------------------------------
/* Zone de donnes et de dclaration de prototypes spcifiques
   Othello : */
//-----------------------------------------------------------
/* - Variables Windows pour affichage de la grille d'Othello. */

PAINTSTRUCT ps;
RECT rect;
HBITMAP hgrille,pionblanc,pionnoir;
BITMAP  grille,bmpb,bmpn;
HDC     hMemDC;
POINT   ptCursor;
HDC     hDC;
char szMsg[128];
char cprogress[128];
int l1,t1;
int tot1,tot2;
int casexy [10] = {0,1,31,61,91,121,151,181,211,241};
int xdamier,ydamier;
int xcase,ycase;
int casdamwin;
char humain;
char indjowin;
int fini_partie;

HCURSOR cursor_oui;
HCURSOR cursor_non;
BOOL radio_blanc;

//--------------------------------------------------------
/* - Fonctions Windows d'affichage. */

void afficher_image (HDC hDC,HDC hMemDC,HBITMAP himage,BITMAP image,int x,int y);
void afficher_damier (HDC hDC,HDC hMemDC);
void renvoi_posfenetre (HWND hWnd,int *l,int *t);
void init_appli (void);
void cliquer (HWND hWnd);
void bouger (HWND hWnd);
void rafraichir (HWND hWnd);
void jouer_ordinateur (HWND hWnd);
int jepasse (HWND hWnd);
void fin_partie (HWND hWnd);
void test_fin_partie (HWND hWnd);
void affiche_texte (HWND hWnd);

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPTSTR lpCmdLine, int nCmdShow)
{
   MSG      msg;
   HWND     hWnd; 
   WNDCLASS wc;

   // Register the main application window class.
   //............................................
   wc.style         = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = (WNDPROC)WndProc;       
   wc.cbClsExtra    = 0;                      
   wc.cbWndExtra    = 0;                      
   wc.hInstance     = hInstance;              
   wc.hIcon         = LoadIcon( hInstance, lpszAppName ); 
   wc.hCursor       = LoadCursor(NULL,IDC_CROSS);
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   wc.lpszMenuName  = lpszAppName;              
   wc.lpszClassName = lpszAppName;              

   if ( IS_WIN95 )
   {
      if ( !RegisterWin95( &wc ) )
         return( FALSE );
   }
   else if ( !RegisterClass( &wc ) )
      return( FALSE );

   hInst = hInstance;
   
   // Create the main application window.
   //....................................
   hWnd = CreateWindow( lpszAppName, 
                        lpszTitle,    
                        WS_OVERLAPPEDWINDOW,
						CW_USEDEFAULT, 0, 
                        520, 287,  
                        NULL,              
                        NULL,              
                        hInstance,         
                        NULL               
                      );

   if ( !hWnd ) 
      return( FALSE );

   ShowWindow( hWnd, nCmdShow ); 
   UpdateWindow( hWnd );         

   while( GetMessage( &msg, NULL, 0, 0) )   
   {
      TranslateMessage( &msg ); 
      DispatchMessage( &msg );  
   }

   return( msg.wParam ); 
}


BOOL RegisterWin95( CONST WNDCLASS* lpwc )
{
   WNDCLASSEX wcex;

   wcex.style         = lpwc->style;
   wcex.lpfnWndProc   = lpwc->lpfnWndProc;
   wcex.cbClsExtra    = lpwc->cbClsExtra;
   wcex.cbWndExtra    = lpwc->cbWndExtra;
   wcex.hInstance     = lpwc->hInstance;
   wcex.hIcon         = lpwc->hIcon;
   wcex.hCursor       = lpwc->hCursor;
   wcex.hbrBackground = lpwc->hbrBackground;
   wcex.lpszMenuName  = lpwc->lpszMenuName;
   wcex.lpszClassName = lpwc->lpszClassName;

   // Added elements for Windows 95.
   //...............................
   wcex.cbSize = sizeof(WNDCLASSEX);
   wcex.hIconSm = (struct HICON__ *) LoadImage(wcex.hInstance, lpwc->lpszClassName, 
                            IMAGE_ICON, 16, 16,
                            LR_DEFAULTCOLOR );
			
   return RegisterClassEx( &wcex );
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static HWND hText = NULL;

	switch( uMsg )
    {
	case WM_CREATE :
		{
			/* Initialisation des donnes propres au jeu d'Othello. */

			init_othello ();
			initdamier();

			/* Initialisation des curseurs, donnes windows de l'application. */

			init_appli ();

			CheckMenuRadioItem (GetMenu (hWnd),
			ID_NIVEAU_2,
			ID_NIVEAU_3,
			ID_NIVEAU_1,MF_BYCOMMAND);

			init_reseau ();
			init_tableaux();

			if (!Onchargelatable(hWnd))
				DestroyWindow (hWnd);

			wsprintf( cprogress, " A vous de jouer ! ");
			hText = CreateWindow ("STATIC",cprogress,
				WS_CHILD | WS_VISIBLE | SS_LEFT | WS_DLGFRAME,
				260,10,220,25,
				hWnd,
				(HMENU)IDC_TEXT,
				hInst,NULL);

		}
		break;

	case WM_LBUTTONDOWN :
		{
			cliquer(hWnd);
		}
		break;
   
	case WM_MOUSEMOVE :
		{
			bouger (hWnd);		 
		}
		break;

	case WM_PAINT :
		{
			rafraichir (hWnd);
		}
		break;
		   
	case WM_COMMAND :
              
		switch( LOWORD( wParam ) )
              {
			     case IDM_TEST :
						{
							DialogBox (hInst,"DIALOG1",hWnd,
							(DLGPROC)TestDlgBoite);

							if (indjowin != humain)
							{
								indjowin = humain;
								jouer_ordinateur(hWnd);
							}
						}
                        break;

				 case IDM_TRI :
						{
					    HMENU hMenu = GetMenu (hWnd);
						ModifyMenu (hMenu,IDM_TRI,
							MF_BYCOMMAND | MFS_GRAYED,
							IDM_TRI,"Excuter");
						DrawMenuBar (hWnd);
						tri_reseaux (hWnd);
						calcul_coupos (indjowin);
						}
						break;

                 case IDM_ABOUT :
					
                        DialogBox( hInst, "AboutBox", hWnd, (DLGPROC)About);
                        break;

				 case ID_NIVEAU_1 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);
						nb_res_sol = 1;
					 }
                        break;

				case ID_NIVEAU_2 :
					{
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);
						nb_res_sol = 2;
					}

                        break;

				case ID_NIVEAU_3 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 3;
					 }
                        break;

				case ID_NIVEAU_4 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 4;
					 }
                        break;

				case ID_NIVEAU_5 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 5;
					 }
                        break;

				case ID_NIVEAU_6 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 6;
					 }
                        break;

				case ID_NIVEAU_7 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 7;
					 }
                        break;

				case ID_NIVEAU_8 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 8;
					 }
                        break;

				case ID_NIVEAU_9 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 9;
					 }
                        break;

				case ID_NIVEAU_10 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 10;
					 }
                        break;

				case ID_NIVEAU_15 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 15;
					 }
                        break;

				case ID_NIVEAU_20 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 20;
					 }
                        break;
				
				case ID_NIVEAU_25 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 25;
					 }
                        break;

				case ID_NIVEAU_30 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 30;
					 }
                        break;

				case ID_NIVEAU_36 :
					 {
						CheckMenuRadioItem (GetMenu (hWnd),
							ID_NIVEAU_2,
							ID_NIVEAU_3,
							LOWORD( wParam ),MF_BYCOMMAND);

						nb_res_sol = 36;
					 }
                        break;

                case IDM_EXIT :

						DestroyWindow( hWnd );
                        break;
              }
              break;
      
     case WM_DESTROY :

		 libe_memoire ();
         PostQuitMessage(0);
         break;

      default :
            return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
   }

   return( 0L );
}


LRESULT CALLBACK About( HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   switch (message) 
   {
       case WM_INITDIALOG: 
               return (TRUE);

       case WM_COMMAND:
				
               if (   LOWORD(wParam) == IDOK         
                   || LOWORD(wParam) == IDCANCEL)    
               {
                       EndDialog(hDlg, TRUE);        
                       return (TRUE);
               }
               break;
   }

   return (FALSE); 
}

LRESULT CALLBACK TestDlgBoite ( HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   switch (message) 
   {
       case WM_INITDIALOG:
		   CheckRadioButton (hDlg,IDC_RADIO1,IDC_RADIO2,
			   radio_blanc ? IDC_RADIO1 : IDC_RADIO2);
               
       case WM_COMMAND:                              
               switch (   LOWORD(wParam))
			   {
			   case IDC_RADIO1 :
				   radio_blanc = TRUE;
				   humain = 1;
				   CheckRadioButton (hDlg,IDC_RADIO1,IDC_RADIO2,
									IDC_RADIO1);
				   break;
			   case IDC_RADIO2 :
				   radio_blanc = FALSE;
				   humain = 2;
				   CheckRadioButton (hDlg,IDC_RADIO1,IDC_RADIO2,
									IDC_RADIO2);
				   break;
			   case IDOK :
				   
			       EndDialog(hDlg, IDOK);        
                   break;
               }
               break;
			   default :
				   return FALSE;
   }
   return TRUE; 
}

//------------------------------------------------------------
// renvoi la position de la fentre en pixel. 

void renvoi_posfenetre( HWND hWnd,int *ll,int *tt)
{
							WINDOWPLACEMENT wp;
							// Initialize the structure size.
                            //...............................
                            wp.length = sizeof( WINDOWPLACEMENT );

                            if ( GetWindowPlacement( hWnd, &wp ) )
                            {
                                 *ll =wp.rcNormalPosition.left;
                                 *tt =wp.rcNormalPosition.top;
                            }
}

//-----------------------------------------------
// Affichage des pions.

void afficher_image (HDC hDC,HDC hMemDC,HBITMAP himage,
					BITMAP image,int x,int y)
{
	SelectObject( hMemDC, himage);

	BitBlt( hDC, x, y, 
            image.bmWidth, 
            image.bmHeight, 
            hMemDC, 0, 0, SRCCOPY );
}

//---------------------------------------------------------------
// Affichage du damier.

void afficher_damier (HDC hDC,HDC hMemDC)
{
	for (xdamier=1;xdamier<9;xdamier++)
	  {
		for (ydamier=1;ydamier<9;ydamier++)
			{
			if (damier [((ydamier-1)*8)+xdamier] == 1)
				{
					afficher_image (hDC,hMemDC,pionblanc,bmpb,
								casexy[xdamier],casexy[ydamier]);
				}
			else
				if (damier [((ydamier-1)*8)+xdamier] == 2)
					{
				    	afficher_image (hDC,hMemDC,pionnoir,bmpn,
								casexy[xdamier],casexy[ydamier]);
					}
			}
	  }
}

//-----------------------------------------------------------------
/* Initialisation des variables othello ncessaire  l'affichage */

void init_appli ()
{
	cursor_oui = LoadCursorFromFile("oui.cur");
	cursor_non = LoadCursorFromFile("non.cur");
	indjowin = 1;
	humain = 1;
	tri = 0;
	fini_partie = 0;
	nb_res_sol = 1;
	radio_blanc = TRUE;
	calcul_coupos(indjowin);
}

//---------------------------------------------------------------
/* Cette fonction est excute lorsque le bouton de la souris
a t cliqu. */
 
void cliquer (HWND hWnd)
{
			  pionblanc = LoadBitmap( hInst,"point_blanc");
			  GetObject( pionblanc, sizeof(BITMAP),&bmpb);

			  pionnoir = LoadBitmap( hInst,"point_noir");
              GetObject( pionnoir, sizeof(BITMAP),&bmpn);

              // Paint the bitmap on the screen.
              //................................
              hDC = GetDC( hWnd );
              hMemDC = CreateCompatibleDC( hDC );
			  GetClientRect( hWnd, &rect );
				
			  /* Dtermine la position relation du curseur 
			     et calcul les coordonnes de la case de damier pointe. */

			  renvoi_posfenetre (hWnd,&l1,&t1);
			  GetCursorPos( &ptCursor );

			  xcase = ptCursor.x-l1-2;
			  ycase = ptCursor.y-t1-40;
			  
			  if (xcase >= 0 && xcase <= 241 && ycase >= 0 && ycase <= 241)
			  {

			  for (xdamier=1;xcase > casexy[xdamier] && xdamier <=9 ;xdamier++);
			  for (ydamier=1;ycase > casexy[ydamier] && ydamier <=9 ;ydamier++);

			  xdamier--;
			  ydamier--;
			  casdamwin = ((ydamier-1)*8)+xdamier;

			  if (coupos[casdamwin] == 1) 
				{
				  jouer_coup (casdamwin, indjowin);

				  afficher_damier (hDC,hMemDC);

				  jouer_ordinateur (hWnd);
				}
			  
			  }

			  DeleteDC(hMemDC);
              ReleaseDC(hWnd,hDC);
              DeleteObject(hgrille);
			  DeleteObject(pionblanc);
			  DeleteObject(pionnoir);
}

//---------------------------------------------------------------
/* Cette fonction est excute lorsque la souris bouge. */

void bouger (HWND hWnd)
{
			  
			  /* Dtermine la position relation du curseur 
			     et calcul les coordonnes de la case de damier pointe. */

			  renvoi_posfenetre (hWnd,&l1,&t1);
			  GetCursorPos( &ptCursor );

			  xcase = ptCursor.x-l1-2;
			  ycase = ptCursor.y-t1-40;
			  
			  if (xcase >= 0 && xcase <= 241 && ycase >= 0 
				             && ycase <= 241)
			  {

			  for (xdamier=1;xcase > casexy[xdamier] && xdamier <=9 ;xdamier++);
			  for (ydamier=1;ycase > casexy[ydamier] && ydamier <=9 ;ydamier++);

			  xdamier--;
			  ydamier--;

			  casdamwin = ((ydamier-1)*8)+xdamier;
			  
			  /* Affichage du curseur en fonction des possibilits. */
			  
			   if (coupos[casdamwin] == 1) 
			   {
				  SetCursor (cursor_oui);
			   }
			   else
			   {
				  SetCursor (cursor_non);
			   }
			  }
			  else
			  {
				  SetCursor ((struct HICON__ *)IDC_CROSS);
			  }
			  
              affiche_texte (hWnd);

}

//--------------------------------------------------------------
/* Lorsque une partie de la fentre est efface cette fonction 
   est appelle. */

void rafraichir (HWND hWnd)
{
			  BeginPaint( hWnd, &ps );
 
			  hgrille = LoadBitmap( hInst,"grille1");
              GetObject( hgrille, sizeof(BITMAP),&grille);

			  pionblanc = LoadBitmap( hInst,"point_blanc");
			  GetObject( pionblanc, sizeof(BITMAP),&bmpb);

			  pionnoir = LoadBitmap( hInst,"point_noir");
              GetObject( pionnoir, sizeof(BITMAP),&bmpn);

              // Paint the bitmap on the screen.
              //................................
              hDC = GetDC( hWnd );
              hMemDC = CreateCompatibleDC( hDC );
			  GetClientRect( hWnd, &rect );

              afficher_image (hDC,hMemDC,hgrille,grille,0,0);

			  afficher_damier (hDC,hMemDC);

			  DeleteDC(hMemDC);
              ReleaseDC(hWnd,hDC);
              DeleteObject(hgrille);
			  DeleteObject(pionblanc);
			  DeleteObject(pionnoir);

			  affiche_texte (hWnd);
              
			  EndPaint( hWnd, &ps );
}

//----------------------------------------------------------------
/* L'ordinateur joue. On positionne l'indicateur de la couleur
   avec laquelle l'ordinateur doit jouer, puis on la restitue. */

void jouer_ordinateur (HWND hWnd)
{
			  int ordipasse = 0;
			  int humainpasse = 2;

			  bouger (hWnd);
				  
			  while ((humainpasse == 0 || humainpasse == 2) && fini_partie == 0)
			  {
				  if (indjowin == 2)
				     indjowin = 1;
				  else 
					 indjowin = 2;

				  ordipasse = jepasse (hWnd);

				  if (fini_partie == 0)
				  {

					if (ordipasse == 0 && humainpasse == 0)
					{
					  fin_partie (hWnd);
					}
					else
					{
						if (ordipasse == 1)
						{
						jouer_reseaux(indjowin,hWnd);
						rafraichir (hWnd);
						bouger (hWnd);
						}
				  
						if (indjowin == 2)
							indjowin = 1;
						else
							indjowin = 2;

						humainpasse = jepasse (hWnd);

						if (ordipasse == 0 && humainpasse == 0 
							&& fini_partie == 0)
							fin_partie (hWnd);
					 }
				  }

			  }
			  fini_partie = 0;
}

//-----------------------------------------------------------
/* Boucle au cas il y aurait plusieurs fois  passer son tour. */

int jepasse (HWND hWnd)
{
	int a = 1;
	int b = 0;

	calcul_coupos(indjowin);

	test_fin_partie (hWnd);

	if (fini_partie == 0)
	{
		a = 1;
		b = 0;

		while (a < 65 && b == 0)
		{
			if (coupos [a] == 1)
				b = 1;
			a++;
		}

		if (b == 0)
		{
			if (indjowin != humain)
			{
			MessageBox (hWnd,
			  " L'ordinateur passe mon tour !",
			  "Il ne peux pas retourner de pions."
			  ,MB_OK);
			}
			else
			{
				MessageBox (hWnd,
				"Passez votre tour !",
				"Vous ne pouvez pas retourner de pions."
				,MB_OK);
			}
			return (0);
		}
		else
		return (1);
	}
	else
	return (0);

}

//------------------------------------------------------------
/* Test de fin de partie. */

void fin_partie (HWND hWnd)
{
	if (MessageBox (hWnd,
	   "Voulez-vous refaire une autre partie ?",
	   "La partie est termine !", MB_YESNO) == IDYES)
	{
		initdamier();
		init_appli ();
		CheckMenuRadioItem (GetMenu (hWnd),
		ID_NIVEAU_2,
		ID_NIVEAU_3,
		ID_NIVEAU_1,MF_BYCOMMAND);
		rafraichir (hWnd);
	}
	else
	{
		DestroyWindow( hWnd );
	}
	fini_partie = 1;
}

//-------------------------------------------------------
// Test fin de partie.

void test_fin_partie (HWND hWnd)
{
	aff_score (&tot1,&tot2);

	if (tot1+tot2 == 64 || tot1 == 0 || tot2 == 0)
	{
		fin_partie (hWnd);
	}
}

//--------------------------------------------
// Affichage de la couleur avec laquelle le joueur joue et le
//   score en cours. 

void affiche_texte (HWND hWnd)
{
		      hDC = GetDC( hWnd );
              SetBkMode( hDC, OPAQUE );
              
			  if (humain == 1)
				  wsprintf( szMsg, "Vous jouez avec la couleur blanche.  ");
			  else
				  wsprintf( szMsg, "Vous jouez avec  la  couleur  noire.  ");

			  TextOut( hDC, 250, 100, szMsg, lstrlen( szMsg ) );

			  aff_score (&tot1,&tot2);

              wsprintf( szMsg, "Score des Noirs  = %d.   ",tot2);
			  TextOut( hDC, 250, 140, szMsg, lstrlen( szMsg ) );

			  wsprintf( szMsg, "Score des Blancs = %d.   ",tot1);
              TextOut( hDC, 250, 160, szMsg, lstrlen( szMsg ) );

			  ReleaseDC( hWnd, hDC );
}