#include <iostream.h>
#include <time.h>
#include <stdlib.h>
#include <memory.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <float.h>

/*   dictionnaire de donne

    - TVC = table des valeurs des connexions (pour toute la population de rseaux)
    - TVC2 = 2me table des valeurs des connexions (servant pour la reproduction)
    - TVN = table des valeurs des neurones (pour la dcision)
    - nb_pop = nombre de rseau mis en concurrence (ou population de rseaux)
    - nb_couche1 = nombre de neurones sur la couche 1
    - nb_couche2 = nombre de neurones sur la couche 2
    - nb_couche3 = nombre de neurones sur la couche 3
    - nb_couche4 = nombre de neurones sur la couche 4
    - nb_con12	 = nombre de connexions entre couche 1 et 2
    - nb_con123  = nombre de connexions entre couche 1, 2 et 3
    - nb_connexion = nombre total de connexion pour 1 rseau (couches 1, 2, 3 et 4)
    - nb_neurone   = nombre total de neurone pour 1 rseau (couches 1, 2, 3 et 4)
      (= couche1 + couche2 + couche3 + couche4)
    - taille_TVN = taille en octet de la table des valeurs des neurones
		     (pour 1 rseaux) = (nb_neurone * 4) + 4
    - taille d'un rseau = nb_connexion * 2;
    - taille_rseaux = taille en octet de la table des valeurs des connexions
		     (pour tous les rseaux en comptition)
		    = (nb_connexion * 2 * nb_pop) + 2
    - gene = nombre de manches effectues pour ce groupe de rseaux (=gnration)
    - score1 = score lors d'un match du joueur n1 (joueur de gauche)
    - score2 = score lors d'un match du joueur n2 (joueur de droite)
    - sco = table des scores pour chacun des rseaux pour une manche (dim =nb_pop)
    - scortot = score total de tous les rseaux pour une manche
    - repro = table des numros de rseaux nouvellement reproduits (dim =nb_pop)
	- melange = table d'indice permettant le mlange des rseaux, 
    - finmatch = boolen sur la fin d'un match
    - nb_coup = nombre de coup jou au cours d'une partie
    - coup1 = coup jou par le joueur 1
    - coup2 = coup jou par le joueur 2
    - mj = indice du rseau dont le score a t le meilleur pour la manche
    - damier = damier d'othello (64 en char)
    - coupos = tables des coups possibles (64 en char)
    - car_aff = rponse  la question de l'affichage */


/* pour rseaux de neurones */

static int nb_pop = 36;
static int nb_pop_plus1 = 37;
static int nb_couche1 = 129;
static int nb_couche2 = 20;
static int nb_couche3 = 20;
static int nb_couche4 = 64;
static int nb_couche12;
static int nb_couche123;
static int nb_neurone;
static int nb_con12;
static int nb_con123;
static int nb_connexion;
static long int taille_TVN;
static long int taille_1res;
static long int taille_reseaux;
static float *TVN;
static float *TVC;
static float *TVC2;

/* variables jeux et variables divers */

static int a1;
static int a2;
static int score1;
static int score2;
static float gene;
static int scortot;
static short *sco;
static short *repro;
static int *roue;
static short *melange;

/* variables othello */

static char *damier;
static char *coupos;
static char indjo;
static char car_aff;

/* divers  */
/* indicateur sur le remplissage du fichier les "meilleur". */
static float a_ecraser;
/* handle du fichier "meilleur" */
static int h_meil;

/* prototypes de fonction */

void init(void);
void boucle_apprentissage (void);	
void sauvres(void);
void libe_memoire(void);
void Onchargelatable(void);
void libe_memoire (void);
void reproduction (void);
void crossover (long,long,long,long);
void mutation (void);
void repro_TVC (void);
void transvase_reseau (int,int,int,int);
void manche (void);
void match (int,int);
void partie(void);
int calcul_coup(void);
void calcul_coupos (void);
int jouable (int,int,int,int);
void jouer_coup (int);
void retourner_ligne (int,int,int, int);
void vision(void);
void initdamier(void);
void calcul_score(void);
void propa_avant (int);
void aff_best(int);
void meilleur(int);
void ouvrir_meilleur(void);
void fermer_meilleur(void);
void resti_meilleur(void);
void manche_meilleur(void);
int ecrire_ecraser(void);
void aff_meilleur (int,int);

/*--------------------------------------------------------*/
/*	programme Othello version 32 bit, appli console.	  */
/*--------------------------------------------------------*/

void main (void)
{
	  
	  /* La fonction alatoire est dfinie avec l'horloge du micro. */

	  srand( (unsigned)time( NULL ) );

	  /* Initialisation des cumuls de couches. */

	  nb_couche12 = nb_couche1 + nb_couche2;
	  nb_couche123 = nb_couche12 + nb_couche3;

	  /* Nb de neurone pour 1 rseau.  */

	  nb_neurone = nb_couche123 + nb_couche4;

	  /* Nb_connexion pour 1 rseau. */

	  nb_connexion = (nb_couche1 * nb_couche2) + (nb_couche2 * nb_couche3) +(nb_couche3 * nb_couche4);

	  /* Nb de connexion entre couche 1 et 2. */

	  nb_con12 = (nb_couche1 * nb_couche2);

	  /* Nb de connexion entre couche 1, 2 et 3. */

	  nb_con123 = (nb_couche1 * nb_couche2) + (nb_couche2 * nb_couche3);

	  /* Taille de la table des neurones (TVN). */

	  taille_TVN = (long)(((long)nb_neurone * (long)4) +(long)4);

	  /* Taille d'un rseau. */

	  taille_1res = ((long)nb_connexion * (long)4);

	  /* La taille de la table des connexions de tous les rseaux
	     de neurones. (= 36 rseaux) */

	  taille_reseaux = (long) ((long)(taille_1res * (long)nb_pop) + (long)4);
	  
	  /* Initialisation des tables TVC, TVC2 et TVN. */

	  cout << "Jeux d'Othello : programme d'apprentissage rapide." << endl;	

	  init();

	  /* Ouverture du fichier des meilleurs */
	  
	  ouvrir_meilleur ();

	  /* Boucle qui ne s'arrte qu'en tapant "o" sur le clavier. */

	  boucle_apprentissage ();	

	  /* Sauvegarde des rseaux sur fichier. */

	  sauvres();

	  /* Fermeture du fichier des meilleurs */

	  fermer_meilleur ();

	  /* Libration mmoire. */

	  libe_memoire();
	  	  
}


/*----------------------------------------------------------------------*/
/* allocation et initialisation des tables de connexions et de neurones */

void init()
{
      int i,j;
	  long nbre_element;
	  
	  /* Allocation de la table des connexions de tous les rseaux */

	  nbre_element = ((long) nb_connexion * (long) nb_pop) + (long)1;

	  TVC  = new float [nbre_element];	
	  TVC2 = new float [nbre_element];
	  
	  /* Allocation de la table qui contient la valeur des neurones
	     pendant les calculs.  */

	  nbre_element = (long) nb_neurone + (long)1;

	  TVN = new float [nbre_element];
	  
	  /* Affichage caractristique du rseau */

	  cout << "Nb neurones = " << nb_neurone << " nb connexion = " 
		   << nb_connexion <<" nb octet total = " << taille_reseaux 
		   << endl;

	  sco   = new short [nb_pop_plus1];
	  repro = new short [nb_pop_plus1];

	  damier = new char [65];
	  coupos = new char [65];
	  
	  /* Initialisation de la table d'indice permettant le mlange
	     des rseaux pendant la phase de reproduction et de crossover.
		 Cette modification est necessaire afin que les enfants (rseaux de la gnration 
		 suivante) ne s'affrontent pas dans la mme poule. */
	  
	  melange = new short [nb_pop_plus1];

	  /* Allocation de la mmoire pour la table roue utilise lors de la reproduction. */  	

	  roue = new int [nb_pop_plus1];

	  j = 1;
	  for (i=1;i<nb_pop;i+=2)
	  {
		  melange [i]   = j;
		  melange [i+1] = j+18;
		  j++;
	  }
	  
	  /* initialisation de la table des scores  zro (dim = nb_pop) */

	  i = nb_pop_plus1 << 1;
	  memset (sco,0,i);
  
	  Onchargelatable();
}

/*------------------------------------------------------------------*/
/* Chargement du fichier othel.don en mmoire. */

void Onchargelatable() 
{

       int i,handle,lect;
	   long indtab;
	   short taille_int;

	   /* ouverture fichier */
               
	   if ((handle = open ("othelfl.don", O_RDWR | O_BINARY)) == -1)
		{
		 cout << "Ouverture fichier sauvegarde ne se fait pas" << endl;
		 exit (1);
		}

	   /* Lecture du fichier des connexions. 1 article par rseau.
	      Le 1er article contient le nb de gnration. (TVC [0]) */

	   taille_int = (unsigned int) taille_1res;

	   lect = read (handle,TVC,taille_int+4);
	   if (lect == -1)
		{
		 cout << "lecture ne se fait pas"<< endl;
		 cout << "handle " <<handle;
		 exit (1);
		}
  
	   indtab = (long)1+(long)nb_connexion;

	   for (i=2;i<nb_pop_plus1;i++)
	   {
	   
	   lect = read (handle,&TVC[indtab],taille_int);
	   if (lect == -1)
		{
		 cout << "lecture ne se fait pas"<< endl;
		 cout << "handle " << handle;
		 exit (1);
		}
	   indtab += (long)nb_connexion;
	   }							 	 
	   
	   /* restitution du nombre de gnration */

	   gene = TVC [0];

	   /* fermeture du fichier */	

	   close (handle);
	   
}

/*-------------------------------------------------------------------------*/
/* boucle d'apprentissage */

void boucle_apprentissage () 
{
	int mj, i;
	int nb_sauv = 0;
	char nb;
	
	nb = ' ';

	do
	  {

	  /* Incrmentation du nombre de gnration. */

	  gene++;
	  cout << "Generation = " << gene << " / ";
	  
	  /* Pour chaque gnration une manche est ralise, soit 90 parties
	     pour 36 rseaux en 6 poules de 6 rseaux. */

	  manche();

	  /* Calcul du score total tous rseaux confondus + mmorisation
	     du rseau le meilleur pour cette manche (pour la slection
	     dans le fichier "meilleur"). */

	  mj = 1;
	  scortot = 0;
	  for (i=1;i<nb_pop_plus1;i++)
	  {
	    scortot += sco [i];
	    if (sco [i] > sco [mj])
	       mj = i;
	  }

	  /* Affichage du rseau ayant obtenu le meilleur score. */

	  aff_best(mj);

	  /* On constitue un fichier des rseaux ayant obtenus les meilleurs
	     rsultats (>=17 pour tre slectionn). */

	  if (sco[mj] > 16)
	    meilleur(mj);

	  /* Toutes les 200 gnrations on sauvegarde l'tat des rseaux.
	     A raison de 3 secondes par gnration, cela fait environ
	     une sauvegarde toutes les dix minutes. */

	  nb_sauv++;
	  if (nb_sauv > 199)
	     {
		sauvres();
		nb_sauv = 0;
	     }

	  /* Reproduction des rseaux en fonction des scores obtenus.
	     (cf Algorithme gntique). + phase de crossover (modif 21/10/1997) */

	  reproduction();

	  /* Mutation alatoire de connexions. (cf Algorithme gntique) */

	  mutation();

	  /* Test donnant la possibilit de stopper la boucle
	     d'apprentissage. */

	  if (kbhit())
		    {
			cout << " Voulez-vous stopper le programme (O/N) ? " << endl;
			getch();
			do {
			nb = getch ();
			} while (nb != 'O' && nb != 'o' && nb != 'N' && nb != 'n');
		    }
	  }
	  while (nb != 'O' && nb != 'o');

/* fin boucle d'apprentissage */
}

/*--------------------------------------------*/
/* sauvegarde de tous les rseaux sur fichier */

void sauvres ()
{
	   int handle,i;
	   long indtab;
	   unsigned int taille_int;

	   /* ouverture du fichier */

	   if ((handle= open ("othelfl.don", O_WRONLY | O_CREAT
		   | O_BINARY, S_IREAD | S_IWRITE)) == -1)
		{
		 printf ("Ouverture fichier sauvegarde ne se fait pas");
		 exit (1);
		}
       	   
	   /* mmorisation du nombre de gnration sur fichier */

	   TVC [0] = gene;

	   /* Ecriture sur fichier. 1 article pour chaque rseau.
	      Le 1er article contient le nombre de gnration.(TVC [0])	*/

	   taille_int = (unsigned int) taille_1res;
	    
	   if ((write (handle,TVC,taille_int+4)) == -1)
		{
		 printf ("Ecriture ne se fait pas");
		 printf ("handle %d ",handle);
		 exit (1);
		}

	   indtab = (long)nb_connexion + (long)1;

	   for (i=2;i<nb_pop_plus1;i++)
	   {
       
	   if ((write (handle,&TVC[indtab],taille_int)) == -1)
		{
		 printf ("Ecriture ne se fait pas");
		 printf ("handle %d ",handle);
		 exit (1);
		}
	   
	   indtab += (long)nb_connexion;

	   }

	   /* fermeture fichier */

	   close (handle);

}

/*-----------------------------------------------------*/
/* Libration de la mmoire contenue dans les tables.*/

void libe_memoire ()
{
	delete TVC, TVC2,TVN,sco,repro,coupos,damier,melange,roue;
}

/*----------------------------------------*/
/* La phase reproduction consiste  un tirage alatoire
   (pondr  partir des scores obtenus) de la nouvelle gnration de
   rseaux. */

void reproduction()
{
	  float tempo,arrond,val1,val2;
	  int i,j,alea;
	  
	  /* la table roue se prsente comme une roue de la chance
	     ou chaque rseaux y est reprsent par un quartier plus ou moins
	     grand selon le score qu'il a fait durant la manche.
	     Dans chaque poste de la roue on y trouve le cumul des scores */

	  i = nb_pop_plus1 << 2;
	  memset (roue,0,i);

	  /* on considre que la roue fait 32767 units,
	     donc le score total de la manche doit tre reprsent sur
	     cette roue. */

	  tempo = (float) ((float)32767 / (float)scortot);

	  /* pour chaque poste de la roue on calcule le score du rseau, plus
	     celui des rseaux des postes prcdents. Calculer la dernire roue
	     ne sert  rien. */

	  for (i=1;i<nb_pop;i++)
	    {
		val2 = (float)sco [i] * tempo;
		val1 = (float)ceil(val2);

		/* gestion de l'arrondi */

		arrond = val1 - val2;
		if (arrond < 0.5)
		   roue [i] = roue [i-1] + (int)val1;
		  else
		   roue [i] = roue [i-1] + (int)val2;
	    }

	  /* tirage alatoire sur la roue */

	  for (i=1;i<nb_pop_plus1;i++)
	    {
		alea = rand ();
		j = 0;
		do
		  {
		    j++;
		  }
		while (alea > roue[j] && j < nb_pop);
		repro [i] = j;
	    }

      /* On applique les rsultats de la table de reproduction sur
	     la table des connexions TVC. De plus la phase de crossover 
	     y a t incorpore pour des raisons d'optimisation et pour y intgrer 
	     le mlange des rseaux.*/

	  repro_TVC ();

}

/*----------------------------------------*/
/* La table TVC doit en sortie de cette fonction avoir tous les rseaux en place
   par rapport  la table de reproduction. */

void repro_TVC()
{
	 int i;
	 float * pt_TVC;
	 
	 /* A partir de la table des reproductions, on permute les rseaux.*/

	 for (i=1;i<nb_pop;i+=2)
	    {

	        /* on transvase les rseaux de 2 en 2
		       dans la zone TVC2 en y appliquant les indices de la
		       table melange pour y oprer le mlange et le crossover. */

		    transvase_reseau (melange[i],repro[i],melange[i+1],repro[i+1]);
	    }

     /* On permute les 2 tables */

	 pt_TVC = TVC;
	 TVC = TVC2;
	 TVC2 = pt_TVC;

}

/*------------------------------------------------------------*/
/* Toutes les rseaux qui ont t choisi par la reproduction vont tre
   transfr dans la table TVC2 en y oprant le crossover.  */

void transvase_reseau (int i1,int j1, int i2, int j2 )
{
	       long int indrep1, indrep2;
		   long int indrep3, indrep4;

	       /* on valorise les indices pour les tables TVC et TVC2. */

	       indrep1 = (((long)i1-(long)1) * (long)nb_connexion) + (long)1;
		   indrep2 = (((long)j1-(long)1) * (long)nb_connexion) + (long)1;
		   indrep3 = (((long)i2-(long)1) * (long)nb_connexion) + (long)1;
		   indrep4 = (((long)j2-(long)1) * (long)nb_connexion) + (long)1;

		   crossover (indrep1,indrep2,indrep3,indrep4);
     
}

/*-----------------------------------------------------------------------*/
/* Mlange de valeurs de connexions entre rseaux issus
	     de la reproduction. (cf Algorithme gntique). 
   Pendant la reproduction,  partir de la table TVC, on va prendre des postes
   de cette table deux  deux et pour chacun des rseaux dsigns par
   ces postes on va intervetir certaines de leurs connexions, cela s'apparante
   au croisement de gnes lors de la reproduction dans le monde vivant.
   L'endroit, o va se faire le croisement, est dsign alatoirement. */

void crossover(long indrep1,long indrep2,long indrep3,long indrep4)
{
	 int nboct1,nboct2;
	 long indrep11,indrep22,indrep33,indrep44;
	 int aleaint;
	 float falea;
	 float alea;

	      /* Tirage alatoire de l'endroit o l'on fait la coupe du
		  crossover, le chiffre obtenu est compris
		  entre 1 et nb_connexion */

	       alea = (float)rand () / (float)32767;
	       falea = (float)(ceil (alea * (float)nb_connexion));
	       aleaint = (int)falea;

	       /* on calcule le nombre d'octets que reprsente la partie du
		  rseau qui se trouve avant la coupe. */

	      nboct1 = (int)aleaint * (int)4;

		  /* On calcule le nombre d'octet situ aprs la coupe. */
		   
		  nboct2 = taille_1res - nboct1;
		  
		  /* On calcule l'indice de la coupe pour les quatre poste
		     de la table receptrice TVC2 et de la table TVC. */

		  indrep11 = indrep1 + aleaint;
		  indrep22 = indrep2 + aleaint;
		  indrep33 = indrep3 + aleaint;
		  indrep44 = indrep4 + aleaint;

	       /* on copie de la table TVC, indice par le 1er poste 
		   de la table melange du couple actuellement trait, la partie situe
		  avant la coupe sur la table TVC du 2me poste de la table melange
		  du couple. La zone receptrice est la table TVC2. */

	       memcpy (&TVC2[(long)indrep1],&TVC[(long)indrep2],(size_t)nboct1);
		   memcpy (&TVC2[(long)indrep3],&TVC[(long)indrep4],(size_t)nboct1);

		   /* La partie suprieure de la coupe est transvase dans le poste 
		      qui leur est destin tandis que la partie infrieure 
		      est permute. */
		   
		   memcpy (&TVC2[(long)indrep33],&TVC[(long)indrep22],(size_t)nboct2);
		   memcpy (&TVC2[(long)indrep11],&TVC[(long)indrep44],(size_t)nboct2);	
}

/*----------------------------------------*/
/* pour chacun des rseaux on choisit une connexion au hasard pour
   laquelle on change sa valeur */

void mutation ()
{
	 int i,j;
	 long int aleaint1,ind;
	 float alea,arrond,val1,val2;

	    /* boucle mutation pour chaque rseau */

	    for (i=1;i<nb_pop_plus1;i++)
	    {

	       /* diminution des mutations */

	       alea = (float) rand ();
	       if (alea > 25000)
			{
	       /* tirage alatoire de 30 connexions  modifier (avec arrondi) */

	       for (j=1;j<31;j++)
			{
			val2 = ((float)rand () / (float)32767.) * (float)nb_connexion;
			val1 = (float) ceil (val2);
			arrond = val1 - val2;
			if (arrond < 0.5)
			   aleaint1 = (int)val1;
			  else
			   aleaint1 = (int)val2;

		/* tirage alatoire de la nouvelle valeur de la connexion,
		  cette valeur est comprise entre 0 et 32767. */

			alea = (float)rand ()- (float) 16384;
			ind = ((long)(i-1)*(long)nb_connexion)+(long)aleaint1;
			TVC[ind] = (float) (alea/(float)16384);
			}
			}
	    }
}

/*------------------------------------------------------------------*/
/* Une manche rassemble toutes les parties. Pour les rseaux normaux (*)
   on organise la manche en 6 poules de 6 rseaux. Dans une poule
   tous les rseaux jouent entre eux. (* par opposition aux "meilleur")
   Ce qui fait 15 parties * 6 poules, soient 90 parties au total. */

void manche()
{
	  int i,j,k,l,p;

	  /* Initialisation de la table des scores  zro (dim = nb_pop).
	     Les matchs se font en series de 6 poules de 6 rseaux,
	     pour 36 rseaux en comptition. (si nb_pop = 36) */

	  i = nb_pop_plus1 << 1;
	  memset (sco,0,(size_t)i);

	  /* indice nombre de poules  6. */

	  p = 6;

	  for (k =1; k <= p; k++)
	    {
	      l = k * p;
	      for (i = l - p + 1; i < l; i++)
		{
			for (j = i+1; j <= l;j++)
			{
				match(i,j);
			}
		}
	    }
}

/*----------------------------------------*/
/*     Un match = une partie d'Othello.   */

void match(int j1,int j2)
{
	int alea;

	/* initialisation des variables du jeu */

	initdamier();

	/* initialisation des scores */

	score1 = 0;
	score2 = 0;

	/* Tirage au sort afin de dterminer de quel ct
	   vont jouer les rseaux. */

	alea = rand ();
	if (alea > 16383)
	   {
	    a1 = j1;
	    a2 = j2;
	   }
	  else
	   {
	    a1 = j2;
	    a2 = j1;
	   }

	/* Partie d'Othello. */

	partie();

	/* Calcul des pions afin de dterminer le vainqueur et le score. */

	calcul_score();

	/* Cumul des scores de la partie afin d'avoir un cumul pour
	   la manche pour chaque rseau. */

	sco [a1] += score1;
	sco [a2] += score2;
}

/*----------------------------------------*/
/*     La partie d'othello s'effectue.	  */

void partie()
{
	int finmatch;
	int coup1,coup2,nb_coup;

	/* La boucle s'effectue tant que le match n'est pas termin. */

	nb_coup = 0;
	finmatch = 0;

	while (finmatch == 0)
	{

	/* joueur 1 */

	indjo = 1;

	/* On dtermine les donnes en entre du rseau pour le joueur 1. */

	vision();

	/* Propagation des signaux pour le joueur 1 et pour le rseau a1. */

	propa_avant (a1);

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup1 = calcul_coup();

	if (coup1 != 0)
	    {
		nb_coup++;

		/* On applique la dcision du rseau sur le damier. */

		jouer_coup(coup1);
	    }
     
	/* joueur 2 */

	indjo = 2;

	/* On dtermine les donnes en entre du rseau pour le joueur 2. */

	vision();

	/* Propagation des signaux pour le joueur 2 et pour le rseau a2. */

	propa_avant (a2);

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup2 = calcul_coup();

	if (coup2 != 0)
	    {
		nb_coup++;

		/* On applique la dcision du rseau sur le damier. */

		jouer_coup(coup2);
	    }
    
	/* Ne pas oublier le cas spcifique o les deux joueurs
	   doivent passer leur tour. Dans ce cas la partie se termine sans
	   que les 60 coups aient t jous. */

	if ((coup1 == 0 && coup2 == 0) || (nb_coup == 60))
	    finmatch = 1;

	}
}
/*----------------------------------------*/
/* On regarde les valeurs qu'ont prises les neurones en sortie du rseau.
   On consulte le damier pour voir quel sont les coups possibles.
   Parmis ces coups possibles on prend la rponse du rseau dont la valeur du
   neurone est la plus leve. */

int calcul_coup()
{
    int indneu;
    float falea;
    int i,j;
    float best_val = (float) - FLT_MAX;
    int egalite [40];

    /* Initialisation du tableau des galits des rponses */

    memset (egalite,0,(size_t)160);

    /* Initialisation de la table des coups possibles */

    memset (coupos,0,(size_t)65);

    /* On regarde le damier d'othello et on ressence tous les coups possibles.
       Ceux-ci sont mmoriss dans la table des coups possibles. */

    calcul_coupos();

    /* On appareil les rponses du rseau (neurones de la couche de sortie 162-225)
       avec la tables des coups possibles. On retient la rponse qui a eu
       le neurone de sortie dont la valeur est la plus lve parmis les coups
       possibles.
       En d'galit de plusieurs rponses, celles-ci seront
       dsignes au sort.*/

    j = 0;

    for (i=1;i<65;i++)
	{
	    indneu = i + nb_couche123;
	    if (TVN [indneu] >= best_val && coupos [i] == 1)
		{
		     if (best_val == TVN [indneu])
			{
			 j++;
			 egalite [j] = i;
			 egalite [j+1] = 0;
			}
		     else
			{
			 j = 1;
			 egalite [j] = i;
			 egalite [2] = 0;
			 best_val = TVN[indneu];
			}
		}
	}

    /* Si dans la table galit il n'y a qu'un seul coup (indice 2  zro)
       alors le coup choisi sera la valeur de table galit indice 1.
       Sinon il faut faire un tirage alatoire entre les coups choisis.
       Il est possible qu'aucun coup ne soit possible auxquel cas on renvoie
       un zro. */

    if (egalite [1] == 0)
		return (0);
    else
    {
    if (egalite [2] == 0)
		return (egalite [1]);
    else
	{
	    for (i=3;egalite [i] != 0;i++);
	    i--;
	    falea =(float)((float)(rand()+1)/(float)32768.)*(float)i;
	    i = (int) (ceil ((double)falea));
	    return (egalite [i]);
	}
    }
}

/* ------------------------------------------------------------------------*/
/* on parcours toutes les cases vides du damier afin de dterminer quelles
   sont les cases sur lesquelles le rseau pourra jouer. */

void calcul_coupos ()
{
    int x,y;
    int casdam;

    for (x=1;x<9;x++)
	{
	    for (y=1;y<9;y++)
		{
		    casdam = ((y-1)*8)+x;
		    if (damier[casdam] == 0)
			{
			    coupos [casdam] = 1;
			    if (!jouable(0,1,x,y))
			      {
			      if (!jouable(1,0,x,y))
				{
				if (!jouable(1,1,x,y))
				  {
				  if (!jouable(-1,-1,x,y))
				    {
				    if (!jouable(-1,0,x,y))
				      {
				      if (!jouable(0,-1,x,y))
					{
					if (!jouable(1,-1,x,y))
					  {
					  if (!jouable(-1,1,x,y))
					    {
						coupos [casdam] = 0;
			      }	} } } } } } }
			}
		    else
			coupos [casdam] = 0;
		}  /* fin de la boucle sur les y */
	}   /* fin de la boucle sur les x */
}

/*-----------------------------------------------------------------------*/
/* Pour chaque case vide on regarde si l'on peut jouer dessus.
   Chaque ligne est inspecte. */

int jouable (int x0,int y0,int x,int y)
{
    int acote,enbout;
    int xd,yd;

    /* On regarde  ct de la case vide. Si il y a prsence
       d'un pion adverse alors on cherche sur cette ligne s'il existe un pion
       ami. */

    xd = x+x0;
    yd = y+y0;

    if (xd > 0 && xd < 9 && yd > 0 && yd < 9)
	{
	    acote = ((yd-1)*8)+xd;
	    if (damier [acote] != indjo && damier[acote] != 0)
		{
		    x = xd + x0;
		    y = yd + y0;
		    enbout = ((y - 1) * 8) + x;

		    while ((x > 0 && x < 9 && y > 0 && y < 9) &&
			   damier [enbout] != indjo	      &&
			   damier [enbout] != 0)
			{
			    y += y0;
			    x += x0;
			    enbout = ((y - 1) * 8) + x;
			}

		    if (damier [enbout] == indjo &&
			x > 0 && x < 9 && y > 0 && y < 9)
			    return (1);
		    else
			    return (0);
		}
	    else
		return (0);
	}
    else
	return(0);
}

/*--------------------------------------------------*/
/* on applique la dcision du rseau sur le damier. */

void jouer_coup (int coup)
{
    int x,y;

    /* calcul des coordonnes du coup sur le damier. Un dcalage de 3 bits vers la
	   droite revient  faire une division euclidienne par 8. */

    y = coup >> 3;
    x = coup - (8*y);
	
	if (x == 0)
		x = 8;
	else
		y++;

    damier [coup] = indjo;

    /* ligne en haut */
    retourner_ligne (0,-1,x,y);

    /* ligne en bas */
    retourner_ligne (0,1,x,y);

    /* ligne  droite */
    retourner_ligne (1,0,x,y);

    /* ligne  gauche */
    retourner_ligne (-1,0,x,y);

    /* ligne en haut  gauche */
    retourner_ligne (-1,-1,x,y);

    /* ligne en bas  droite */
    retourner_ligne (1,1,x,y);

    /* ligne en haut  droite */
    retourner_ligne (1,-1,x,y);

    /* ligne en bas  gauche */
    retourner_ligne (-1,1,x,y);

}

/*--------------------------------------------------------------------------*/
/*     On regarde  ct de la case joue. Si il y a prsence
       d'un pion adverse alors on cherche sur cette ligne s'il existe un pion
       ami. Si tel est le cas les pions ennemis situs prcdemment deviennent
       amis. (cf rgles du jeu d'othello).     */

void retourner_ligne (int x0,int y0,int x, int y)
{

    int acote,enbout;
    int xd,yd;

    xd = x+x0;
    yd = y+y0;

    if (xd > 0 && xd < 9 && yd > 0 && yd < 9)
	{
	    acote = ((yd-1)*8)+xd;
	    if (damier [acote] != indjo && damier[acote] != 0)
		{
		    x = xd+x0;
		    y = yd+y0;
		    enbout = ((y - 1) * 8) + x;

		    while ((x > 0 && x < 9 && y > 0 && y < 9) &&
			   damier [enbout] != indjo	      &&
			   damier [enbout] != 0)
			{
			    y += y0;
			    x += x0;
			    enbout = ((y - 1) * 8) + x;
			}

		    if (damier [enbout] == indjo &&
			x > 0 && x < 9 && y > 0 && y < 9)
			{
			    x = xd;
			    y = yd;
			    enbout = acote;
			    do
				{
				   damier [enbout] = indjo;
				   y += y0;
				   x += x0;
				   enbout = ((y - 1) * 8) + x;
				}
			    while (damier [enbout] != indjo);
			}
		}
	}
}

/*------------------------------------------------------------*/
/*  partir du damier on calcule
   les donnes qui iront dans les neurones entres du rseau. */

void vision()
       {

	int indneu,i;

	/* initialisation TVN */

	for (i =130;i<234;i++)
	    TVN[i] = 0;

	/* on parcourt le damier et on valorise les neurones
	   --> 2 neurones par cases, 0 = case vide, 1 = blanc, 2 = noir. */

	for (i=1;i < 65;i++)
	    {
	    indneu = i << 1;
	    if (damier [i] == 0)
		{
		    TVN [indneu-1] = 0;
		    TVN [indneu] = 0;
		}
	      else
		{
		  if (damier [i] == 1)
		    {
			if (indjo == 1)
			    {
				TVN [indneu-1] = 0;
				TVN [indneu] = 1;
			    }
			else
			    {
				TVN [indneu-1] = 1;
				TVN [indneu] = 0;
			    }
		    }
		else
		    {
			if (indjo == 1)
			    {
				TVN [indneu-1] = 1;
				TVN [indneu] = 0;
			    }
			else
			    {
				TVN [indneu-1] = 0;
				TVN [indneu] = 1;
			    }
		    }
		}
	    }

    /* on valorise le 129me neurone qui correspond  la couleur avec
       laquelle le rseau joue */

    if (indjo == 1)
	TVN [129] = 0;
    else
	TVN [129] = 1;

}

/*----------------------------------------*/
/* initialisation du damier d'othello */

void initdamier()
{
	memset (damier,0,(size_t)65);

	damier [28] = 1;
	damier [37] = 1;
	damier [29] = 2;
	damier [36] = 2;

}

/*-----------------------------------------------------------*/
/* calcul du score en fonction du nombre pions sur le damier */

void calcul_score()
{
    int i,tot1,tot2;

    tot1 = 0;
    tot2 = 0;

    for (i=1;i<65;i++)
	{
	    if (damier[i] == 1)
		    tot1++;
	    else
		{
		    if (damier[i] == 2)
			tot2++;
		}
	}

    if (tot1 > tot2)
	{
	score1 += 3;
	if ((tot1 - tot2) > 39)
	    score1++;
	}
    else
	{
	    if (tot1 < tot2)
		{
		score2 += 3;
		if ((tot2 - tot1) > 39)
		   score2++;
		}
	    else
		{
		score1++;
		score2++;
		}
	}
}
/*-------------------------------------------------------------------------*/
/* Propagation des signaux dans le rseau. Chaque neurone envoit un signal
    0 ou 1. Celui-ci est envoy  la couche de neurone immdiatement
   infrieure par les connexions. Ces dernires multiplient le signal
   en positif ou en ngatif (augmentation ou inhibition du signal). La couche
   rceptrice fait le total des signaux reus pour chaque neurone, lesquels
   ralisent le seuillage. C'est  dire que le neurone envoit un 1
   si cette somme est positive sinon c'est un 0. Pour le jeu d'othello,
   il n'y pas de seuillage pour la couche de sortie (couche 4), car la
   dcision de jouer sur une case est prise en fonction du total du signal
   reu. La case dont le signal est le plus lv sera la dcision du rseau
   ( la condition que le jeu autorise ce coup). */

void propa_avant (int num)

	  /* num = numro du rseau sollicit (entre 1 et nb_pop) */
	  
	  {

	  /* indice de la table des connexions */
	  int indnum;

	  int i,j,k,l;

	  indnum = (num-1)*nb_connexion;

	  /* propagation couche 1 vers couche 2 */

	  for (i=1; i <= nb_couche1; i++)
		{
		if ( TVN [i] == 1)
		  {
		  l = (i - 1) * nb_couche2 + indnum;
		  k = nb_couche1;
		  for (j=1; j <= nb_couche2 ;j++)
		    {
			l++;
			k++;
			TVN [k] += TVC[l];
		    }
		  }
		}

	  /* seuillage de la couche 2 */

	  for (i = nb_couche1 + 1; i <= nb_couche12 ;i++)
		    {
			if (TVN[i] > 0)
			   TVN [i] = 1;
			  else
			   TVN [i] = 0;
		    }

	  /* propagation couche 2 vers couche 3 */

	  for (i = nb_couche1 + 1; i <= nb_couche12 ; i++)
		{
		if ( TVN [i] ==1 )
		  {
		  l = ((i - nb_couche1 - 1) * nb_couche3) + nb_con12 + indnum;
		  k = nb_couche12;
		  for (j=1;j<= nb_couche3 ;j++)
		    {
			l++;
			k++;
			TVN [k] += TVC[l];
		    }
		  }
		}

	  /* seuillage de la couche 3 */

	  for (i = nb_couche12 + 1;i <= nb_couche123 ;i++)
		    {
			if (TVN[i] > 0)
			   TVN [i] = 1;
			  else
			   TVN [i] = 0;
		    }

	  /* propagation couche 3 vers couche 4 */

	  for (i = nb_couche12 + 1; i <= nb_couche123 ; i++)
		{
		if ( TVN [i] == 1 )
		  {
		  l = ((i - nb_couche12 - 1) * nb_couche4) + nb_con123 + indnum;
		  k = nb_couche123;
		  for (j = 1;j <= nb_couche4 ;j++)
		    {
			l++;
			k++;
			TVN [k] += TVC[l];
		    }
		  }
		}

	  /* seuillage de la couche 4. Pour le jeu d'othello,
	  il n'est pas fait. */
}

/*----------------------------------------------------------*/
/* Affichage du score le meilleur pour cette manche.			    */

void aff_best (int mj)
{
    cout << "Le meilleur score de la manche est " << sco[mj] 
		 << " par le reseau " << mj << endl;
}

/*-------------------------------------------------------------------------*/
/* Ouverture du fichier contenant les rseaux ayant obtenus les
   meilleurs scores. Lecture du 1er enregistrement contenant la zone
   " craser". */

void ouvrir_meilleur()
{
	   unsigned int lect;

	   /* ouverture du fichier "meilleur". */

       if ((h_meil= open ("meillfl.don", O_RDWR | O_CREAT
		   | O_BINARY, S_IREAD | S_IWRITE)) == -1)
		{
		 printf ("Ouverture fichier meillfl ne se fait pas");
		 exit (1);
		}

	   lect = read (h_meil,&a_ecraser,4);
	   if (lect == -1)
		{
		 cout << "lecture meillfl ne se fait pas"
		      << "h_meil "<<h_meil;
		 exit (1);
		}
}

/*----------------------------------------------------------------------*/
/* Chaque nouveau slectionn (score > 17) est confront aux autres.
   Celui qui obtient le moins bon score sera cras par l'arrivant de
   la prochaine slection. Cette information est stocke dans le premier
   enregistrement avec la zone " craser". */

void meilleur(int mj)
{
	   int i;
	   long nb_deplac,indsel;
	   short sco_stock [40];

	   /* On affiche sur l'cran le rseau selectionn. */

	   aff_meilleur(mj,1);

	   /* Positionnement sur le fichier sur le rseau  craser. */

	   nb_deplac = (long)taille_1res * ((long)a_ecraser-(long)1) + (long) 4;
	   lseek(h_meil,nb_deplac,SEEK_SET);
	   
	   /* Calcul de l'indice du tableau des connexions correspondant
	      au 1er poste du rseau slectionn. */

	   indsel = (((long) mj - (long)1) * (long)nb_connexion) + (long)1;

	   /* Ecriture du rseau slectionn sur le fichier. */

	   if ((write (h_meil,&TVC[indsel],(unsigned int)taille_1res)) == -1)
		{
		 printf ("criture meilleur ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit (1);
		}

	   /* On sauvegarde les rseaux normaux sur leur fichier. */

	   sauvres();

	   /* Mmorisation de la table des scores dans l'tat avant
	      l'excution de la manche "meilleur". */

	   for (i=1;i<nb_pop_plus1;i++)
		sco_stock[i]=sco[i];

	   /* On initialise la table des connexions TVC avec les rseaux
	      du fichier "meilleur". */

	   resti_meilleur();

	   /* On ralise une manche avec les rseaux "meilleur". Pour une
	      estimation plus fine du score on augmente le nombre de matchs,
	      soient 306 parties en 2 poules de 18 rseaux. */

	   manche_meilleur();

	   /* On va scrute la table des scores afin de dterminer le rseaux
	   le moins bon qui sera dsign " craser" pour la
	   prochaine slection. En mme temps on affiche le rseau qui sera
	   limin. */

	   aff_meilleur(ecrire_ecraser(),0);

	   /* On remet la table TVC dans l'tat avant l'accs au fichier
	      "meilleur". */

	   Onchargelatable();

	   /* Restitution de la table des scores dans l'tat avant
	      l'excution de la manche "meilleur". */

	   for (i=1;i<nb_pop_plus1;i++)
		sco[i]=sco_stock[i];

}

/*------------------------------*/
/* fermeture fichier "meilleur" */

void fermer_meilleur()
{
	   /* fermeture fichier */

	   close (h_meil);

}

/*----------------------------------------------------------------*/
/* Lecture du fichier des "meilleur" rseaux afin de les mettre
   en mmoire dans la table des connexions TVC. */

void resti_meilleur()
{
	   int i;
	   long indtab,lect;

	   /* Positionnement sur le 1er rseaux  lire. */

	   lseek(h_meil,4,SEEK_SET);

	   /* Lecture du fichier des connexions. 1 rseau par article. */

	   indtab = (long)1;

	   for (i=1;i<nb_pop_plus1;i++)
	   {

	    lect = read (h_meil,&TVC[indtab],(size_t)taille_1res);
	    if (lect == -1)
		{
		 printf ("lecture meilleur ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit (1);
		}
	    indtab += (long)nb_connexion;
	   }
}

/*----------------------------------------------------------------*/
/* Une manche rassemble toutes les parties. Pour les "meilleur"
   tous les rseaux jouent entre eux.
   Ce qui fait 630 parties. */

void manche_meilleur()
{
	  int i,j,k;

	  /* Initialisation de la table des scores  zro (dim = nb_pop).
	     soit 36 rseaux en comptition. (si nb_pop = 36) */

	  i = nb_pop_plus1 << 1;
	  memset (sco,0,(size_t)i);

	  /* 1er poule */

	  k = nb_pop;

	  for (i = 1; i < k; i++)
	  {
			for (j = i+1; j <= k; j++)
			{
				match(i,j);
			}
	  }

}

/*-----------------------------------------------------------------*/
/* On parcourt les scores afin de dterminer celui qui sera limin
   lors de la prochaine slection. On crit ensuite cette info sur
   le fichier "meilleur". (1er donne du fichier) */

int ecrire_ecraser()
{
	  int i,mauvais;

	  /* Parcours de la table des scores. */

	  mauvais = 1;
	  for (i=2;i<nb_pop_plus1;i++)
	  {
	    if (sco [i] < sco [mauvais])
	       mauvais = i;
	  }

	  /* Positionnement en dbut de fichier. */

	  lseek(h_meil,0,SEEK_SET);

	  /* Ecriture de l'indice du rseau  craser lors de la prochaine
	     slection. */

	  a_ecraser = (float)mauvais;

	  if (write (h_meil,&a_ecraser,4) == -1)
		{
		 printf ("criture a_ecraser ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit (1);
		}

	  return (mauvais);
}

/*----------------------------------------------------------*/
/* Affichage du numro de rseau qui va concourir avec les
   meilleurs. */

void aff_meilleur (int mj,int a)
{
	if (a == 0)
	   {
	   cout <<"Le reseau " << mj << " score = " << sco [mj] <<" lors du prochain passage." << endl;
	   }
	else
	   {
	   cout << "Le reseau " << mj << " est selectionn avec le score de " << sco[mj] << endl;
	   }
}
/*---------------------- Fin programme Othello ----------------------------*/
