#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <float.h>
#include <math.h>

/*   dictionnaire de donne

    - TVC = table des valeurs des connexions (pour toute la population de rseaux)
    - TVN = table des valeurs des neurones (pour la dcision)
    - nb_pop = nombre de rseau mis en concurrence (ou population de rseaux)
    - nb_couche1 = nombre de neurones sur la couche 1
    - nb_couche2 = nombre de neurones sur la couche 2
    - nb_couche3 = nombre de neurones sur la couche 3
    - nb_couche4 = nombre de neurones sur la couche 4
    - nb_con12	 = nombre de connexions entre couche 1 et 2
    - nb_con123  = nombre de connexions entre couche 1, 2 et 3
    - nb_connexion = nombre total de connexion pour 1 rseau (couches 1, 2, 3 et 4)
    - nb_neurone   = nombre total de neurone pour 1 rseau (couches 1, 2, 3 et 4)
      (= couche1 + couche2 + couche3 + couche4)
    - taille_TVN = taille en octet de la table des valeurs des neurones
		     (pour 1 rseaux) = (nb_neurone * 4) + 4
    - taille d'un rseau = nb_connexion * 2;
    - taille_rseaux = taille en octet de la table des valeurs des connexions
		     (pour tous les rseaux en comptition)
		    = (nb_connexion * 2 * nb_pop) + 2
    - gene = nombre de manches effectues pour ce groupe de rseaux (=gnration)
    - score1 = score lors d'un match du joueur n1 (joueur de gauche)
    - score2 = score lors d'un match du joueur n2 (joueur de droite)
    - sco = table des scores pour chacun des rseaux pour une manche (dim =nb_pop)
    - scortot = score total de tous les rseaux pour une manche
    - finmatch = boolen sur la fin d'un match
    - nb_coup = nombre de coup jou au cours d'une partie
    - coup1 = coup jou par le joueur 1
    - coup2 = coup jou par le joueur 2
    - mj = indice du rseau dont le score a t le meilleur pour la manche
    - damier = damier d'othello (64 en char)
    - coupos = tables des coups possibles (64 en char)
	- indjo = couleur des pions (1 = noir, 2 = blanc) 
 */
   
/* pour rseaux de neurones */

int nb_pop = 36;
int nb_pop_plus1 = 37;
int nb_couche1 = 129;
int nb_couche2 = 20;
int nb_couche3 = 20;
int nb_couche4 = 64;
int nb_couche12;
int nb_couche123;
int nb_neurone;
int nb_con12;
int nb_con123;
int nb_connexion;
long int taille_TVN;
long int taille_1res;
long int taille_reseaux;
float *TVN;
float *TVC;
float *TVC2;

/* Variables utilises par le prog. principal. */

char chaine[128];
int pcjeu = 0;
float valpc;
int tri; 

/* variables jeux et variables divers */

int score1;
int score2;
float gene;
int scortot;
short *sco;

/* Nombre de rseaux sollicits */

static int nb_res_sol;

/* variables othello */

static char *damier;
static char *memdam;
static char *coupos;

/* prototypes de fonction */

void init_othello (void);
void boucle_apprentissage (void);	
void sauvres(void);
void libe_memoire(void);
int Onchargelatable(HWND hWnd);
void manche (HWND hWnd);
void match (int,int);
void partie(int j1,int j2);
int calcul_coup(char indjo);
void calcul_coupos (char indjo);
int jouable (int a,int b,int c,int d,char e);
void jouer_coup (int coup, char indjo);
void retourner_ligne (int a,int b,int c, int d, char e);
void vision(char indjoueur);
void initdamier(void);
void calcul_score(void);
void aff_score(int *to1,int *to2);
void propa_avant (int);
void jouer_reseaux (char indjo,HWND hWnd);
void jouer_coup_ordi (char indjo);
void init_reseau (void);
void init_tableaux (void);
void init_score (void);
void memo_damier (void);
void resti_damier (void);
int numero_reseau (void);
void tri_reseaux (void);
void tri_decroissant (void);
void init_tri (void);
int calcul_best (void);
void transvase_reseau (int i1,int j1);
void manche_tri (HWND hWnd);
 

/*------------------------------------------*/
/* Initialisation des tables du jeu Othello */

void init_othello ()
{
      sco   = new short [nb_pop_plus1];
	  damier = new char [65];
	  memdam = new char [65];
	  coupos = new char [65];
}

/*--------------------------------------------------------------*/
/* Initialisation du damier d'Othello. */ 

void initdamier()
{
	memset (damier,0,(size_t)65);

	damier [28] = 1;
	damier [37] = 1;
	damier [29] = 2;
	damier [36] = 2;

}

//---------------------------------------------
/* Initialisation des variables des rseaux */

void init_reseau (void)
{
	  
	  /* La fonction alatoire est dfinie avec l'horloge du micro. */

	  srand( (unsigned)time( NULL ) );

	  /* Initialisation des cumuls de couches. */

	  nb_couche12 = nb_couche1 + nb_couche2;
	  nb_couche123 = nb_couche12 + nb_couche3;

	  /* Nb de neurone pour 1 rseau.  */

	  nb_neurone = nb_couche123 + nb_couche4;

	  /* Nb_connexion pour 1 rseau. */

	  nb_connexion = (nb_couche1 * nb_couche2) + (nb_couche2 * nb_couche3) +(nb_couche3 * nb_couche4);

	  /* Nb de connexion entre couche 1 et 2. */

	  nb_con12 = (nb_couche1 * nb_couche2);

	  /* Nb de connexion entre couche 1, 2 et 3. */

	  nb_con123 = (nb_couche1 * nb_couche2) + (nb_couche2 * nb_couche3);

	  /* Taille de la table des neurones (TVN). */

	  taille_TVN = (long)(((long)nb_neurone * (long)4) +(long)4);

	  /* Taille d'un rseau. */

	  taille_1res = ((long)nb_connexion * (long)4);

	  /* La taille de la table des connexions de tous les rseaux
	     de neurones. (= 36 rseaux) */

	  taille_reseaux = (long) ((long)(taille_1res * (long)nb_pop) + (long)4);

}


/*----------------------------------------------------*/
/* Allocation des tables de connexions et de neurones */

void init_tableaux ()
{
      long nbre_element;
	  
	  /* Allocation de la table des connexions de tous les rseaux */

	  nbre_element = ((long) nb_connexion * (long) nb_pop) + (long)1;

	  TVC  = new float [nbre_element];
	  
      /* Allocation de la table des connexions de tous les rseaux */

	  TVC2  = new float [nbre_element];	
	  
	  /* Allocation de la table qui contient la valeur des neurones
	     pendant les calculs.  */

	  nbre_element = (long) nb_neurone + (long)1;

	  TVN = new float [nbre_element];
}


/* ------------------------------------------------------------------------*/
/* on parcours toutes les cases vides du damier afin de dterminer quelles
   sont les cases sur lesquelles le rseau pourra jouer. */

void calcul_coupos (char indjo)
{
    int x,y;
    int casdam;

    for (x=1;x<9;x++)
	{
	    for (y=1;y<9;y++)
		{
		    casdam = ((y-1)*8)+x;
		    if (damier[casdam] == 0)
			{
			    coupos [casdam] = 1;
			    if (!jouable(0,1,x,y,indjo))
			      {
			      if (!jouable(1,0,x,y,indjo))
				{
				if (!jouable(1,1,x,y,indjo))
				  {
				  if (!jouable(-1,-1,x,y,indjo))
				    {
				    if (!jouable(-1,0,x,y,indjo))
				      {
				      if (!jouable(0,-1,x,y,indjo))
					{
					if (!jouable(1,-1,x,y,indjo))
					  {
					  if (!jouable(-1,1,x,y,indjo))
					    {
						coupos [casdam] = 0;
			      }	} } } } } } }
			}
		    else
			coupos [casdam] = 0;
		}  /* fin de la boucle sur les y */
	}   /* fin de la boucle sur les x */
}

/*-------------------------------------------------------------*/
/* Pour chaque case vide on regarde si l'on peut jouer dessus.
   Chaque ligne est inspecte. */

int jouable (int x0,int y0,int x,int y, char indjo)
{
    int acote,enbout;
    int xd,yd;

    /* On regarde  ct de la case vide. Si il y a prsence
       d'un pion adverse alors on cherche sur cette ligne s'il existe un pion
       ami. */

    xd = x+x0;
    yd = y+y0;

    if (xd > 0 && xd < 9 && yd > 0 && yd < 9)
	{
	    acote = ((yd-1)*8)+xd;
	    if (damier [acote] != indjo && damier[acote] != 0)
		{
		    x = xd + x0;
		    y = yd + y0;
		    enbout = ((y - 1) * 8) + x;

		    while ((x > 0 && x < 9 && y > 0 && y < 9) &&
			   damier [enbout] != indjo	      &&
			   damier [enbout] != 0)
			{
			    y += y0;
			    x += x0;
			    enbout = ((y - 1) * 8) + x;
			}

		    if (damier [enbout] == indjo &&
			x > 0 && x < 9 && y > 0 && y < 9)
			    return (1);
		    else
			    return (0);
		}
	    else
		return (0);
	}
    else
	return(0);
}


/*--------------------------------------------------*/
/* on applique la dcision du rseau sur le damier. */

void jouer_coup (int coup, char indjo)
{
    int x,y;

    /* calcul des coordonnes du coup sur le damier. Un dcalage de 3 bits vers la
	   droite revient  faire une division euclidienne par 8. */

    y = coup >> 3;
    x = coup - (8*y);

	if (x == 0)
		x = 8;
	else
		y++;

    damier [coup] = indjo;

    /* ligne en haut */
    retourner_ligne (0,-1,x,y,indjo);

    /* ligne en bas */
    retourner_ligne (0,1,x,y,indjo);

    /* ligne  droite */
    retourner_ligne (1,0,x,y,indjo);

    /* ligne  gauche */
    retourner_ligne (-1,0,x,y,indjo);

    /* ligne en haut  gauche */
    retourner_ligne (-1,-1,x,y,indjo);

    /* ligne en bas  droite */
    retourner_ligne (1,1,x,y,indjo);

    /* ligne en haut  droite */
    retourner_ligne (1,-1,x,y,indjo);

    /* ligne en bas  gauche */
    retourner_ligne (-1,1,x,y,indjo);

}

/*--------------------------------------------------------------------------*/
/*     On regarde  ct de la case joue. Si il y a prsence
       d'un pion adverse alors on cherche sur cette ligne s'il existe un pion
       ami. Si tel est le cas les pions ennemis situs prcdemment deviennent
       amis. (cf rgles du jeu d'othello).     */

void retourner_ligne (int x0,int y0,int x, int y, char indjo)
{

    int acote,enbout;
    int xd,yd;

    xd = x+x0;
    yd = y+y0;

    if (xd > 0 && xd < 9 && yd > 0 && yd < 9)
	{
	    acote = ((yd-1)*8)+xd;
	    if (damier [acote] != indjo && damier[acote] != 0)
		{
		    x = xd+x0;
		    y = yd+y0;
		    enbout = ((y - 1) * 8) + x;

		    while ((x > 0 && x < 9 && y > 0 && y < 9) &&
			   damier [enbout] != indjo	      &&
			   damier [enbout] != 0)
			{
			    y += y0;
			    x += x0;
			    enbout = ((y - 1) * 8) + x;
			}

		    if (damier [enbout] == indjo &&
			x > 0 && x < 9 && y > 0 && y < 9)
			{
			    x = xd;
			    y = yd;
			    enbout = acote;
			    do
				{
				   damier [enbout] = indjo;
				   y += y0;
				   x += x0;
				   enbout = ((y - 1) * 8) + x;
				}
			    while (damier [enbout] != indjo);
			}
		}
	}
}

/*-----------------------------------------------------------*/
/* calcul du score en fonction du nombre pions sur le damier */

void aff_score(int *tot1, int *tot2)
{
    int i, to1, to2;

	to1 = 0;
	to2 = 0;

    for (i=1;i<65;i++)
	{
	    if (damier[i] == 1)
		    to1++;
	    else
		{
		    if (damier[i] == 2)
			  to2++;
		}
	}

	*tot1 = to1;
	*tot2 = to2;
}

//=================================================
//=================================================
// Fonctions utilises par les rseaux.
//=================================================
   
/*-----------------------------------------------*/
/* Chargement du fichier meillfl.don en mmoire. */

int Onchargelatable(HWND hWnd) 
{

       int i,handle,lect;
	   long indtab;
	   short taille_int;

	   /* ouverture fichier */
               
	   if ((handle = open ("othelfl.don", O_RDWR | O_BINARY)) == -1)
		{
		 MessageBox (hWnd,
			 "Ouverture du fichier des connexions ne se fait pas.  ",
			 "Impossible de dmarrer la partie ! ",
			 MB_ICONSTOP | MB_OK);
		 return 0;
		}

	   /* Lecture du fichier des connexions. 1 article par rseau.
	      Le 1er article contient le nb de gnration. (TVC [0]) */

	   taille_int = (unsigned int) taille_1res;

	   lect = read (handle,TVC,taille_int+4);
	   if (lect == -1)
		{
		   MessageBox (hWnd,
			 "Echec en lecture du fichier des connexions.  ",
			 "Impossible de dmarrer la partie ! ",
			 MB_ICONSTOP | MB_OK);
		   return 0;
		}
  
	   indtab = (long)1+(long)nb_connexion;

	   for (i=2;i<nb_pop_plus1;i++)
	   {
	   
	   lect = read (handle,&TVC[indtab],taille_int);
	   if (lect == -1)
		{
		  MessageBox (hWnd,
			 "Echec en lecture du fichier des connexions.  ",
			 "Impossible de dmarrer la partie ! ",
			 MB_ICONSTOP | MB_OK);
		  return 0;
		}
	   indtab += (long)nb_connexion;
	   }							 	 
	   
	   /* restitution du nombre de gnration */

	   gene = TVC [0];

	   /* fermeture du fichier */	

	   close (handle);

	   return 1;
}

/*-------------------------------------------------------------------------*/
/* Propagation des signaux dans le rseau. Chaque neurone envoit un signal
    0 ou 1. Celui-ci est envoy  la couche de neurone immdiatement
   infrieure par les connexions. Ces dernires multiplient le signal
   en positif ou en ngatif (augmentation ou inhibition du signal). La couche
   rceptrice fait le total des signaux reus pour chaque neurone, lesquels
   ralisent le seuillage. C'est  dire que le neurone envoit un 1
   si cette somme est positive sinon c'est un 0. Pour le jeu d'othello,
   il n'y pas de seuillage pour la couche de sortie (couche 4), car la
   dcision de jouer sur une case est prise en fonction du total du signal
   reu. La case dont le signal est le plus lv sera la dcision du rseau
   ( la condition que le jeu autorise ce coup). */

void propa_avant (int num)

	  /* num = numro du rseau sollicit (entre 1 et nb_pop) */
	  
	  {

	  /* indice de la table des connexions */
	  int indnum;

	  int i,j,k,l;

	  indnum = (num-1)*nb_connexion;

	  /* propagation couche 1 vers couche 2 */

	  for (i=1; i <= nb_couche1; i++)
		{
		if ( TVN [i] == 1)
		  {
		  l = (i - 1) * nb_couche2 + indnum;
		  k = nb_couche1;
		  for (j=1; j <= nb_couche2 ;j++)
		    {
			l++;
			k++;
			TVN [k] += TVC[l];
		    }
		  }
		}

	  /* seuillage de la couche 2 */

	  for (i = nb_couche1 + 1; i <= nb_couche12 ;i++)
		    {
			if (TVN[i] > 0)
			   TVN [i] = 1;
			  else
			   TVN [i] = 0;
		    }

	  /* propagation couche 2 vers couche 3 */

	  for (i = nb_couche1 + 1; i <= nb_couche12 ; i++)
		{
		if ( TVN [i] ==1 )
		  {
		  l = ((i - nb_couche1 - 1) * nb_couche3) + nb_con12 + indnum;
		  k = nb_couche12;
		  for (j=1;j<= nb_couche3 ;j++)
		    {
			l++;
			k++;
			TVN [k] += TVC[l];
		    }
		  }
		}

	  /* seuillage de la couche 3 */

	  for (i = nb_couche12 + 1;i <= nb_couche123 ;i++)
		    {
			if (TVN[i] > 0)
			   TVN [i] = 1;
			  else
			   TVN [i] = 0;
		    }

	  /* propagation couche 3 vers couche 4 */

	  for (i = nb_couche12 + 1; i <= nb_couche123 ; i++)
		{
		if ( TVN [i] == 1 )
		  {
		  l = ((i - nb_couche12 - 1) * nb_couche4) + nb_con123 + indnum;
		  k = nb_couche123;
		  for (j = 1;j <= nb_couche4 ;j++)
		    {
			l++;
			k++;
			TVN [k] += TVC[l];
		    }
		  }
		}

	  /* seuillage de la couche 4. Pour le jeu d'othello,
	  il n'est pas fait. */
}

/*-----------------------------------------------------*/
/* Libration de la mmoire contenue dans les tables.*/

void libe_memoire ()
{
	delete TVC,TVC2,TVN,sco,coupos,damier,memdam;
}

/*--------------------------------------------------*/
/* Le systme des 36 rseaux vont rpondre au coup. */

void jouer_reseaux (char indjo,HWND hWnd) 
{
	
	init_score ();

	memo_damier ();

	manche (hWnd);

	resti_damier ();

	jouer_coup_ordi (indjo);

}

/*--------------------------------------------------*/
/* Le coup retenu est celui du rseau qui a obtenu le meilleur 
	score. */

void jouer_coup_ordi (char indjo) 
{
	int coup;

	vision(indjo);

	/* Propagation des signaux pour le rseau dsign. */

	propa_avant (numero_reseau());

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup = calcul_coup(indjo); 

	/* On applique la dcision du rseau sur le damier. */

	jouer_coup(coup,indjo);

}

//----------------------------------------
/* Initialisation de la table des score et d'une  variable
   pour le calcul du poucentage de reflexion. */

void init_score ()
{
	int i;

	/* initialisation de la table des scores  zro 
	   (dim = nb_pop) */

	i = nb_pop_plus1 << 1;
	memset (sco,0,i);
	
	/* Valeur pour calcul du poucentage de l'tat de reflexion. */
	valpc = (float)100. / ((float) (nb_res_sol*(nb_res_sol - 1)));
}

//-------------------------
// Mmorisation du damier. 

void memo_damier ()
{
	char * tempon;
	tempon = memdam;
	memdam = damier;
	damier = tempon;
}

//-------------------------
// Restitution du damier. 

void resti_damier ()
{
	char * tempon;
	tempon = damier;
	damier = memdam;
	memdam = tempon;
}

//--------------------------------------------
// Dterminer le rseau qui rpondra au coup. 

int numero_reseau ()
{
	int i, mj;

	mj = 1;
	scortot = 0;
	for (i=1;i<nb_pop_plus1;i++)
	  {
	    scortot += sco [i];
	    if (sco [i] > sco [mj])
	       mj = i;
	  }
	return (mj);
}

/*-------------------------------------------------------------*/
/* Une manche rassemble toutes les parties. Pour les rseaux 
   on organise la manche ou tous jouent contre tous les autres,
   une fois en jouant le premier, et une autre en deuxime. 
   Soit 1260 parties. */
 	
void manche(HWND hWnd)
{
	  int i,j,k;

	  k = 0;

	  for (i =1; i <= nb_res_sol; i++)
	  {
	    for (j = 1; j <= nb_res_sol; j++)
		  {
			if ( i != j)
			{
				k++;
				match(i,j);

				/* Envoi d'un message au controle de la fentre,
				   pour affichage. */

				pcjeu = (int) (valpc * k);
				wsprintf( chaine, "  Je rflchis ... %d %%. ",pcjeu);
				SetDlgItemText (hWnd,IDC_TEXT,chaine);
			}
		  }
	  }
	  wsprintf( chaine, "  A vous de jouer ! ");
	  SetDlgItemText (hWnd,IDC_TEXT,chaine);
}

/*----------------------------------------*/
/*     Un match = une partie d'Othello.   */

void match(int j1,int j2)
{
	
	/* initialisation des variables du jeu */

	initdamier();

	/***************************/
	/* Partie d'Othello. j1 j2 */
	/***************************/

	partie (j1,j2);

	/* Calcul des pions afin de dterminer le vainqueur et le score. */

	calcul_score();

	/* Cumul des scores de la partie afin d'avoir un cumul pour
	   la manche pour chaque rseau. On ne compte que les score
	   pour le rseau qui joue en premier.*/

	sco [j1] += score1;

	if (tri ==  1)
	    sco [j2] += score2;

	/***************************/
	/* Partie d'Othello. j2 j1 */
	/***************************/

	partie (j2,j1);

	/* Calcul des pions afin de dterminer le vainqueur et le score. */

	calcul_score();

	/* Cumul des scores de la partie afin d'avoir un cumul pour
	   la manche pour chaque rseau. On ne compte que les score
	   pour le rseau qui joue en premier.*/

	sco [j2] += score1;

	if (tri ==  1)
	    sco [j1] += score2;
}

/*------------------------------------------------------------*/
/* calcul du score en fonction du nombre pions sur le damier. */

void calcul_score()
{
    int i,tot1,tot2;
	
	/* initialisation des scores */

	score1 = 0;
	score2 = 0;

    tot1 = 0;
    tot2 = 0;

    for (i=1;i<65;i++)
	{
	    if (damier[i] == 1)
		    tot1++;
	    else
		{
		    if (damier[i] == 2)
			tot2++;
		}
	}

    if (tot1 > tot2)
	{
	score1 += 3;
	if ((tot1 - tot2) > 39)
	    score1++;
	}
    else
	{
	    if (tot1 < tot2)
		{
		score2 += 3;
		if ((tot2 - tot1) > 39)
		   score2++;
		}
	    else
		{
		score1++;
		score2++;
		}
	}
}

/*----------------------------------------*/
/*     La partie d'othello s'effectue.	  */

void partie(int j1,int j2)
{
	int finmatch;
	int coup1,coup2,nb_coup;

	/* La boucle s'effectue tant que le match n'est pas termin. */

	nb_coup = 0;
	finmatch = 0;

	while (finmatch == 0)
	{

	
	/* On dtermine les donnes en entre du rseau 
	   pour le joueur 1. */

	vision(1);

	/* Propagation des signaux pour le joueur 1 et pour le rseau a1. */

	propa_avant (j1);

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup1 = calcul_coup(1);

	if (coup1 != 0)
	    {
		nb_coup++;

		/* On applique la dcision du rseau sur le damier. */

		jouer_coup(coup1,1);
	    }
     
	/* On dtermine les donnes en entre du rseau 
	   pour le joueur 2. */

	vision(2);

	/* Propagation des signaux pour le joueur 2 et pour le rseau a2. */

	propa_avant (j2);

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup2 = calcul_coup(2);

	if (coup2 != 0)
	    {
		nb_coup++;

		/* On applique la dcision du rseau sur le damier. */

		jouer_coup(coup2,2);
	    }
    
	/* Ne pas oublier le cas spcifique o les deux joueurs
	   doivent passer leur tour. Dans ce cas la partie se termine sans
	   que les 60 coups aient t jous. */

	if ((coup1 == 0 && coup2 == 0) || (nb_coup == 60))
	    finmatch = 1;

	}
}

/*----------------------------------------------------------*/
/* On regarde les valeurs qu'ont prises les neurones en sortie du rseau.
   On consulte le damier pour voir quel sont les coups possibles.
   Parmis ces coups possibles on prend la rponse du rseau dont la valeur du
   neurone est la plus leve. */

int calcul_coup(char indjo)
{
    int indneu;
    float falea;
    int i,j;
    float best_val = (float) - FLT_MAX;
    int egalite [40];

    /* Initialisation du tableau des galits des rponses */

    memset (egalite,0,(size_t)160);

    /* Initialisation de la table des coups possibles */

    memset (coupos,0,(size_t)65);

    /* On regarde le damier d'othello et on ressence tous les coups possibles.
       Ceux-ci sont mmoriss dans la table des coups possibles. */

    calcul_coupos(indjo);

    /* On appareil les rponses du rseau (neurones de la couche de sortie 162-225)
       avec la tables des coups possibles. On retient la rponse qui a eu
       le neurone de sortie dont la valeur est la plus lve parmis les coups
       possibles.
       En d'galit de plusieurs rponses, celles-ci seront
       dsignes au sort.*/

    j = 0;

    for (i=1;i<65;i++)
	{
	    indneu = i + nb_couche123;
	    if (TVN [indneu] >= best_val && coupos [i] == 1)
		{
		     if (best_val == TVN [indneu])
			{
			 j++;
			 egalite [j] = i;
			 egalite [j+1] = 0;
			}
		     else
			{
			 j = 1;
			 egalite [j] = i;
			 egalite [2] = 0;
			 best_val = TVN[indneu];
			}
		}
	}

    /* Si dans la table galit il n'y a qu'un seul coup (indice 2  zro)
       alors le coup choisi sera la valeur de table galit indice 1.
       Sinon il faut faire un tirage alatoire entre les coups choisis.
       Il est possible qu'aucun coup ne soit possible auxquel cas on renvoie
       un zro. */

    if (egalite [1] == 0)
		return (0);
    else
    {
    if (egalite [2] == 0)
		return (egalite [1]);
    else
	{
	    for (i=3;egalite [i] != 0;i++);
	    i--;
	    falea =(float)((float)(rand()+1)/(float)32768.)*(float)i;
	    i = (int) (ceil ((double)falea));
	    return (egalite [i]);
	}
    }
}

/*------------------------------------------------------------*/
/*  partir du damier on calcule
   les donnes qui iront dans les neurones entres du rseau. */

void vision (char indjoueur)
{
	int indneu,i;

	/* initialisation TVN */

	for (i =130;i<234;i++)
	    TVN[i] = 0;

	/* on parcourt le damier et on valorise les neurones
	   --> 2 neurones par cases, 0 = case vide, 1 = blanc, 2 = noir. */

	for (i=1;i < 65;i++)
	    {
	    indneu = i << 1;
	    if (damier [i] == 0)
		{
		    TVN [indneu-1] = 0;
		    TVN [indneu] = 0;
		}
	      else
		{
		  if (damier [i] == 1)
		    {
			if (indjoueur == 1)
			    {
				TVN [indneu-1] = 0;
				TVN [indneu] = 1;
			    }
			else
			    {
				TVN [indneu-1] = 1;
				TVN [indneu] = 0;
			    }
		    }
		else
		    {
			if (indjoueur == 1)
			    {
				TVN [indneu-1] = 1;
				TVN [indneu] = 0;
			    }
			else
			    {
				TVN [indneu-1] = 0;
				TVN [indneu] = 1;
			    }
		    }
		}
	    }

    /* on valorise le 129me neurone qui correspond  la couleur avec
       laquelle le rseau joue */

    if (indjoueur == 1)
	TVN [129] = 0;
    else
	TVN [129] = 1;

}

/*--------------------------------------------------*/
// Tri du rseau dans l'ordre dcroissant de force.

void tri_reseaux (HWND hWnd) 
{
	
	init_tri ();

	memo_damier ();

	initdamier ();

	manche_tri (hWnd);

	resti_damier ();

	tri_decroissant ();

}

/*-------------------------------------------------------------*/
/* Une manche rassemble toutes les parties. Pour les rseaux 
   on organise la manche ou tous jouent contre tous les autres,
   une fois en jouant le premier, et une autre en deuxime. 
   Soit 1260 parties. */
 	
void manche_tri (HWND hWnd)
{
	  int i,j,k;

	  k = 0;

	  for (i =1; i <= nb_pop; i++)
	  {
	    for (j = 1; j <= nb_pop; j++)
		  {
			if ( i != j)
			{
				k++;
				match(i,j);

				/* Envoi d'un message au controle de la fentre,
				   pour affichage. */

				pcjeu = (int) (valpc * k);
				wsprintf( chaine, "  Je trie le rseau ... %d %%. ",pcjeu);
				SetDlgItemText (hWnd,IDC_TEXT,chaine);
			}
		  }
	  }
	  wsprintf( chaine, "  A vous de jouer ! ");
	  SetDlgItemText (hWnd,IDC_TEXT,chaine);
}
 
//---------------------------------------------------------
/* Initialisation de la table des score + tables tampons. */

void init_tri ()
{
	int i;
	
	/* initialisation de la table des scores  zro 
	   (dim = nb_pop) */

	i = nb_pop_plus1 << 1;
	memset (sco,0,i);
	
	/* Valeur pour calcul du poucentage de l'tat de reflexion. */
	valpc = (float)100. / ((float) (nb_pop*(nb_pop - 1)));

	tri = 1;
}

//---------------------------------------------------------
/* Les scores tant calcules on peut trier les rseaux . */

void tri_decroissant ()
{
	 int i;
	 float * pt_TVC;
	 
	 /* A partir de la table des scores, on permute les rseaux.*/

	 for (i=1;i<nb_pop;i++)
	    {
			transvase_reseau (calcul_best(),i);
	    }

     /* On permute les 2 tables */

	 pt_TVC = TVC;
	 TVC = TVC2;
	 TVC2 = pt_TVC;
 
}

/*------------------------------------------------------------*/
/* Toutes les rseaux qui ont t choisi vont tre
   transfr dans la table TVC2.  */

void transvase_reseau (int i1,int j1)
{
	 long int indrep1, indrep2, nboct;
	 
	 /* on valorise les indices pour les tables TVC et TVC2. */

	 indrep1 = (((long)i1-(long)1) * (long)nb_connexion) + (long)1;
	 indrep2 = (((long)j1-(long)1) * (long)nb_connexion) + (long)1;
	 
	 /* On calcule le nombre d'octet d'un rseau. */
		   
	 nboct = taille_1res;
		  
	 /* on copie de la table TVC sur la table TVC2. */

	 memcpy (&TVC2[(long)indrep2],&TVC[(long)indrep1],(size_t)nboct);
}

//--------------------------------------------------
// Dterminer le rseau qui a le meilleur rsultat. 

int calcul_best ()
{
	int i, mj;

	mj = 1;
	for (i=1;i<nb_pop_plus1;i++)
	  {
	    if (sco [i] > sco [mj])
	       mj = i;
	  }
	sco [mj] = -10;
	return (mj);
}
