
#include <windows.h>  
#include "CrtCursr.h" 


#if defined (WIN32)
	#define IS_WIN32 TRUE
#else
	#define IS_WIN32 FALSE
#endif

#define IS_NT      IS_WIN32 && (BOOL)(GetVersion() < 0x80000000)
#define IS_WIN32S  IS_WIN32 && (BOOL)(!(IS_NT) && (LOBYTE(LOWORD(GetVersion()))<4))
#define IS_WIN95   (BOOL)(!(IS_NT) && !(IS_WIN32S)) && IS_WIN32

HINSTANCE hInst;   // current instance

LPCTSTR lpszAppName  = "MyApp";
LPCTSTR lpszTitle    = "My Application"; 

BOOL RegisterWin95( CONST WNDCLASS* lpwc );

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPTSTR lpCmdLine, int nCmdShow)
{
   MSG      msg;
   HWND     hWnd; 
   WNDCLASS wc;

   // Register the main application window class.
   //............................................
   wc.style         = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = (WNDPROC)WndProc;       
   wc.cbClsExtra    = 0;                      
   wc.cbWndExtra    = 0;                      
   wc.hInstance     = hInstance;              
   wc.hIcon         = LoadIcon( hInstance, lpszAppName ); 
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   wc.lpszMenuName  = lpszAppName;              
   wc.lpszClassName = lpszAppName;              

   if ( IS_WIN95 )
   {
      if ( !RegisterWin95( &wc ) )
         return( FALSE );
   }
   else if ( !RegisterClass( &wc ) )
      return( FALSE );

   hInst = hInstance; 

   // Create the main application window.
   //....................................
   hWnd = CreateWindow( lpszAppName, 
                        lpszTitle,    
                        WS_OVERLAPPEDWINDOW, 
                        CW_USEDEFAULT, 0, 
                        CW_USEDEFAULT, 0,  
                        NULL,              
                        NULL,              
                        hInstance,         
                        NULL               
                      );

   if ( !hWnd ) 
      return( FALSE );

   ShowWindow( hWnd, nCmdShow ); 
   UpdateWindow( hWnd );         

   while( GetMessage( &msg, NULL, 0, 0) )   
   {
      TranslateMessage( &msg ); 
      DispatchMessage( &msg );  
   }

   return( msg.wParam ); 
}


BOOL RegisterWin95( CONST WNDCLASS* lpwc )
{
   WNDCLASSEX wcex;

   wcex.style         = lpwc->style;
   wcex.lpfnWndProc   = lpwc->lpfnWndProc;
   wcex.cbClsExtra    = lpwc->cbClsExtra;
   wcex.cbWndExtra    = lpwc->cbWndExtra;
   wcex.hInstance     = lpwc->hInstance;
   wcex.hIcon         = lpwc->hIcon;
   wcex.hCursor       = lpwc->hCursor;
   wcex.hbrBackground = lpwc->hbrBackground;
   wcex.lpszMenuName  = lpwc->lpszMenuName;
   wcex.lpszClassName = lpwc->lpszClassName;

   // Added elements for Windows 95.
   //...............................
   wcex.cbSize = sizeof(WNDCLASSEX);
   wcex.hIconSm = LoadImage(wcex.hInstance, lpwc->lpszClassName, 
                            IMAGE_ICON, 16, 16,
                            LR_DEFAULTCOLOR );
			
   return RegisterClassEx( &wcex );
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
   static HCURSOR  hCursor = NULL;
   static int      nCursX, nCursY, nByteArea;
   static HBITMAP  hBM;
   static HDC      hDCBitmap;
   static HANDLE   hmemAND, hmemXOR;


   switch( uMsg )
   {
      case WM_CREATE:
           {
              HDC    hDC;
              LPTSTR lpAND, lpXOR;

              // Get the cursor size.
              //.....................
              nCursX = GetSystemMetrics( SM_CXCURSOR ); 
              nCursY = GetSystemMetrics( SM_CYCURSOR );

              // Create a memory DC and select a bitmap into it.
              //................................................   
              hBM = CreateBitmap( nCursX, nCursY, 1, 1, NULL );
              hDC = GetDC( hWnd );
              hDCBitmap = CreateCompatibleDC( hDC );
              SelectObject( hDCBitmap, hBM );
              ReleaseDC( hWnd, hDC );

              // Allocate memory for cursor masks.
              //..................................
              nByteArea = (nCursX/8) * nCursY;
              hmemAND = GlobalAlloc( GMEM_MOVEABLE, (DWORD)nByteArea );
              hmemXOR = GlobalAlloc( GMEM_MOVEABLE, (DWORD)nByteArea );

              // Lock memory for cursor masks.
              //..............................
              lpAND = GlobalLock( hmemAND );
              lpXOR = GlobalLock( hmemXOR );

              // Create a gray rectangle cursor.
              //................................
              SelectObject( hDCBitmap, GetStockObject( LTGRAY_BRUSH ) );
              PatBlt( hDCBitmap, 0, 0, nCursX, nCursY, PATCOPY );
              GetBitmapBits( hBM, (DWORD)nByteArea, lpAND );

              // Set XOR memory to all 0's.
              //.......................
              memset( lpXOR, 0, nByteArea );

              hCursor = CreateCursor( hInst, 0, 0, nCursX, 
                                      nCursY, lpAND, lpXOR );

              GlobalUnlock( hmemAND );
              GlobalUnlock( hmemXOR );
           }
           break;

      case WM_SETCURSOR :
              if ( hCursor )
                 SetCursor( hCursor );
              break;

      case WM_COMMAND :
              switch( LOWORD( wParam ) )
              {
                 case IDM_TEST :
                        {
                            LPTSTR lpAND = GlobalLock( hmemAND );
                            LPTSTR lpXOR = GlobalLock( hmemXOR );
                         
                            // Clear current cursor and delete it.
                            //....................................
                            SetCursor( NULL );
                            DestroyCursor( hCursor );

                            // Add an X to the cursor bitmap.
                            //...............................
                            SelectObject( hDCBitmap,
                                          GetStockObject( BLACK_PEN ) );
                            MoveToEx( hDCBitmap, 0, 0, NULL );
                            LineTo( hDCBitmap, nCursX, nCursY );
                            MoveToEx( hDCBitmap, 0, nCursY, NULL );
                            LineTo( hDCBitmap, nCursX, 0 );
                            GetBitmapBits( hBM, (DWORD)nByteArea, lpAND );
                       
                            hCursor = CreateCursor( hInst, 0, 0, nCursX, 
                                                    nCursY, lpAND, lpXOR );

                            SetCursor( hCursor );

                            GlobalUnlock( hmemAND );
                            GlobalUnlock( hmemXOR );
                        }
                        break;

                 case IDM_ABOUT :
                        DialogBox( hInst, "AboutBox", hWnd, (DLGPROC)About );
                        break;

                 case IDM_EXIT :
                        DestroyWindow( hWnd );
                        break;
              }
              break;
      
      case WM_DESTROY :
              DestroyCursor( hCursor );
              DeleteObject( hBM );
              DeleteDC( hDCBitmap );
              GlobalFree( hmemAND );
              GlobalFree( hmemXOR );  
              PostQuitMessage(0);
              break;

      default :
            return( DefWindowProc( hWnd, uMsg, wParam, lParam ) );
   }

   return( 0L );
}


LRESULT CALLBACK About( HWND hDlg,           
                        UINT message,        
                        WPARAM wParam,       
                        LPARAM lParam)
{
   switch (message) 
   {
       case WM_INITDIALOG: 
               return (TRUE);

       case WM_COMMAND:                              
               if (   LOWORD(wParam) == IDOK         
                   || LOWORD(wParam) == IDCANCEL)    
               {
                       EndDialog(hDlg, TRUE);        
                       return (TRUE);
               }
               break;
   }

   return (FALSE); 
}
