#include <graph.h>
#include <stdio.h>
#include <math.h>
#include <io.h>
#include <share.h>
#include <fcntl.h>
#include <memory.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <sys\timeb.h>
#include <conio.h>
#include <malloc.h>
#include <float.h>

/* definition des couleurs */

#define  noir	 0
#define  bleu	 1
#define  cyan	 3
#define  vert	 2
#define  rouge	 4
#define  magenta 5
#define  blanc	 7
#define  brun	 6
#define  gris	 8
#define  bleuclair 9
#define  vertclair 10
#define  cyanclair 11
#define  rougeclair 12
#define  magentaclair 13
#define  jaune	 14
#define  blancclair 15

/*   dictionnaire de donne

    - TVC = table des valeurs des connexions (pour toute la population de rseaux)
    - TVC2 = 2me table des valeurs des connexions (servant pour la reproduction)
    - TVN = table des valeurs des neurones (pour la dcision)
    - nb_pop = nombre de rseau mis en concurrence (ou population de rseaux)
    - nb_couche1 = nombre de neurones sur la couche 1
    - nb_couche2 = nombre de neurones sur la couche 2
    - nb_couche3 = nombre de neurones sur la couche 3
    - nb_couche4 = nombre de neurones sur la couche 4
    - nb_con12	 = nombre de connexions entre couche 1 et 2
    - nb_con123  = nombre de connexions entre couche 1, 2 et 3
    - nb_connexion = nombre total de connexion pour 1 rseau (couches 1, 2, 3 et 4)
    - nb_neurone   = nombre total de neurone pour 1 rseau (couches 1, 2, 3 et 4)
      (= couche1 + couche2 + couche3 + couche4)
    - taille_TVN = taille en octet de la table des valeurs des neurones
		     (pour 1 rseaux) = (nb_neurone * 4) + 4
    - taille d'un rseau = nb_connexion * 2;
    - taille_rseaux = taille en octet de la table des valeurs des connexions
		     (pour tous les rseaux en comptition)
		    = (nb_connexion * 2 * nb_pop) + 2
    - gene = nombre de manches effectues pour ce groupe de rseaux (=gnration)
    - score1 = score lors d'un match du joueur n1 (joueur de gauche)
    - score2 = score lors d'un match du joueur n2 (joueur de droite)
    - sco = table des scores pour chacun des rseaux pour une manche (dim =nb_pop)
    - scortot = score total de tous les rseaux pour une manche
    - repro = table des numros de rseaux nouvellement reproduits (dim =nb_pop)
    - finmatch = boolen sur la fin d'un match
    - nb_coup = nombre de coup jou au cours d'une partie
    - coup1 = coup jou par le joueur 1
    - coup2 = coup jou par le joueur 2
    - mj = indice du rseau dont le score a t le meilleur pour la manche
    - damier = damier d'othello (64 en char)
    - coupos = tables des coups possibles (64 en char)
    - car_aff = rponse  la question de l'affichage */


/* pour rseaux de neurones */

/* si la population passe  plus de 40 rseaux, il faudra changer les dimensions
   des tables sco, repro et roue */

static int nb_pop = 36;
static int nb_couche1 = 129;
static int nb_couche2 = 20;
static int nb_couche3 = 20;
static int nb_couche4 = 64;
static int nb_couche12;
static int nb_couche123;
static int nb_neurone;
static int nb_con12;
static int nb_con123;
static int nb_connexion;
static long int taille_TVN;
static long int taille_1res;
static long int taille_reseaux;
static float *TVN;
static int *TVC;
static int *TVC2;

/* variables jeux et variables divers */

static int a1;
static int a2;
static int score1;
static int score2;
static int gene;
static int scortot;
static int sco[40];
static int repro[40];

/* variables othello */

static char damier [65];
static char coupos [65];
static char indjo;
static char car_aff;

/* divers  */
/* indicateur sur le remplissage du fichier les "meilleur". */
static int a_ecraser;
/* handle du fichier "meilleur" */
static int h_meil;

/*----------------------------------------*/
/*	programme Othello		  */
/*----------------------------------------*/

void main (void)
{
	  int i,mj;
	  int nb_sauv = 0;
	  char nb;

	  /* La fonction alatoire est dfinie avec l'horloge du micro. */

	  struct timeb temps;
	  ftime (&temps);
	  srand (temps.millitm);

	  /* Initialisation des cumuls de couches. */

	  nb_couche12 = nb_couche1 + nb_couche2;
	  nb_couche123 = nb_couche12 + nb_couche3;

	  /* Nb de neurone pour 1 rseau.  */

	  nb_neurone = nb_couche123 + nb_couche4;

	  /* Nb_connexion pour 1 rseau. */

	  nb_connexion = (nb_couche1 * nb_couche2) + (nb_couche2 * nb_couche3) +(nb_couche3 * nb_couche4);

	  /* Nb de connexion entre couche 1 et 2. */

	  nb_con12 = (nb_couche1 * nb_couche2);

	  /* Nb de connexion entre couche 1, 2 et 3. */

	  nb_con123 = (nb_couche1 * nb_couche2) + (nb_couche2 * nb_couche3);

	  /* Taille de la table des neurones (TVN). */

	  taille_TVN = (long)(((long)nb_neurone * (long)4) +(long)4);

	  /* Taille d'un rseau. */

	  taille_1res = ((long)nb_connexion * (long)2);

	  /* La taille de la table des connexions de tous les rseaux
	     de neurones. (= 36 rseaux) */

	  taille_reseaux = (long) ((long)(taille_1res * (long)nb_pop) + (long)2);

	   /* Affichage de la 1re page de prsentation. */

	  presentation ();

	  /* Initialisation des tables TVC, TVC2 et TVN. */

	  init();

	  /* Possibilit de dmarrer l'apprentissage  partir d'une sauvegarde
	     ou bien en initialisant alatoirement tous les rseaux. */

	   if (ques_init() == 'N')
	     {
	       initalea();
	     }
	    else
	     {
	       restitution ();
	     }

	  /* Ouverture du fichier contenant les rseaux ayant obtenus
	     les meilleurs rsultats au cours de la slection. */

	  ouvrir_meilleur();

	  /* Question sur l'affichage. */

	  car_aff = ques_naff();

	  /* Initialisation du caractre clavier. */

	  nb = ' ';

/* boucle d'apprentissage */

	do
	  {

	  /* Incrmentation du nombre de gnration. */

	  gene++;

	  /* Pour chaque gnration une manche est ralise, soit 90 parties
	     pour 36 rseaux en 6 poules de 6 rseaux. */

	  manche();

	  /* Calcul du score total tous rseaux confondus + mmorisation
	     du rseau le meilleur pour cette manche (pour la slection
	     dans le fichier "meilleur"). */

	  mj = 1;
	  scortot = 0;
	  for (i=1;i<nb_pop + 1;i++)
	  {
	    scortot = scortot + sco [i];
	    if (sco [i] > sco [mj])
	       mj = i;
	  }

	  /* Affichage du rseau ayant obtenu le meilleur score. */

	  aff_best(mj);

	  /* On constitue un fichier des rseaux ayant obtenus les meilleurs
	     rsultats (>=17 pour tre slectionn). */

	  if (sco[mj] > 16)
	    meilleur(mj);

	  /* Toutes les 200 gnrations on sauvegarde l'tat des rseaux.
	     A raison de 10 secondes par gnration, cela fait environ
	     une sauvegarde toutes les demi-heures. */

	  nb_sauv++;
	  if (nb_sauv > 199)
	     {
		sauvres();
		nb_sauv = 0;
	     }

	  /* Affichage du score des rseaux pour la manche. */

	  if (kbhit())
	     aff_scores();

	  /* Reproduction des rseaux en fonction des scores obtenus.
	     (cf Algorithme gntique) */

	  reproduction();

	  /* Mlange de valeurs de connexions entre rseaux issus
	     de la reproduction. (cf Algorithme gntique) */

	  crossover();

	  /* Mutation alatoire de connexions. (cf Algorithme gntique) */

	  mutation();

	  /* Test donnant la possibilit de stopper la boucle
	     d'apprentissage. */

	  if (kbhit())
		    {
			getch();
			_settextposition(30,1);
			_outtext (" Voulez-vous stopper le programme (O/N) ? ");
			do {
			nb = getch ();
			} while (nb != 'O' && nb != 'o' && nb != 'N' && nb != 'n');
		    }
	  }
	  while (nb != 'O' && nb != 'o');

/* fin boucle d'apprentissage */

	  /* Sauvegarde des rseaux sur fichier. */

	  sauvres();

	  /* Fermeture fichier "meilleur". */

	  fermer_meilleur();

	  /* Libration mmoire. */

	  libe_memoire();

}

/*-------------------------------------------------------------------------*/
/* Propagation des signaux dans le rseau. Chaque neurone envoit un signal
    0 ou 1. Celui-ci est envoy  la couche de neurone immdiatement
   infrieure par les connexions. Ces dernires multiplient le signal
   en positif ou en ngatif (augmentation ou inhibition du signal). La couche
   rceptrice fait le total des signaux reus pour chaque neurone, lesquels
   ralisent le seuillage. C'est  dire que le neurone envoit un 1
   si cette somme est positive sinon c'est un 0. Pour le jeu d'othello,
   il n'y pas de seuillage pour la couche de sortie (couche 4), car la
   dcision de jouer sur une case est prise en fonction du total du signal
   reu. La case dont le signal est le plus lv sera la dcision du rseau
   ( la condition que le jeu autorise ce coup). */

propa_avant (num)

	  /* num = numro du rseau sollicit (entre 1 et nb_pop) */
	  int num;

	  {

	  /* indice de la table des connexions */
	  int indnum;

	  /* indice de la table des neurones */
	  int indnjo;

	  float k,val_connexion;
	  int i,j,l;

	  indnum = (num-1)*nb_connexion;

	  /* propagation couche 1 vers couche 2 */

	  for (i=1; i < nb_couche1 + 1; i++)
		{
		if ( TVN [i] != 0)
		  {
		  for (j=1; j < nb_couche2 + 1;j++)
		    {
			l = j + ((i - 1) * nb_couche2);
			val_connexion = (float) ( (float) (TVC[indnum+l]) / (float)16384);
			k = TVN [i] * val_connexion;
			TVN [nb_couche1+j] = TVN [nb_couche1+j] + k;
		    }
		  }
		}

	  /* seuillage de la couche 2 */

	  for (i = nb_couche1 + 1; i < nb_couche12 + 1;i++)
		    {
			if (TVN[i] > 0)
			   TVN [i] = 1;
			  else
			   TVN [i] = 0;
		    }

	  /* propagation couche 2 vers couche 3 */

	  for (i = nb_couche1 + 1; i < nb_couche12 + 1; i++)
		{
		if ( TVN [i] != 0)
		  {
		  for (j=1;j< nb_couche3 + 1;j++)
		    {
			l = j + ((i - nb_couche1 - 1) * nb_couche3) + nb_con12;
			val_connexion = (float) ( (float) (TVC[indnum+l]) / (float)16384);
			k = TVN [i] * val_connexion;
			TVN [nb_couche12+j] = TVN [nb_couche12+j] + k;
		    }
		  }
		}

	  /* seuillage de la couche 3 */

	  for (i = nb_couche12 + 1;i < nb_couche123 + 1;i++)
		    {
			if (TVN[i] > 0)
			   TVN [i] = 1;
			  else
			   TVN [i] = 0;
		    }

	  /* propagation couche 3 vers couche 4 */

	  for (i = nb_couche12 + 1; i < nb_couche123 + 1; i++)
		{
		if ( TVN [i] != 0)
		  {
		  for (j = 1;j < nb_couche4 + 1;j++)
		    {
			l = j + ((i - nb_couche12 - 1) * nb_couche4) + nb_con123;
			val_connexion = (float) ( (float) (TVC[indnum+l]) / (float)16384);
			k = TVN [i] * val_connexion;
			TVN [nb_couche123+j] = TVN [nb_couche123+j] + k;
		    }
		  }
		}

	  /* seuillage de la couche 4. Pour le jeu d'othello
	  il n'est pas fait. */


	}

/*------------------------------------------------------------------*/
/* Une manche rassemble toutes les parties. Pour les rseaux normaux (*)
   on organise la manche en 6 poules de 6 rseaux. Dans une poule
   tous les rseaux jouent entre eux. (* par opposition aux "meilleur")
   Ce qui fait 15 parties * 6 poules, soient 90 parties au total. */

manche()
{
	  int i,j,k,l,p;

	  /* Initialisation de la table des scores  zro (dim = nb_pop).
	     Les matchs se font en series de 6 poules de 6 rseaux,
	     pour 36 rseaux en comptition. (si nb_pop = 36) */

	  i = (nb_pop + 1)*2;
	  memset (sco,0,(size_t)i);

	  /* indice nombre de poules  6. */

	  p = 6;

	  for (k =1; k < p+1; k++)
	    {
	      l = k * p;
	      for (i = l - p + 1; i < l; i++)
		{
			for (j = i+1; j < l+1;j++)
			{
				match(i,j);
			}
		}
	    }
}

/*----------------------------------------*/
/*     Un match = une partie d'Othello.   */

match(int j1,int j2)
       {
	int j,i,alea;

	/* initialisation des variables du jeu */

	initdamier();

	/* Si un score a t valoris alors on affiche le vainqueur.
	   Si c'est en fait le premier match, on ne peut pas afficher
	   le vainqueur du match prcdent. */

	if (score1 != 0 || score2 != 0)
	   aff_vainc();

	/* initialisation des scores */

	score1 = 0;
	score2 = 0;

	/* Tirage au sort afin de dterminer de quel ct
	   vont jouer les rseaux. */

	alea = rand ();
	if (alea > 16383)
	   {
	    a1 = j1;
	    a2 = j2;
	   }
	  else
	   {
	    a1 = j2;
	    a2 = j1;
	   }

	/* On affiche le duel en cours. */

	aff_duel(a1,a2);

	/* Partie d'Othello. */

	partie();

	/* Calcul des pions afin de dterminer le vainqueur et le score. */

	calcul_score();

	/* Cumul des scores de la partie afin d'avoir un cumul pour
	   la manche pour chaque rseau. */

	sco [a1] = sco [a1] + score1;
	sco [a2] = sco [a2] + score2;
}

/*----------------------------------------*/
/*     La partie d'othello s'effectue.	  */

partie()
{
	int finmatch;
	int coup1,coup2,nb_coup;

	/* La boucle s'effectue tant que le match n'est pas termin. */

	nb_coup = 0;
	finmatch = 0;

	while (finmatch == 0)
	{

	/* joueur 1 */

	indjo = 1;

	/* On dtermine les donnes en entre du rseau pour le joueur 1. */

	vision();

	/* Propagation des signaux pour le joueur 1 et pour le rseau a1. */

	propa_avant (a1);

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup1 = calcul_coup();

	if (coup1 != 0)
	    {
		nb_coup++;

		/* On applique la dcision du rseau sur le damier. */

		jouer_coup(coup1);
	    }
     /*	getch(); */
	/* joueur 2 */

	indjo = 2;

	/* On dtermine les donnes en entre du rseau pour le joueur 2. */

	vision();

	/* Propagation des signaux pour le joueur 2 et pour le rseau a2. */

	propa_avant (a2);

	/* On calcul, en fonction des rponses fournies par le rseau,
	   le coup qui va tre jouer. Lorsque la rponse est zro, le rseau
	   doit passer son tour. */

	coup2 = calcul_coup();

	if (coup2 != 0)
	    {
		nb_coup++;

		/* On applique la dcision du rseau sur le damier. */

		jouer_coup(coup2);
	    }
    /*	getch();  */
	/* Ne pas oublier le cas spcifique o les deux joueurs
	   doivent passer leur tour. Dans ce cas la partie se termine sans
	   que les 60 coups aient t jous. */

	if ((coup1 == 0 && coup2 == 0) || (nb_coup == 60))
	    finmatch = 1;

	}
}
/*----------------------------------------*/
/* On regarde les valeurs qu'ont prises les neurones en sortie du rseau.
   On consulte le damier pour voir quel sont les coups possibles.
   Parmis ces coups possibles on prend la rponse du rseau dont la valeur du
   neurone est la plus leve. */

int calcul_coup()
{
    int indneu;
    float falea;
    int i,j;
    float best_val = - FLT_MAX;
    int egalite [60];

    /* initialisation du tableau des galits des rponses */

    memset (egalite,0,(size_t)100);

    /* initialisation de la table des coups possibles */

    memset (coupos,0,(size_t)65);

    /* On regarde le damier d'othello et on ressence tous les coups possibles.
       Ceux-ci sont mmoriss dans la table des coups possibles. */

    calcul_coupos();

    /* On appareil les rponses du rseau (neurones de la couche de sortie 162-225)
       avec la tables des coups possibles. On retient la rponse qui a eu
       le neurone de sortie dont la valeur est la plus lve parmis les coups
       possibles.
       En d'galit de plusieurs rponses, celles-ci seront
       dsignes au sort.*/

    j = 0;

    for (i=1;i<65;i++)
	{
	    indneu = i + nb_couche123;
	    if (TVN [indneu] >= best_val && coupos [i] == 1)
		{
		     if (best_val == TVN [indneu])
			{
			 j++;
			 egalite [j] = i;
			 egalite [j+1] = 0;
			}
		     else
			{
			 j = 1;
			 egalite [j] = i;
			 egalite [2] = 0;
			 best_val = TVN[indneu];
			}
		}
	}

    /* Si dans la table galit il n'y a qu'un seul coup (indice 2  zro)
       alors le coup choisi sera la valeur de table galit indice 1.
       Sinon il faut faire un tirage alatoire entre les coups choisis.
       Il est possible qu'aucun coup ne soit possible auxquel cas on renvoie
       un zro. */

    if (egalite [1] == 0)
	return (0);
    else
    {
    if (egalite [2] == 0)
	return (egalite [1]);
    else
	{
	    for (i=3;egalite [i] != 0;i++);
	    i--;
	    falea =(float)((float)(rand()+1)/(float)32768.)*(float)i;
	    i = (int) (ceil ((double)falea));
	    return (egalite [i]);
	}
    }
}

/* ------------------------------------------------------------------------*/
/* on parcours toutes les cases vides du damier afin de dterminer quelles
   sont les cases sur lesquelles le rseau pourra jouer */

calcul_coupos ()
{
    int x,y;
    int casdam;

    for (x=1;x<9;x++)
	{
	    for (y=1;y<9;y++)
		{
		    casdam = ((y-1)*8)+x;
		    if (damier[casdam] == 0)
			{
			    coupos [casdam] = 1;
			    if (!jouable(0,1,x,y))
			      {
			      if (!jouable(1,0,x,y))
				{
				if (!jouable(1,1,x,y))
				  {
				  if (!jouable(-1,-1,x,y))
				    {
				    if (!jouable(-1,0,x,y))
				      {
				      if (!jouable(0,-1,x,y))
					{
					if (!jouable(1,-1,x,y))
					  {
					  if (!jouable(-1,1,x,y))
					    {
						coupos [casdam] = 0;
			      }	} } } } } } }
			}
		    else
			coupos [casdam] = 0;
		}  /* fin de la boucle sur les y */
	}   /* fin de la boucle sur les x */
}

/*-----------------------------------------------------------------------*/
/* Pour chaque case vide on regarde si l'on peut jouer dessus.
   Chaque ligne est inspecte. */

int jouable (int x0,int y0,int x,int y)
{
    int acote,enbout;
    int xd,yd;

    /* On regarde  ct de la case vide. Si il y a prsence
       d'un pion adverse alors on cherche sur cette ligne s'il existe un pion
       ami. */

    xd = x+x0;
    yd = y+y0;

    if (xd > 0 && xd < 9 && yd > 0 && yd < 9)
	{
	    acote = ((yd-1)*8)+xd;
	    if (damier [acote] != indjo && damier[acote] != 0)
		{
		    x = xd + x0;
		    y = yd + y0;
		    enbout = ((y - 1) * 8) + x;

		    while ((x > 0 && x < 9 && y > 0 && y < 9) &&
			   damier [enbout] != indjo	      &&
			   damier [enbout] != 0)
			{
			    y = y + y0;
			    x = x + x0;
			    enbout = ((y - 1) * 8) + x;
			}

		    if (damier [enbout] == indjo &&
			x > 0 && x < 9 && y > 0 && y < 9)
			    return (1);
		    else
			    return (0);
		}
	    else
		return (0);
	}
    else
	return(0);
}

/*--------------------------------------------------*/
/* on applique la dcision du rseau sur le damier. */

jouer_coup (int coup)
{
    int x,y;

    /* calcul des coordonnes du coup sur le damier */

    y = (int)ceil((double)((double)coup / 8.));
    x = coup - 8*(y-1);

    damier [coup] = indjo;

    /* ligne en haut */
    retourner_ligne (0,-1,x,y);

    /* ligne en bas */
    retourner_ligne (0,1,x,y);

    /* ligne  droite */
    retourner_ligne (1,0,x,y);

    /* ligne  gauche */
    retourner_ligne (-1,0,x,y);

    /* ligne en haut  gauche */
    retourner_ligne (-1,-1,x,y);

    /* ligne en bas  droite */
    retourner_ligne (1,1,x,y);

    /* ligne en haut  droite */
    retourner_ligne (1,-1,x,y);

    /* ligne en bas  gauche */
    retourner_ligne (-1,1,x,y);

    /* affichage des rsultats sur le damier de l'cran */

    if (car_aff != 'N')
       affiche_damier ();

}

/*--------------------------------------------------------------------------*/
/*     On regarde  ct de la case joue. Si il y a prsence
       d'un pion adverse alors on cherche sur cette ligne s'il existe un pion
       ami. Si tel est le cas les pions ennemis situs prcdemment deviennent
       amis. (cf rgles du jeu d'othello).     */

retourner_ligne (int x0,int y0,int x, int y)
{

    int acote,enbout;
    int xd,yd;

    xd = x+x0;
    yd = y+y0;

    if (xd > 0 && xd < 9 && yd > 0 && yd < 9)
	{
	    acote = ((yd-1)*8)+xd;
	    if (damier [acote] != indjo && damier[acote] != 0)
		{
		    x = xd+x0;
		    y = yd+y0;
		    enbout = ((y - 1) * 8) + x;

		    while ((x > 0 && x < 9 && y > 0 && y < 9) &&
			   damier [enbout] != indjo	      &&
			   damier [enbout] != 0)
			{
			    y = y + y0;
			    x = x + x0;
			    enbout = ((y - 1) * 8) + x;
			}

		    if (damier [enbout] == indjo &&
			x > 0 && x < 9 && y > 0 && y < 9)
			{
			    x = xd;
			    y = yd;
			    enbout = acote;
			    do
				{
				   damier [enbout] = indjo;
				   y = y + y0;
				   x = x + x0;
				   enbout = ((y - 1) * 8) + x;
				}
			    while (damier [enbout] != indjo);
			}
		}
	}
}

/*------------------------------------------------------------*/
/*  partir du damier on calcule
   les donnes qui iront dans les neurones entres du rseau. */

vision()
       {

	int indneu,i;

	/* initialisation TVN */

	for (i =130;i<234;i++)
	    TVN[i] = 0;

	/* on parcourt le damier et on valorise les neurones
	   --> 2 neurones par cases, 0 = case vide, 1 = blanc, 2 = noir. */

	for (i=1;i < 65;i++)
	    {
	    indneu = i*2;
	    if (damier [i] == 0)
		{
		    TVN [indneu-1] = 0;
		    TVN [indneu] = 0;
		}
	      else
		{
		  if (damier [i] == 1)
		    {
			if (indjo == 1)
			    {
				TVN [indneu-1] = 0;
				TVN [indneu] = 1;
			    }
			else
			    {
				TVN [indneu-1] = 1;
				TVN [indneu] = 0;
			    }
		    }
		else
		    {
			if (indjo == 1)
			    {
				TVN [indneu-1] = 1;
				TVN [indneu] = 0;
			    }
			else
			    {
				TVN [indneu-1] = 0;
				TVN [indneu] = 1;
			    }
		    }
		}
	    }

    /* on valorise le 129me neurone qui correspond  la couleur avec
       laquelle le rseau joue */

    if (indjo == 1)
	TVN [129] = 0;
    else
	TVN [129] = 1;

}

/*----------------------------------------*/
/* La phase reproduction consiste  un tirage alatoire
   (pondr  partir des scores obtenus) de la nouvelle gnration de
   rseaux. */

reproduction()
{
	  float alea,tempo,arrond,val1,val2;
	  unsigned int roue[40];
	  int i,j;
	  char chain [40] = "                                        ";

	  /* la table roue se prsente comme une roue de la chance
	     ou chaque rseaux y est reprsent par un quartier plus ou moins
	     grand selon le score qu'il a fait durant la manche.
	     Dans chaque poste de la roue on y trouve le cumul des scores */

	  i = (nb_pop + 1)*2;
	  memset (roue,0,(size_t)i);

	  /* on considre que la roue fait 32767 units,
	     donc le score total de la manche doit tre reprsent sur
	     cette roue. */

	  tempo = (float)scortot;
	  tempo = (float) ((float)32767 / tempo);

	  /* pour chaque poste de la roue on calcule le score du rseau, plus
	     celui des rseaux des postes prcdents. Calculer la dernire roue
	     ne sert  rien. */

	  for (i=1;i<nb_pop;i++)
	    {
		val2 = (float)sco [i] * tempo;
		val1 = (float)ceil(val2);

		/* gestion de l'arrondi */

		arrond = val1 - val2;
		if (arrond < 0.5)
		   roue [i] = roue [i-1] + (int)val1;
		  else
		   roue [i] = roue [i-1] + (int)val2;
	    }

	  /* tirage alatoire sur la roue */

	  for (i=1;i<nb_pop + 1;i++)
	    {
		alea = rand ();
		j = 0;
		do
		  {
		    j++;
		  }
		while (alea > roue[j] && j < nb_pop);
		repro [i] = j;
	    }

	  /* Affichage du rsultat du tirage lorsque on a tap
	     sur le clavier. */

	  if (kbhit())
		    {
			for (i=1;i<nb_pop + 1;i=i+2)
			{
			j = (i/2)+1;
			_settextposition(j,46);
			sprintf (chain,"Repro n %d = %d Repro n %d = %d ",i,repro[i],i+1,repro[i+1]);
			_outtext(chain);
			}
		    }

	  /* On applique les rsultats de la table de reproduction sur
	     la table des connexions TVC. */

	  repro_TVC ();

}

/*----------------------------------------*/
/* La table TVC doit en sortie de cette fonction avoir tous les rseaux en place
   par rapport  la table de reproduction. */

repro_TVC()
{
	 int i,j;
	 int z_tampon = 0;
	 char bool [40];
	 int transpo [40];

	 /* initialisation de bool et de transpo */

	 memset (bool,0,(size_t)37);

	 for (i=1;i<nb_pop+1;i++)
	    {
		transpo [i] = i;
	    }

	 /* A partir de la table des reproductions, on permute les rseaux.*/

	 for (i=1;i<nb_pop + 1;i++)
	    {

	       if (bool[i] == 0 && repro [i] != i)
		{

		    /* on transvase le rseau indic par i dans la zone TVC2 */

		    transvase_reseau (i,transpo[repro[i]]);
		    z_tampon = i;
		    transpo[repro[i]] = i;
		    bool [i] = 1;

		    while (z_tampon != 0 && i < nb_pop)
			{

			    for (j=i+1;j<nb_pop &&
				(bool[j] != 0 || z_tampon != repro[j]);j++);

			    if (bool[j] == 0 && z_tampon == repro [j])
			      {
				transvase_tampon(j);
				z_tampon = j;
				transpo [repro[j]] = j;
				bool [j] = 1;
			      }
			    else
				z_tampon = 0;
			}
		}
	       else
		{
		    if (bool[i] == 0)
			bool [i] = 1;
		}
	    }
}

/*------------------------------------------------------------*/
/* Le rseau  permuter est d'abord stock dans la table TVC2 */

transvase_reseau (int i,int j)
{
	       long int indrep1, indrep2;

	       /* on valorise l'indice de la table TVC indice par i
	       pour indrep1 et par j pour indrep2 */

	       indrep1 = (((long)i-(long)1) * (long)nb_connexion) + (long)1;
	       indrep2 = (((long)j-(long)1) * (long)nb_connexion) + (long)1;

	       memcpy (&TVC2[(long)1],&TVC[(long)indrep1],(size_t)taille_1res);
	       memcpy (&TVC[(long)indrep1],&TVC[(long)indrep2],(size_t)taille_1res);

}

/*-----------------------------------------------------------------*/
/* on stock le rseau dans la TVC2 n 2, puis celui de la TVC2 n1 dans
 la TVC de j et enfin le TVC2 de 2 dans TVC2 de 1. */

transvase_tampon (int j)
{
	       int indi2;
	       long int indrep1;

	       /* indice de TVC2 pointant sur le 2me rseau de cette table */

	       indi2 = (long)nb_connexion + (long)1;

	       /* on valorise l'indice j pour la table TVC */

	       indrep1 = (((long)j-(long)1) * (long)nb_connexion) + (long)1;

	       memcpy (&TVC2[(long)indi2],&TVC[(long)indrep1],(size_t)taille_1res);
	       memcpy (&TVC[(long)indrep1],&TVC2[(long)1],(size_t)taille_1res);
	       memcpy (&TVC2[(long)1],&TVC2[(long)indi2],(size_t)taille_1res);

}

/*-----------------------------------------------------------------------*/
/* Aprs la reproduction,  partir de la table TVC, on va prendre des postes
   de cette table deux  deux et pour chacun des rseaux dsigns par
   ces postes on va intervetir certaines de leurs connexions, cela s'apparante
   au croisement de gnes lors de la reproduction dans le monde vivant.
   L'endroit, o va se faire le croisement, est dsign alatoirement. */

crossover()
{
	 int i,nboct1;
	 int aleaint;
	 long int indrep1,indrep2;
	 float falea;
	 float alea;

	 for (i=1;i<nb_pop+1;i=i+2)
	    {

	       /* on valorise les indices de la table TVC indice par le
		  rsultat de la reproduction */

	       indrep1 = (((long)i-(long)1) * (long)nb_connexion) + (long)1;
	       /* i + 1 - 1 = i */
	       indrep2 = ((long)i * (long)nb_connexion) + (long)1;

	       /* tirage alatoire de l'endroit o l'on fait la coupe du
		  crossover, le chiffre obtenu est compris
		  entre 1 et nb_connexion */

	       alea = (float)rand ();
	       alea = alea / (float)32767;
	       falea = (float)(ceil (alea * (float)nb_connexion));
	       aleaint = (int)falea;

	       /* on calcule le nombre d'octets que reprsente la partie du
		  rseau qui se trouve avant la coupe. */

	       nboct1 = (int)aleaint * (int)2;

	       /* on copie de la table TVC, indice par le 1er poste
		  du couple actuellement trait, la partie situe
		  avant la coupe sur la table TVC du 2me poste
		  du couple. La zone tampon est la table TVC2. */

	       memcpy (&TVC2[(long)1],&TVC[(long)indrep1],(size_t)nboct1);
	       memcpy (&TVC[(long)indrep1],&TVC[(long)indrep2],(size_t)nboct1);
	       memcpy (&TVC[(long)indrep2],&TVC2[(long)1],(size_t)nboct1);

	    }

}

/*----------------------------------------*/
/* pour chacun des rseaux on choisit une connexion au hasard pour
   laquelle on change sa valeur */

mutation ()
{
	 int i,k,j,ecart;
	 long int aleaint1,ind;
	 float alea,arrond,val1,val2;

	    /* boucle mutation pour chaque rseau */

	    for (i=1;i<nb_pop + 1;i++)
	    {

	       /* diminution des mutations */

	       alea = rand ();
	       if (alea > 25000)
		{
	       /* tirage alatoire de 30 connexions  modifier (avec arrondi) */

	       for (j=1;j<31;j++)
		{
			alea = (float)rand ();
			val2 = (alea / 32767.) * (float)nb_connexion;
			val1 = ceil (val2);
			arrond = val1 - val2;
			if (arrond < 0.5)
			   aleaint1 = (int)val1;
			  else
			   aleaint1 = (int)val2;

		/* tirage alatoire de la nouvelle valeur de la connexion,
		  cette valeur est comprise entre 0 et 32767. */

			alea = rand () - 16384;
			ind = ((long)(i-1)*(long)nb_connexion)+(long)aleaint1;
			TVC[ind]=(int)alea;
		 }
	      }
	    }

}

/*---------------------*/
/* Liberation mmoire. */

libe_memoire ()
{

    /* Libration de la mmoire rserve par les instructions halloc. */

	   free (TVC);
	   free (TVC2);
	   free (TVN);

}

/*----------------------------------------------------------------------*/
/*	Prsentation de la premire page   */

presentation()
{
	  char chain [80];
	  memset (chain,' ',(size_t)80);
	  _setvideomode(_TEXTC80);
	  _setbkcolor(bleu);
	  _clearscreen(_GCLEARSCREEN);
	  _setbkcolor(noir);
	  _settextcolor(blanc);
	  _settextposition(2,10);
	  _outtext(" Jeu d'Othello avec des rseaux de neurone en concurrence ");
	  _settextposition(24,1);
	  sprintf (chain,"1er couche = %d, 2me = %d, 3me = %d, 4me = %d \n",nb_couche1,nb_couche2,nb_couche3,nb_couche4);
	  _outtext(chain);
	  _settextposition(22,1);
	  sprintf (chain,"Nb rseaux en concurrence = %d, taille d'un rseau %ld \n",nb_pop,taille_1res);
	  _outtext(chain);
}

/*----------------------------------------------------------------------*/
/* allocation et initialisation des tables de connexions et de neurones */

init()
{
	  int i;
	  long nbre_element;
	  long nb_conTVC2;
	  char chain [80];
	  memset (chain,' ',(size_t)80);

	  /* Allocation de la table TVC2.
	     Elle contient 2 zones rseaux tampons. Elle sert lors
	     de la reproduction et du crossover pour les copies de
	     rseaux. */

	  nb_conTVC2 = ((long)nb_connexion* (long)2) + (long)1;

	  if ((TVC2 = malloc(nb_conTVC2,(size_t)2)) == NULL)
	      {
	       printf ("Erreur lors de l'allocation mmoire TVC2");
	       exit ();
	      }

	  /* Allocation de la table des connexions de tous les rseaux */

	  nbre_element = ((long) nb_connexion * (long) nb_pop) + (long)1;

	  if ((TVC = malloc(nbre_element,(size_t)2)) == NULL)
	      {
	       printf ("Erreur lors de l'allocation mmoire TVC");
	       exit ();
	      }

	  /* Allocation de la table qui contient la valeur des neurones
	     pendant les calculs.  */

	  nbre_element = (long) nb_neurone + (long)1;

	  if ((TVN  = malloc(nbre_element,(size_t)4)) == NULL)
	      {
	       printf ("Erreur lors de l'allocation mmoire TVN");
	       exit ();
	      }

	  /* Affichage caractristique du rseau */

	  _settextposition(23,1);
	  sprintf (chain,"Nb neurones = %d, nb connexion = %d, nb octet total = %ld\n",nb_neurone,nb_connexion,taille_reseaux);
	  _outtext(chain);

	  /* initialisation de la table des scores  zro (dim = nb_pop) */

	  i = (nb_pop + 1)*2;
	  memset (sco,0,(size_t)i);

}

/*--------------------------------------------*/
/* sauvegarde de tous les rseaux sur fichier */

sauvres ()
{
	   int handle,i;
	   long indtab,h;
	   unsigned int taille_int;

	   /* ouverture du fichier */

	   if ((handle= open ("othel.don", O_WRONLY | O_CREAT
		   | O_BINARY, S_IREAD | S_IWRITE)) == -1)
		{
		 printf ("Ouverture fichier sauvegarde ne se fait pas");
		 exit ();
		}

	   /* mmorisation du nombre de gnration sur fichier */

	   TVC [0] = gene;

	   /* Ecriture sur fichier. 1 article pour chaque rseau.
	      Le 1er article contient le nombre de gnration.(TVC [0])	*/

	   taille_int = (unsigned int) nb_connexion * (unsigned int) 2;

	   if ((write (handle,TVC,(size_t)(taille_int+2))) == -1)
		{
		 printf ("criture ne se fait pas");
		 printf ("handle %d ",handle);
		 exit ();
		}

	   indtab = (long)nb_connexion + (long)1;

	   for (i=2;i<nb_pop+1;i++)
	   {

	   if ((write (handle,&TVC[indtab],(size_t)taille_int)) == -1)
		{
		 printf ("criture ne se fait pas");
		 printf ("handle %d ",handle);
		 exit ();
		}

	   indtab = indtab + (long)nb_connexion;

	   }

	   /* fermeture fichier */

	   close (handle);

}

/*----------------------------------------------------------------*/
/* lecture du fichier afin de restituer la table des connexions
   prcdement mmorise */

restitution ()
{
	   int i,lect;
	   long indtab;
	   int handle;
	   unsigned int taille_int;

	   /* ouverture fichier */

	   if ((handle = open ("othel.don", O_RDWR | O_BINARY)) == -1)
		{
		 printf ("Ouverture fichier sauvegarde ne se fait pas");
		 exit ();
		}

	   /* Lecture du fichier des connexions. 1 article par rseau.
	      Le 1er article contient le nb de gnration. (TVC [0]) */

	   taille_int = (unsigned int) taille_1res;

	   lect = read (handle,TVC,(size_t)(taille_int+2));
	   if (lect == -1)
		{
		 printf ("lecture ne se fait pas");
		 printf ("handle %d ",handle);
		 exit ();
		}

	   indtab = (long)1+(long)nb_connexion;

	   for (i=2;i<nb_pop+1;i++)
	   {

	   lect = read (handle,&TVC[indtab],(size_t)taille_int);
	   if (lect == -1)
		{
		 printf ("lecture ne se fait pas");
		 printf ("handle %d ",handle);
		 exit ();
		}
	    indtab = indtab + (long)nb_connexion;
	   }

	   /* restitution du nombre de gnration */

	   gene = TVC[0];

	   /* fermeture du fichier */

	   close (handle);

}

/*--------------------------------------------------------------------------*/
/* Initialisation alatoire de toutes les connexions de tous les rseaux
   et du nombre de gnration. */

initalea()
{
	int i,j;
	long indj,k;
	for (j=1; j <nb_pop+ 1; j++)
	      {
			indj = (long)(j-1)*(long)nb_connexion;
			for (i=1; i < nb_connexion+1; i++)
			    {
				k = rand() - 16384;
				TVC [(long)(indj+(long)i)] = k;
			    }
	      }

	gene = 0;

}

/*----------------------------------------*/
/* initialisation du damier d'othello */

initdamier()
{
	char chain [25] = "                    ";

	memset (damier,0,(size_t)65);

	damier [28] = 1;
	damier [37] = 1;
	damier [29] = 2;
	damier [36] = 2;

	_setcolor (blanc);
	_settextposition(25,1);
	_setbkcolor(rouge);
	_settextcolor(cyan);
	sprintf (chain,"Gnration %d ",gene);
	_outtext(chain);

	if (car_aff != 'N')
	   affiche_damier();
}

/*------------------------------------------------------------------ */
/* affichage sur cran du damier */

affiche_damier ()
{
	  int i,j,ind_case,dam;

	  for (i=1;i<9;i++)
	    {
		for (j=1;j<9;j++)
		    {
			_settextposition(8+j,31+(i*2));
			ind_case = ((j-1)*8)+i;
			dam = damier[ind_case];
			if (dam==0)
			    {
			      _setbkcolor(magenta);
			      _outtext ("  ");
			    }
			else
			    if (dam==1)
				{
				    _setbkcolor(rouge);
				    _settextcolor(noir);
				    _outtext("");
				}
			    else
				{
				    _setbkcolor(jaune);
				    _settextcolor(bleu);
				    _outtext("[]");
				}
		    }
		}
	    _setbkcolor(bleu);
	    _settextcolor(blanc);
}

/*-----------------------------------------------------------*/
/* calcul du score en fonction du nombre pions sur le damier */

calcul_score()
{
    int i,tot1,tot2;

    tot1 = 0;
    tot2 = 0;

    for (i=1;i<65;i++)
	{
	    if (damier[i] == 1)
		    tot1++;
	    else
		{
		    if (damier[i] == 2)
			tot2++;
		}
	}

    if (tot1 > tot2)
	{
	score1 = score1 + 3;
	if ((tot1 - tot2) > 39)
	    score1++;
	}
    else
	{
	    if (tot1 < tot2)
		{
		score2 = score2 + 3;
		if ((tot2 - tot1) > 39)
		   score2++;
		}
	    else
		{
		score1++;
		score2++;
		}
	}
}

/*----------------------------------------*/
/* affichage du rsultat de la partie prcdente */

aff_vainc()
{
	char chain [30] = "                              ";
	_setbkcolor(rouge);
	_settextcolor(cyan);
	if (score1 > score2)
	  {
	  _settextposition(25,50);
	  sprintf (chain,"Vainqueur = Rseau %d ",a1);
	  _outtext(chain);
	  }
	else
	  {
	  if (score1 < score2)
	    {
	     _settextposition(25,50);
	     sprintf (chain,"Vainqueur = Rseau %d ",a2);
	     _outtext(chain);
	    }
	    else
	    {
	     _settextposition(25,50);
	     sprintf (chain,"Egalit entre %d et %d ",a1,a2);
	     _outtext(chain);
	    }
	  }
}

/*----------------------------------------*/
/* affichage des scores lors de la fin d'une manche */

aff_scores ()
{
	  int i,j;
	  char chain [60];

	  memset (chain,' ',(size_t)60);

	  _setbkcolor(bleu);
	  _clearscreen(_GCLEARSCREEN);
	  _setbkcolor(noir);
	  _settextcolor(cyan);
	  for (i=1;i<nb_pop;i=i+2)
	  {
	  j = (int)(i/2) + 1;
	  _settextposition(j,1);
	  sprintf (chain,"Score Rs. %d = %d Score Rs. %d = %d ",i,sco [i],i+1,sco[i+1]);
	  _outtext(chain);
	  }
}

/*----------------------------------------------------------*/
/* Affichage des numros des rseaux qui se battent en duel */

aff_duel (int a1,int a2)
{
	char chain [30] = "                              ";
	_setbkcolor(rouge);
	_settextcolor(cyan);
	_settextposition(25,20);
	sprintf (chain,"Rseau %d contre Rseau %d   ",a1,a2);
	_outtext(chain);
}

/*----------------------------------------------------------*/
/* Affichage du numro de rseau qui va concourir avec les
   meilleurs. */

aff_meilleur (int mj,int a)
{
	char chain [80] = "                              ";
	memset (chain,' ',(size_t)80);
	_setbkcolor(vert);
	_settextcolor(noir);
	_settextposition(21,1);
	if (a == 0)
	   {
	   sprintf (chain,"Le rseau %d, score = %d sera limin lors du prochain passage."
		     ,mj,sco[mj]);
	   _outtext(chain);
	   }
	else
	   {
	   sprintf (chain,"Le rseau %d est selectionn avec le score de %d.              "
		     ,mj,sco[mj]);
	   _outtext(chain);
	   }
}

/*----------------------------------------------------------*/
/* Affichage du score le meilleur.			    */

aff_best (int mj)
{
	char chain [80] = "                              ";
	memset (chain,' ',(size_t)80);
	_setbkcolor(noir);
	_settextcolor(jaune);
	_settextposition(20,1);
	sprintf (chain,"Le meilleur score de la manche est %d par le rseau %d. "
	       ,sco[mj],mj);
	_outtext(chain);
}

/*------------------------------------------------------------*/
/* Question sur la possibilit de prendre le prcdent rseau */

ques_init (void)
{
    /* possibilit de dmarrer l'apprentissage  partir d'une sauvegarde
	     ou bien en initialisant alatoirement tous les rseaux */

	  _settextposition(5,1);
	  _outtext (" Voulez-vous repartir de la situation prcdente (O/N) ?  ");
	  return (getch ());
}

/*------------------------------------------------------------*/
/* Question sur la possibilit de ne pas afficher les parties */

ques_naff ( void)
{
	  _settextposition(7,1);
	  _outtext (" Voulez-vous afficher les parties (O/N) ?  ");
	  return (getch ());
}

/*-------------------------------------------------------------------------*/
/* Ouverture du fichier contenant les rseaux ayant obtenus les
   meilleurs scores. Lecture du 1er enregistrement contenant la zone
   " craser". */

ouvrir_meilleur()
{
	   int lect;

	   /* ouverture du fichier "meilleur". */

	   if ((h_meil= open ("meilleur.don", O_RDWR | O_CREAT
		   | O_BINARY, S_IREAD | S_IWRITE)) == -1)
		{
		 printf ("Ouverture fichier meilleur ne se fait pas");
		 exit ();
		}

	   lect = read (h_meil,&a_ecraser,2);
	   if (lect == -1)
		{
		 printf ("lecture meilleur ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit ();
		}

}

/*----------------------------------------------------------------------*/
/* Chaque nouveau slectionn (score > 17) est confront aux autres.
   Celui qui obtient le moins bon score sera cras par l'arrivant de
   la prochaine slection. Cette information est stocke dans le premier
   enregistrement avec la zone " craser". */

meilleur(int mj)
{
	   int i,mauvais;
	   long nb_deplac,indsel;
	   int sco_stock [40];

	   /* On affiche sur l'cran le rseau selectionn. */

	   aff_meilleur(mj,1);

	   /* Positionnement sur le fichier sur le rseau  craser. */

	   nb_deplac = (long)taille_1res * ((long)a_ecraser-(long)1) + (long) 2;
	   lseek(h_meil,nb_deplac,SEEK_SET);

	   /* Calcul de l'indice du tableau des connexions correspondant
	      au 1er poste du rseau slectionn. */

	   indsel = (((long) mj - (long)1) * (long)nb_connexion) + (long)1;

	   /* Ecriture du rseau slectionn sur le fichier. */

	   if ((write (h_meil,&TVC[indsel],(unsigned int)taille_1res)) == -1)
		{
		 printf ("criture meilleur ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit ();
		}

	   /* On sauvegarde les rseaux normaux sur leur fichier. */

	   sauvres();

	   /* Mmorisation de la table des scores dans l'tat avant
	      l'excution de la manche "meilleur". */

	   for (i=1;i<nb_pop+1;i++)
		sco_stock[i]=sco[i];

	   /* On initialise la table des connexions TVC avec les rseaux
	      du fichier "meilleur". */

	   resti_meilleur();

	   /* On ralise une manche avec les rseaux "meilleur". Pour une
	      estimation plus fine du score on augmente le nombre de matchs,
	      soient 306 parties en 2 poules de 18 rseaux. */

	   manche_meilleur();

	   /* On va scrute la table des scores afin de dterminer le rseaux
	   le moins bon qui sera dsign " craser" pour la
	   prochaine slection. En mme temps on affiche le rseau qui sera
	   limin. */

	   aff_meilleur(ecrire_ecraser(),0);

	   /* On remet la table TVC dans l'tat avant l'accs au fichier
	      "meilleur". */

	   restitution();

	   /* Restitution de la table des scores dans l'tat avant
	      l'excution de la manche "meilleur". */

	   for (i=1;i<nb_pop+1;i++)
		sco[i]=sco_stock[i];

}

/*------------------------------*/
/* fermeture fichier "meilleur" */

fermer_meilleur()
{
	   /* fermeture fichier */

	   close (h_meil);

}

/*----------------------------------------------------------------*/
/* Lecture du fichier des "meilleur" rseaux afin de les mettre
   en mmoire dans la table des connexions TVC. */

resti_meilleur()
{
	   int i;
	   long indtab,lect;

	   /* Positionnement sur le 1er rseaux  lire. */

	   lseek(h_meil,2,SEEK_SET);

	   /* Lecture du fichier des connexions. 1 rseau par article. */

	   indtab = (long)1;

	   for (i=1;i<nb_pop+1;i++)
	   {

	    lect = read (h_meil,&TVC[indtab],(size_t)taille_1res);
	    if (lect == -1)
		{
		 printf ("lecture meilleur ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit ();
		}
	    indtab = indtab + (long)nb_connexion;
	   }
}

/*----------------------------------------------------------------*/
/* Une manche rassemble toutes les parties. Pour les "meilleur"
   tous les rseaux jouent entre eux.
   Ce qui fait 630 parties. */

manche_meilleur()
{
	  int i,j,k;

	  /* Initialisation de la table des scores  zro (dim = nb_pop).
	     soit 36 rseaux en comptition. (si nb_pop = 36) */

	  i = (nb_pop + 1)*2;
	  memset (sco,0,(size_t)i);

	  /* 1er poule */

	  k = nb_pop;

	  for (i = 1; i < k; i++)
	  {
			for (j = i+1; j < k+1; j++)
			{
				match(i,j);
			}
	  }

}

/*-----------------------------------------------------------------*/
/* On parcourt les scores afin de dterminer celui qui sera limin
   lors de la prochaine slection. On crit ensuite cette info sur
   le fichier "meilleur". (1er donne du fichier) */

int ecrire_ecraser()
{
	  int i,mauvais;

	  /* Parcours de la table des scores. */

	  mauvais = 1;
	  for (i=2;i<nb_pop + 1;i++)
	  {
	    if (sco [i] < sco [mauvais])
	       mauvais = i;
	  }

	  /* Positionnement en dbut de fichier. */

	  lseek(h_meil,0,SEEK_SET);

	  /* Ecriture de l'indice du rseau  craser lors de la prochaine
	     slection. */

	  a_ecraser = mauvais;

	  if (write (h_meil,&a_ecraser,2) == -1)
		{
		 printf ("criture a_ecraser ne se fait pas");
		 printf ("h_meil %d ",h_meil);
		 exit ();
		}

	  return (mauvais);
}

/*---------------------- Fin programme Othello ----------------------------*/
