#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <memory.h>
#include <string.h>
#include <graph.h>
#include <malloc.h>
#include <limits.h>
#include <sys\timeb.h>
#include <sys\types.h>
#include <sys\stat.h>

#define  bleu	 1
#define  cyan	 3
#define  vert	 2
#define  rouge	 4
#define  magenta 5
#define  noir	 0
#define  blanc	 15
#define  brun	 6
#define  gris	 8
#define  jaune	 14
#define PI 3.1415926535897932

/* Quand le nombre de pas atteind le max_faim la fourmi reviendra
   automatiquement  la fourmilire. */

#define	max_faim 2000

/* Nombre maximun de poste dans la table info (communication) */

#define	max_info 200

/* Prototype de fonctions aux retours particuliers. */

long int calcul_vot (void);
long int arrondi (double val);

/* Tables dfinissant les fourmis. */

static int _far *x_fourmi;
static int _far *y_fourmi;
static int _far *mem_fourmi;
static int _far *xdes_fourmi;
static int _far *ydes_fourmi;
static int _far *pas_fourmi;
static int _far *dir_fourmi;
static int _far *info_x;
static int _far *info_y;
static int _far *info_num;
static int _far *obstacle;
static int _far *perdu;

/* Table des votes pour les directions  choisir. */

static long vot [5];

/* Zone de calcul des quatre directions que peut prendre une fourmi. */

static int dir[5];

/* Coordonnes de la fourmilire. */

static int xf = 320;
static int yf = 225;

/* Direction ' droite de', ' gauche de' et 'oppos '. */

int droite [5] = {0,4,3,1,2};
int gauche [5] = {0,3,4,2,1};
int oppose [5] = {0,2,1,4,3};

/* Delta des 8 directions. */

static int xd [9] = {0,0,0,-1,1,1,1,-1,-1};
static int yd [9] = {0,-1,1,0,0,-1,1,1,-1};

/* Table de dtection de la nourriture. */

static int nourriture [9];

/* Numro de la fourmi traite en cours. */

static int num;

/* Nombre de fourmis totales simules. */

static int nb_fourmi;

/* Indicateur de prsence d'une fourmi contigu  celle traite en cours. */

static int presence_fourmi;

/* Direction (1,2,3 ou 4) vers laquelle la fourmi  le plus de chance
   d'aller. */

static int dir_des;
static int dir_retour;

/* Nombre de postes de la table info remplis (+ 1). */

static int cur_info;

/* Nourriture senti par la fourmi. */

static int nour_detect;

/* Indicateur de mise en mmoire collective. */

static int deja_verse;

/*------------------------------------------------------------------------*/
/* Simulation d'une fourmilre.         */

void main (void)
{
	  int i;
	  char nb;

	  saisie_parametres();

	  init_alea();

	  init_tables();

	  init_ecran ();

	  init_fourmi();

	  do
	       {

	       /* Initialisation du compteur La table info. */

	       cur_info = 1;

	       for (i=1;i<nb_fourmi+1;i++)
		{

		 /* Incrmentation de nombre de pas de la fourmi. */

		 pas_fourmi [i] = pas_fourmi [i] + 1;

		 /* Test d'arrt de la boucle. */

		 if (kbhit ())
		   nb = getch ();
		 if (nb == 'a')
		    getch();
		 /* La fourmi ne sort que lorsque son nombre de pas est
		    positif. */

		 if (pas_fourmi[i] > 0)
		   {

		    num = i;
		    simul_fourmi ();

		   }
		}

	       /* Gestion du retour de la fourmi  la
		  fourmilre. */

	       gestion_retour ();

	       }
	  while (nb != 'F' && nb != 'f');

	  libe_memoire();

}

/*------------------------------------------------------------------*/
/* Simulation d'une fourmi. En sortie de la fonction calcul_vot
   toutes les tendances de la fourmi ont vote pour la direction qu'elles
   prconisaient. Il ne reste qu' choisir alatoirement la direction,
   pondre par les votes calculs. */

simul_fourmi ()
{
	  int j;
	  long vot_tot;

	  /* Le rsultat du vote et dans la table vot. vot_tot est
	     le cumul des votes des quatre directions. */

	  vot_tot = calcul_vot();

	  /* j = 1, 2, 3 ou 4. 1 = haut, 2 = bas, 3 = gauche, 4 = droite. */

	  j = choix_direction (vot_tot);

	  /* On mmorise la direction vers laquelle la fourmi se dirige.
	     Ceci permetra de ne pas faire de nombreux aller-retours
	     afin d'viter qu'elle fasse  du surplace. */

	  dir_fourmi [num] = j;

	  /* Calcul des nouvelles coordonnes de la fourmi, avec effacement
	     des anciennes coordonnes. Le dplacement ne peut se faire
	     si une autre fourmi se trouve dj prsente sur la case ou
	     si elle rencontre une obstacle rouge. */

	  affiche_fourmi (j);

	  /* Lorsque le but est atteind et que la nourriture
	     n'est pas trouve, il y a choix alatoire
	     d'une autre direction. */

	  gestion_nourriture();
}

/*------------------------------------------------------------------*/
/* On efface d'abord le pixel de la fourmi, on calcul son dplacement,
   puis on affiche le nouveau pixel. La couleur grise doit tre ignore,
   elle represente quelques dcors. La couleur rouge represente les obstacles
   et les bords du jeu. La couleur brune represente la nourriture. */

affiche_fourmi (int j)
{
	  int xi,yi,couleur;

	  xi = x_fourmi [num];
	  yi = y_fourmi [num];

	  /* On ignore les pixels gris. */

	  if (_getpixel (xi,yi) != gris)
	    {
	     _setcolor(noir);
	     _setpixel (xi,yi);
	    }

	  xi = xi + xd [j];
	  yi = yi + yd [j];

	  couleur = _getpixel (xi,yi);

	  /* Obstacle = rouge. */

	  if (couleur != rouge)
	    {

		/* Si la fourmi rencontre une fourmi, le dplacement
		   ne se fait pas. */

		if (couleur != blanc)
		  {

		   /* Si la fourmi rencontre de la nourriture
		      son nombre de pas grandi. */

		   if (couleur == brun)
		      pas_fourmi [num] = pas_fourmi [num] + 200;

		   x_fourmi [num] = xi;
		   y_fourmi [num] = yi;

		   if (couleur != gris)
		    {
		      _setcolor(blanc);
		      _setpixel (xi,yi);
		    }
		  }
		else
		 {
		   if (couleur != gris)
		       gestion_obstacle();
		 }
	     }
	    else
	     {
		if (couleur != gris)
		    gestion_obstacle();
	     }

}

/*------------------------------------------------------------------*/
/* Si la fourmi bute sur un obstacle, celle-ci vera son dplacement
   modifi. */

gestion_obstacle ()
{
    /* Si un obstacle est rencontr, on redessine le pixel
       ou la fourmi se trouve. */

    _setcolor (blanc);
    _setpixel (x_fourmi[num],y_fourmi[num]);

}

/*------------------------------------------------------------------*/
/* Aprs avoir vot, le choix de la direction se fait alatoirement
   au prorata des votes effectus. */

int choix_direction (long vot_tot)
{
	  int i,j;
	  float alea,tempo;
	  long roue[5];

	  memset (roue,0,(size_t)20);

	  tempo = 32767. / (float) vot_tot;

	  for (i=1;i<5;i++)
	    {
	      roue [i] = roue [i-1] +
			 arrondi ((double)((float)vot [i] * tempo));
	    }

	  /* Tirage alatoire de la direction sur la roue. */

	  alea = rand ();

	  for (j=1;roue[j] < alea && j < 4;j++);

	  return (j);

}

/*------------------------------------------------------------------*/
/* Gestion de la nourriture transporte et dtecte. */

gestion_nourriture ()
{
     if (x_fourmi [num] == xdes_fourmi [num] &&
	 y_fourmi [num] == ydes_fourmi [num] &&
	 nour_detect == 0)
	 choix_dest (num);
}

/*------------------------------------------------------------------*/
/* Gestion du retour de la fourmi dans la fourmilire, de sa mmoire
   et de son compteur de pas. */

gestion_retour ()
{
	  int i,xi,yi;

	  /* On efface le pixel qui symbolise la fourmilire, afin que les
	     fourmis puissent y entrer. */

	  _setcolor (noir);
	  _setpixel (320,225);

	  for (i=1;i<nb_fourmi+1;i++)
	    {

	     xi = x_fourmi [i];
	     yi = y_fourmi [i];

	     /* Si la fourmi est de retour dans la fourmilire, alors on remet le
		compteur de pas  -30, afin qu'elle reste 30 pas dans la fourmilire
		avant de sortir. De plus sa mmoire nourriture est remise  0, ainsi
		que ses coordonnes de destination. */

	     if (pas_fourmi [i] > 50 && xi == 320 && yi == 225)
	       {
		pas_fourmi [i] = - 30;
		if (mem_fourmi [i] > 0)
		   {

		    /* La mmoire dcrot avec le temps. */

		    mem_fourmi [i] = mem_fourmi [i] - 4;

		   }
		else
		   {
		    choix_dest(i);
		   }
	       }
	    }
}

/*----------------------------------------------------------------*/
/* Un vote s'effectue sur les quatre directions possibles de la fourmi.
   Un premier pour sortir de la fourmilire et effectuer une ventuelle
   mission, et un autre pour le retour lorsque la faim se fait sentir.
   Les autres votes sont dfinis au niveau de la fonction. */

long int calcul_vot ()
{

	  vot [1] = 1;
	  vot [2] = 1;
	  vot [3] = 1;
	  vot [4] = 1;

	  /* On sent la nourriture, les phromones et les fourmis. */

	  sentir();

	  /* La destination et le retour ne sont pas sollicit lorsque
	     une fourmi bute sur un obstacle. faux ! */

	  destination ();

	  retour_fourmiliere ();

	  if (vot[dir_retour] >= vot[dir_des])
	    dir_des = dir_retour;

	  /* La variable prsence de la fourmi est valorie dans sentir
	     nourriture. La communication ne se fait, bien sr, que si
	     une fourmi se trouve  ct. */

	  if (presence_fourmi == 1)
	    {
	     communication();
	    }

	  /* On regarde sur les pixels. */

	  regard_obstacle ();

	  if (pas_fourmi [num] > 1 && obstacle [num] == 0)
	     retour_arriere ();

	  if (pas_fourmi [num] > (3 * max_faim))
	     deplac_perdu();

	  return (vot[1] + vot [2] + vot[3] + vot [4]);
}

/*------------------------------------------------------------------------*/
/* Vote pour la destination. Plus le nombre de pas de la fourmi est
   petit, plus le vote est important dans la direction de la destination. */

destination ()
{
	  float ratio;

	  /* calcul du vote --> quand le nombre de pas est petit
	     la fourmi se dirige vers sa destination. */

	  ratio = ((float)max_faim) / ((float)pas_fourmi [num]);
    /*	  ratio = ratio * ratio;   */

	  dir_des = meilleur_trajet (xdes_fourmi[num],ydes_fourmi[num],
			   x_fourmi[num],y_fourmi[num]);

	  vot [1] = vot[1] + arrondi ((double)((float)ratio * (float)dir[1]));
	  vot [2] = vot[2] + arrondi ((double)((float)ratio * (float)dir[2]));
	  vot [3] = vot[3] + arrondi ((double)((float)ratio * (float)dir[3]));
	  vot [4] = vot[4] + arrondi ((double)((float)ratio * (float)dir[4]));
}

/*-----------------------------------------------------------------------*/
/* Retour  la fourmilire. Plus le nombre de pas est lev, plus le vote
   en direction de la fourmilre est important. */

retour_fourmiliere ()
{
	  float ratio;

	  /* calcul du vote --> quand le nombre de pas dpasse la faim
	     la fourmi prend la direction de la fourmilire,
	     son dplacement vers l'extrireur est innib. */

	  ratio = ((float) pas_fourmi [num]) / ((float) max_faim);
      /*  ratio = ratio * ratio;  */

	  dir_retour =	meilleur_trajet (xf,yf,x_fourmi [num],y_fourmi [num]);

	  vot [1] = vot[1] + arrondi ((double)((float)ratio * (float)dir[1]));
	  vot [2] = vot[2] + arrondi ((double)((float)ratio * (float)dir[2]));
	  vot [3] = vot[3] + arrondi ((double)((float)ratio * (float)dir[3]));
	  vot [4] = vot[4] + arrondi ((double)((float)ratio * (float)dir[4]));
}

/*-----------------------------------------------------------------------*/
/* Afin d'viter du surplace, on inhibe les dplacements qui font reculer
   les fourmis. On a mmoris au pralable le dernier dplacement. On inhibe
   donc le dplacement oppos. */

retour_arriere()
{
    vot [oppose[dir_fourmi [num]]] = 1;
}

/*-----------------------------------------------------------------------*/
/* On inhibe tous les dplacements vers les obstacles.			 */

regard_obstacle ()
{
    int i,xi,yi,x,y;
    int obstacle_trouve;

    xi = x_fourmi [num];
    yi = y_fourmi [num];

    obstacle_trouve = 0;

    for (i=1;i<5;i++)
	{
	 x = xi + xd[i];
	 y = yi + yd[i];
	 if (_getpixel(x,y) == rouge)
	    {
	     vot [i] = 1;
	     if (dir_des == i)
		obstacle_trouve = 1;
	    }
	}

    if (obstacle_trouve == 1 && obstacle [num] == 0)
	{
	    obstacle [num] = 2;
	    contourner_obstacle();
	}
      else
	{
	 if (obstacle [num] > 0)
	   {
	    obstacle [num]--;
	    contourner_obstacle();
	   }
	}

}

/*------------------------------------------------------------------------*/
/* Lorsque un obstacle est dcouvert, la fourmi choisi une destination
   intermdiaire afin de contourner l'obstacle. */

contourner_obstacle ()
{
   int i,j,n,pas;
   int *parla;

   n = 0;
   pas = pas_fourmi[num];

   for (i=1;i<50 && n != 2;i++)
    {
      if (n == 0)
       {
	parla = droite;
	n = 1;
       }
      else
       {
	parla = gauche;
	n = 0;
       }

      if (pas < (i*200))
	 n = 2;
     }

   i = dir_des;
   j = 0;

   while ((vot[parla[i]] == (1 || oppose[dir_fourmi[num]])) && j < 4)
    {
	i = parla[i];
	j++;
    }

    vot[1] = 1;
    vot[2] = 1;
    vot[3] = 1;
    vot[4] = 1;

    if (j!=4)
       {
	   vot [parla[i]] = 18;

	   if (obstacle[num] == 0)
	     {
	      if ((parla[i] == oppose [dir_des])     ||
		  (parla[i] == droite [dir_des] && n == 0) ||
		  (parla[i] == gauche [dir_des] && n == 1))
		  obstacle [num] = 1;
	     }
       }
}

/*-----------------------------------------------------------------------*/
/* Au del d'un certain nombre de pas de la fourmi, son dplacement devient
   alatoire. */

deplac_perdu()
{
    if (perdu[num] == 0)
      {
       vot[1] = 1;
       vot[2] = 1;
       vot[3] = 1;
       vot[4] = 1;
       perdu[num] = 1000;
      }
    else
      {
       perdu[num]--;
       if (perdu[num] > 199)
	{
	    vot[1] = 1;
	    vot[2] = 1;
	    vot[3] = 1;
	    vot[4] = 1;
	}
      }
}

/*-----------------------------------------------------------------------*/
/* On scrute les pixels autour de la fourmi et on comptabilise les pixels
   brun sur lesquels la nourriture se trouve. Le vote portera dans la
   direction o la fourmi aurra senti le plus de nourriture. On en profite
   de plus pour dtecter la prsence ventuelle d'une fourmi. On comptabilise
   en parallle les pixels magenta, ceux-ci sont des phromones qui peuvent
   eux-aussi influer sur les dplacements. */

sentir()
{
    int x,y,x0,y0;
    int i,k,m,couleur;

    nour_detect = 0;

    memset (nourriture,0,18);

    x = x_fourmi [num];
    y = y_fourmi [num];

    /* Initialisation de l'indicateur de prsence d'une fourmi. */

    presence_fourmi = 0;

    /* On regarde dans les huits directions. */

    for (k=1;k<9;k++)
	{

	  x0 = x;
	  y0 = y;

	  /* Pour les pixels contigus, on regarde s'il y a prsence
	     d'une fourmi. */

	  x0 = x0 + xd [k];
	  y0 = y0 + yd [k];

	  couleur = _getpixel (x0,y0);

	  if (couleur == brun)
	     nourriture [k] = nourriture [k] + 4;
	   else
	    {
	     if (couleur == blanc)
		 presence_fourmi = 1;
	    }

	  for (i=2;i<7;i++)
	     {
		 x0 = x0 + xd [k];
		 y0 = y0 + yd [k];

		 couleur = _getpixel (x0,y0);

		 if (couleur == brun)
		    nourriture [k]++;

	     }
	  nour_detect = nour_detect + nourriture [k];
	}

    /* Quand la faim se fait sentir, la fourmi n'est plus influence
       dans son dplacement par la nourriture. */

    if (pas_fourmi [num] <= max_faim)
       {
	    if (nour_detect != 0)
		detect_nourriture();
       }

  /* La fourmi mmorise l'endroit o elle a senti le plus de nourriture.
       Cela dterminera sa future destination. */

    if (nour_detect > mem_fourmi[num])
	{
	    mem_fourmi [num]  = nour_detect;
	    xdes_fourmi [num] = x;
	    ydes_fourmi [num] = y;
	}
}

/*-----------------------------------------------------------------------*/
/* Les votes s'effectueront dans la direction o il y aura le plus
   de nourriture. */

detect_nourriture ()
{
	   int i,dir_nour;

	   /* Les directions intermdiaires (5,6,7,8) sont cumules avec
	      les directions principales (1,2,3,4). */

	   nourriture [1] = nourriture [1] + nourriture [5] + nourriture [8];
	   nourriture [2] = nourriture [2] + nourriture [6] + nourriture [7];
	   nourriture [3] = nourriture [3] + nourriture [7] + nourriture [8];
	   nourriture [4] = nourriture [4] + nourriture [5] + nourriture [6];

	   /* On determine la direction en fonction du meilleur rsultat obtenu
	      avec la table nourriture. */

	   dir_nour = 1;
	   for (i=2;i<5;i++)
	   {
	     if (nourriture [i] > nourriture [dir_nour])
		 dir_nour = i;
	   }

	   vot [dir_nour] = vot [dir_nour] + (long)(nourriture[dir_nour]*7);
}

/*-----------------------------------------------------------------------*/
/* On teste les pixels autour de la fourmi, afin de savoir ou se trouve
   l'autre ou les autres fourmis. Par le biais d'une table collective,
   elles communiqueront et changeront leurs informations. */

communication ()
{
       int i,x,y,x0,y0;

       x = x_fourmi [num];
       y = y_fourmi [num];

       /* Indicateur de mise en mmoire. On ne met qu'une seule fois
	  les donnes de la fourmi dans la mmoire collective. */

       deja_verse = 0;

       for (i=1;i<9;i++)
	{
	  x0 = x + xd [i];
	  y0 = y + yd [i];

	  if (_getpixel (x0,y0) == blanc)
	     mem_collective(x0,y0);
	}
}

/*-----------------------------------------------------------------------*/
/* Mmoire collective. Ds qu'une fourmi se trouve  ct d'une autre,
   sa mmoire est dverse dans une mmoire collective afin
   qu'il y ait un change d'information entre fourmis. */

mem_collective (int x, int y)
{
       int i;

       for (i=1;i<max_info && i<cur_info &&
	    (info_x [i] != x || info_y [i] != y);i++);

       if (i >= max_info)
	 {
	  printf("Table communication sature !");
	  exit(0);
	 }
	else
	 {
	  if (i != cur_info)
	     echange_info (info_num [i]);
	  else
	     deverse_info ();
	 }
}

/*-----------------------------------------------------------------------*/
/* Echange des informations entre deux fourmis contigus. */

echange_info (int i)
{

    if (mem_fourmi [num] > mem_fourmi [i])
       {
	mem_fourmi [i]	= mem_fourmi [num]-4;
	xdes_fourmi [i] = xdes_fourmi [num];
	ydes_fourmi [i] = ydes_fourmi [num];
       }
    else
       {
       if (mem_fourmi [i] > mem_fourmi [num])
	 {
	  mem_fourmi [num]  = mem_fourmi [i]-4;
	  xdes_fourmi [num] = xdes_fourmi [i];
	  ydes_fourmi [num] = ydes_fourmi [i];
	 }
       }
}

/*-----------------------------------------------------------------------*/
/* Les coordonnes de la fourmi ainsi que son indice sont transfrs
   dans la mmoire de communication. */

deverse_info ()
{
    if (deja_verse == 0)
       {
	info_x [cur_info]   = x_fourmi [num];
	info_y [cur_info]   = y_fourmi [num];
	info_num [cur_info] = num;
	cur_info++;
	deja_verse = 1;
       }
}

/*-----------------------------------------------------------------------*/
/* Arrondi de valeur double en entier. */

long int arrondi(double val)
{
	  long val_plaf;
	  double dif_val;
	  long retour;

	  val_plaf = (long)ceil ((double)val);
	  dif_val = (double)val_plaf - val;

	  if (dif_val > 0.500000)
	     retour = val_plaf - 1;
	    else
	     retour = val_plaf;

	  return(retour);
}

/*-------------------------------------------------------------------------*/
/* Entre deux points distants, il s'agit de choisir la meilleure direction
    prendre entre les quatre. */

int meilleur_trajet (int xd,int yd,int x, int y)
{
	  int difx,dify;
	  int dir_tra;

	  difx = xd - x;
	  dify = yd - y;

	  if (difx < 0 && dify > 0)
		{
		 if (abs(difx) > dify)
		   {
		    dir_tra = 3;
		    dir [3] = 4;
		    dir [2] = 3;
		    dir [1] = 2;
		    dir [4] = 1;
		   }
		 else
		   {
		    dir_tra = 2;
		    dir [2] = 4;
		    dir [3] = 3;
		    dir [4] = 2;
		    dir [1] = 1;
		   }
		}
	  else
		{
		 if (difx < 0 && dify < 0)
		    {
			if (abs(difx) > abs(dify))
			   {
			    dir_tra = 3;
			    dir [3] = 4;
			    dir [1] = 3;
			    dir [2] = 2;
			    dir [4] = 1;
			   }
			else
			   {
			    dir_tra = 1;
			    dir [1] = 4;
			    dir [3] = 3;
			    dir [4] = 2;
			    dir [2] = 1;
			   }
		    }
		 else
		    {
		    if (difx > 0 && dify < 0)
			{
			 if (difx > abs(dify))
			    {
			     dir_tra = 4;
			     dir [4] = 4;
			     dir [1] = 3;
			     dir [2] = 2;
			     dir [3] = 1;
			    }
			 else
			    {
			     dir_tra = 1;
			     dir [1] = 4;
			     dir [4] = 3;
			     dir [3] = 2;
			     dir [2] = 1;
			    }
			}
		    else
			{
			 if (difx > 0 && dify > 0)
			    {
				if (difx > dify)
				   {
				    dir_tra = 4;
				    dir [4] = 4;
				    dir [2] = 3;
				    dir [1] = 2;
				    dir [3] = 1;
				   }
				else
				   {
				    dir_tra = 2;
				    dir [2] = 4;
				    dir [4] = 3;
				    dir [3] = 2;
				    dir [1] = 1;
				   }
			    }
			}
		    }
		}
	    return (dir_tra);
}

/*---------------------------------*/
/* Initialisation des tables */

init_tables()
{
	  /* Table des abcisses des coordonnes des fourmis. */

	  if ((x_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de x_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table des ordonnes des coordonnes des fourmis. */

	  if ((y_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de y_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table de la mmoire nourriture des fourmis. */

	  if ((mem_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de mem_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table des abcisses de l'endroit o se trouve la nourriture
	     mmorise. */

	  if ((xdes_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de xdes_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table des ordonnes de l'endroit o se trouve la nourriture
	     mmorise. */

	  if ((ydes_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de ydes_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table des pas fait depuis la sortie de la fourmilire. */

	  if ((pas_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de pas_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table de la dernire direction prise par la fourmi. */

	  if ((dir_fourmi = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de dir_fourmi ne se fait pas");
		 exit (0);
		}

	  /* Table des abcisses dans la table info. */

	  if ((info_x = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de info_x ne se fait pas");
		 exit (0);
		}

	  /* Table des ordonnes dans la table info.	*/

	  if ((info_y = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de info_y ne se fait pas");
		 exit (0);
		}

	  /* Table de l'indice de la fourmi dans la mmoire collective. */

	  if ((info_num = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de info_num ne se fait pas");
		 exit (0);
		}

	  /* Table boolenne de prsence d'obstacles. */

	  if ((obstacle = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de obstacle ne se fait pas");
		 exit (0);
		}

	  /* Table mmorisant le fait que la fourmi soit perdue. */

	  if ((perdu = (int _far *) _fmalloc ((size_t)2000)) == NULL)
		{
		 printf ("Alloction mmoire de obstacle ne se fait pas");
		 exit (0);
		}
}

/*------------------------------------------------------------------*/
/* Libration de la mmoire alloue.	*/

libe_memoire()
{
	  _ffree (x_fourmi);
	  _ffree (y_fourmi);
	  _ffree (mem_fourmi);
	  _ffree (xdes_fourmi);
	  _ffree (ydes_fourmi);
	  _ffree (pas_fourmi);
	  _ffree (dir_fourmi);
	  _ffree (info_x);
	  _ffree (info_y);
	  _ffree (info_num);
	  _ffree (obstacle);
	  _ffree (perdu);
}

/*------------------------------------------------------------------*/
/* La fonction alatoire est dfinie avec l'horloge du micro */

init_alea()
{
	  struct timeb temps;
	  ftime (&temps);
	  srand (temps.millitm);
}

/*-----------------------------------------------------------------------*/
/* Affiche le nombre de pas qu'ont fait les fourmis */

affiche_pas(int nb_pas)
{
	char chain [25] = "                    ";

	_setcolor (blanc);
	_settextposition(30,1);
	_setbkcolor(rouge);
	_settextcolor(cyan);
	sprintf (chain,"Pas %d ",nb_pas);
	_outtext(chain);
}

/*-------------------------------------------------------------------*/
/* Initialisation de l'cran de la simulation de la fourmilire.     */

init_ecran ()
{
	  int i;
	  int x,y;
	  float xn,yn;
	  _setvideomode (_VRES16COLOR);
	  _clearscreen (_GCLEARSCREEN);
	  _setcolor(rouge);
	  _rectangle (_GBORDER,0,0,639,450);

	  /* Obstacles. */

  /*	  _moveto (300,150);
	  _lineto (200,200);
	  _setpixel (250,175);
	  _ellipse (_GBORDER,245,130,255,220);	 */

 /*	  _setpixel (260,195);
	  _ellipse (_GBORDER,215,150,285,200);	  */

	  _setcolor(brun);
	  for (i=1;i<101;i++)
	    {
	       xn = ((float)rand () /32767.)*639.;
	       yn = ((float)rand () /32767.)*450.;
	       x = (int) xn;
	       y = (int) yn;
	       _setpixel (x,y);
	    }
	  _settextcolor(brun);
    /*	  _settextposition(20,27);
	  _outtext ("");
	  _settextposition(21,27);
	  _outtext ("");
	  _settextposition(22,27);
	  _outtext ("");	  */
	  _settextposition(10,27);
	  _outtext ("");
	  _settextposition(7,65);
	  _outtext ("");
	  _settextposition(8,65);
	  _outtext ("");
	  _settextposition(9,65);
	  _outtext ("");
	  _setcolor(gris);
	  _setpixel (320,225);
	  _ellipse (_GBORDER,314,219,326,231);
}

/*----------------------------------------*/
/*   Initialisation des tables "fourmis". */

init_fourmi ()
{
	  int i,alea;

	  _fmemset (dir_fourmi,0,2000);
	  _fmemset (obstacle,0,2000);
	  _fmemset (perdu,0,2000);

	  for (i=1;i<nb_fourmi+1;i++)
	    {
	       x_fourmi [i] = 320;
	       y_fourmi [i] = 225;
	       choix_dest (i);
	       alea = (int)arrondi((double)((float)((float)rand() / 32767.)
			* (float)1000)) - 1000;
	       pas_fourmi [i] = alea;
	    }
}

/*------------------------------------------------------------------*/
/* Choix aleatoire de la destination de la fourmi.		    */

choix_dest (int i)
{
	double dist;
	double angle;

	dist = (((double)rand()/(double)32767)*230 ) + 20;
	angle = ((double)rand()/(double)32767)*((double)PI*(double)2);

	mem_fourmi  [i]	= 1;
	xdes_fourmi [i] = 320+(int)arrondi(cos(angle)*(double)dist);
	ydes_fourmi [i] = 225+(int)arrondi(sin(angle)*(double)dist);
}

/*----------------------------------------------------------------------*/
/*	Saisie des parmtres.	*/

saisie_parametres()
{
	  char chain [10];
	  memset (chain,' ',(size_t)10);
	  _setvideomode(_TEXTC80);
	  _setbkcolor(bleu);
	  _clearscreen(_GCLEARSCREEN);
	  _setbkcolor(noir);
	  _settextcolor(rouge);
	  _settextposition(1,10);
	  _outtext(" Simulation d'une fourmilire. ");
	  _settextposition(3,1);
	  _outtext("Nombre de fourmi pour cette simulation : " );
	  scanf("%d", &nb_fourmi);
	  sprintf(chain," %d \n",nb_fourmi);
	  _settextposition(3,50);
	  _outtext (chain);
}
